/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.ai.HalloweenVillagerAI;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EatCandy
extends Behavior<Villager> {
    private int eatingTime;
    private int cooldown = 0;

    public EatCandy(int minDur, int maxDur) {
        super(Map.of(), minDur, maxDur);
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (pOwner.m_6274_().m_21874_(MemoryModuleType.f_26372_)) {
            pOwner.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        return HalloweenVillagerAI.hasCandyOrApple(pOwner.m_35311_());
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.m_6735_(pLevel, (LivingEntity)pEntity, pGameTime);
        this.cooldown = 20 * (3 + pLevel.f_46441_.m_188503_(4)) + pLevel.f_46441_.m_188503_(20);
        pEntity.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        pEntity.m_21573_().m_26573_();
        this.eatingTime = 80;
        SimpleContainer inventory = pEntity.m_35311_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            if (!HalloweenVillagerAI.isCandyOrApple(itemstack)) continue;
            ItemStack s = itemstack.m_41620_(1);
            if (itemstack.m_41613_() == 0) {
                inventory.m_6836_(i, ItemStack.f_41583_);
            }
            pEntity.m_21008_(InteractionHand.MAIN_HAND, s);
        }
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return this.eatingTime > 0 && HalloweenVillagerAI.isCandyOrApple(pEntity.m_21205_());
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        if (this.eatingTime-- < 50) {
            ItemStack stack = pOwner.m_21205_();
            if (stack.m_41619_()) {
                return;
            }
            if (this.eatingTime % 2 == 0) {
                Vec3 pos = new Vec3(0.0, 0.0, 0.09);
                pos = pos.m_82524_(-pOwner.m_146908_() * ((float)Math.PI / 180));
                pos = pos.m_82520_(pOwner.m_20185_(), pOwner.m_20188_(), pOwner.m_20189_());
                pLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), pos.f_82479_, pos.f_82480_ - 0.2, pos.f_82481_, 2, 0.03, 0.05, 0.03, 0.0);
            }
            if (this.eatingTime % 5 == 0) {
                pOwner.m_5496_(pOwner.m_7866_(stack), 0.3f + 0.4f * (float)pLevel.f_46441_.m_188503_(2), (pLevel.f_46441_.m_188501_() - pLevel.f_46441_.m_188501_()) * 0.2f + 1.3f);
            }
        }
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        ItemStack stack;
        Item item;
        super.m_6732_(pLevel, (LivingEntity)pEntity, pGameTime);
        if (pEntity.m_6162_() && this.eatingTime <= 0 && (item = (stack = pEntity.m_21205_()).m_41720_()) != Items.f_41852_) {
            pEntity.m_146762_(pEntity.m_146764_() - 6000);
            pEntity.m_5634_(0.5f);
            item.m_5922_(stack, (Level)pLevel, (LivingEntity)pEntity);
        }
        pEntity.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
    }
}

