/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.ai.IHalloweenVillager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class AskCandy
extends Behavior<Villager> {
    private int lookTime;
    private boolean gotCandy = false;
    private LivingEntity currentVillager = null;

    public AskCandy(int minDuration, int maxDuration) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26374_, (Object)MemoryStatus.VALUE_PRESENT), minDuration, maxDuration);
    }

    public boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        LivingEntity target = this.isTargetValid(pLevel, pOwner);
        return target != null && pOwner.m_20280_((Entity)target) <= 12.5;
    }

    @Nullable
    public LivingEntity isTargetValid(ServerLevel level, Villager owner) {
        Brain brain = owner.m_6274_();
        LivingEntity livingentity = brain.m_21952_(MemoryModuleType.f_26374_).orElse(null);
        if (livingentity != null && (livingentity.m_6095_() == EntityType.f_20492_ || livingentity.m_6095_() == EntityType.f_20495_) && livingentity.m_6084_() && owner.m_6162_()) {
            return livingentity;
        }
        return null;
    }

    public boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        if (this.gotCandy || this.lookTime <= 0) {
            return false;
        }
        LivingEntity target = this.isTargetValid(pLevel, pEntity);
        return target != null && pEntity.m_20280_((Entity)target) <= 20.0;
    }

    public void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        LivingEntity target;
        super.m_6735_(pLevel, (LivingEntity)pEntity, pGameTime);
        this.currentVillager = target = this.lookAtTarget(pEntity);
        this.keepVillageAwake(target);
        target.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        AskCandy.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.f_151058_));
        BehaviorUtils.m_22602_((LivingEntity)pEntity, (LivingEntity)target, (float)0.5f);
        this.lookTime = 200;
        this.gotCandy = false;
    }

    public void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        LivingEntity target = this.lookAtTarget(pOwner);
        --this.lookTime;
        this.keepVillageAwake(target);
        if (!pOwner.m_21205_().m_150930_(Items.f_151058_)) {
            this.gotCandy = true;
        }
    }

    private void keepVillageAwake(LivingEntity target) {
        if (target instanceof Villager) {
            Villager v = (Villager)target;
            target.m_6274_().m_21879_(MemoryModuleType.f_26329_, (Object)(target.m_9236_().m_46467_() - 1L));
            if (target.m_5803_()) {
                target.m_5796_();
                target.m_6274_().m_21936_(MemoryModuleType.f_26380_);
                target.m_9236_().m_7605_((Entity)target, (byte)26);
                target.m_6274_().m_21889_(Activity.f_37982_);
            }
        }
    }

    public void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.m_6732_(pLevel, (LivingEntity)pEntity, pGameTime);
        AskCandy.clearHeldItem(pEntity);
        if (!this.gotCandy) {
            Brain brain = pEntity.m_6274_();
            if (this.currentVillager instanceof Villager && this.currentVillager.m_6084_() && !this.currentVillager.m_6162_()) {
                pLevel.m_7605_((Entity)pEntity, (byte)13);
                if (pLevel.f_46441_.m_188503_(10) < 7) {
                    brain.m_21879_(MemoryModuleType.f_26372_, (Object)this.currentVillager);
                    if (pEntity instanceof IHalloweenVillager) {
                        IHalloweenVillager c = (IHalloweenVillager)pEntity;
                        c.hauntedharvest$setEntityOnCooldown((Entity)this.currentVillager);
                    }
                }
            }
        }
        pEntity.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        pEntity.m_6274_().m_21936_(MemoryModuleType.f_26374_);
    }

    public static void clearHeldItem(Villager self) {
        self.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        self.m_21409_(EquipmentSlot.MAINHAND, 0.085f);
    }

    public static void displayAsHeldItem(Villager self, ItemStack stack) {
        self.m_8061_(EquipmentSlot.MAINHAND, stack);
        self.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    private LivingEntity lookAtTarget(Villager self) {
        Brain brain = self.m_6274_();
        LivingEntity livingentity = (LivingEntity)brain.m_21952_(MemoryModuleType.f_26374_).get();
        brain.m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)livingentity, true));
        return livingentity;
    }
}

