/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest;

import net.mehvahdjukaar.hauntedharvest.CustomCarvingsManager;
import net.mehvahdjukaar.hauntedharvest.HHPlatformStuff;
import net.mehvahdjukaar.hauntedharvest.SeasonManager;
import net.mehvahdjukaar.hauntedharvest.ai.HalloweenVillagerAI;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.CarvingManager;
import net.mehvahdjukaar.hauntedharvest.configs.CommonConfigs;
import net.mehvahdjukaar.hauntedharvest.integration.CompatHandler;
import net.mehvahdjukaar.hauntedharvest.network.NetworkHandler;
import net.mehvahdjukaar.hauntedharvest.reg.ClientRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModCommands;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTabs;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HauntedHarvest {
    public static final String MOD_ID = "hauntedharvest";
    public static final Logger LOGGER = LogManager.getLogger((String)"hauntedharvest");
    private static SeasonManager seasonManager;

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void commonInit() {
        CommonConfigs.init();
        ModCommands.init();
        ModRegistry.init();
        ModTabs.init();
        CompatHandler.init();
        HalloweenVillagerAI.init();
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientRegistry.init();
            ClientHelper.addClientSetup(ClientRegistry::setup);
            ClientHelper.addClientReloadListener(() -> CarvingManager.INSTANCE, (ResourceLocation)HauntedHarvest.res("pumpkin_carvings"));
        }
        PlatHelper.addCommonSetup(HauntedHarvest::commonSetup);
        RegHelper.registerSimpleRecipeCondition((ResourceLocation)HauntedHarvest.res("flag"), CommonConfigs::isEnabled);
        PlatHelper.addServerReloadListener((PreparableReloadListener)CustomCarvingsManager.RELOAD_INSTANCE, (ResourceLocation)HauntedHarvest.res("pumpkin_carvings"));
    }

    public static void commonSetup() {
        NetworkHandler.registerMessages();
        PumpkinType.setup();
        CompatHandler.setup();
        HalloweenVillagerAI.setup();
        ComposterBlock.f_51914_.put((Object)ModRegistry.ROTTEN_APPLE.get().m_5456_(), 0.65f);
        ComposterBlock.f_51914_.put((Object)ModRegistry.GRIM_APPLE.get().m_5456_(), 0.65f);
        ComposterBlock.f_51914_.put((Object)ModRegistry.CARVED_PUMPKIN.get().m_5456_(), 0.65f);
        ComposterBlock.f_51914_.put((Object)ModRegistry.KERNELS.get().m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)ModRegistry.COB_ITEM.get().m_5456_(), 0.5f);
        RegHelper.registerChickenFood((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.KERNELS.get()});
        RegHelper.registerParrotFood((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.KERNELS.get()});
        OptionalDispenseItemBehavior armorBehavior = new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                this.m_123573_(ArmorItem.m_40398_((BlockSource)source, (ItemStack)stack));
                return stack;
            }
        };
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.PAPER_BAG.get()), (DispenseItemBehavior)armorBehavior);
    }

    public static SeasonManager getSeasonManager() {
        if (seasonManager == null) {
            seasonManager = new SeasonManager();
        }
        return seasonManager;
    }

    public static boolean isPlayerOnCooldown(LivingEntity self) {
        return false;
    }

    public static boolean isHalloweenSeason(Level level) {
        return seasonManager.isHalloween(level);
    }

    public static boolean isTrickOrTreatTime(Level level) {
        return seasonManager.isTrickOrTreatTime(level);
    }

    public static void onTagLoad() {
        HalloweenVillagerAI.refreshCandies();
    }

    public static InteractionResult onRightClickBlock(Player player, Level level, InteractionHand hand, BlockHitResult hit) {
        BlockPos pos;
        BlockState state;
        ItemStack stack = player.m_21120_(hand);
        Direction direction = hit.m_82434_();
        PumpkinType t = PumpkinType.getFromTorch(stack.m_41720_());
        if (t != null) {
            BlockPos pos2 = hit.m_82425_();
            BlockState state2 = level.m_8055_(pos2);
            if (state2.m_204336_(ModTags.CARVED_PUMPKINS)) {
                BlockState toPlace;
                ModCarvedPumpkinBlockTile tile;
                CompoundTag tag = null;
                BlockEntity blockEntity = level.m_7702_(pos2);
                if (blockEntity instanceof ModCarvedPumpkinBlockTile) {
                    tile = (ModCarvedPumpkinBlockTile)blockEntity;
                    if (tile.isWaxed()) {
                        return InteractionResult.PASS;
                    }
                    tag = tile.m_187482_();
                    toPlace = t.getPumpkin().m_152465_(state2);
                } else {
                    toPlace = t.getVanillaPumpkin().m_152465_(state2);
                }
                level.m_46597_(pos2, toPlace);
                if (tag != null && (blockEntity = level.m_7702_(pos2)) instanceof ModCarvedPumpkinBlockTile) {
                    tile = (ModCarvedPumpkinBlockTile)blockEntity;
                    tile.m_142466_(tag);
                }
                SoundType soundType = toPlace.m_60827_();
                level.m_5594_(player, pos2, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
                level.m_220407_(GameEvent.f_157797_, pos2, GameEvent.Context.m_223719_((Entity)player, (BlockState)toPlace));
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos2, stack);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }
        if (direction == Direction.UP && HHPlatformStuff.isTopCarver(stack) && (state = level.m_8055_(pos = hit.m_82425_())).m_60713_(Blocks.f_50133_)) {
            level.m_5594_(player, pos, SoundEvents.f_12296_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)((float)pos.m_123342_() + 1.15f), (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)Items.f_42577_, 4));
            itemEntity.m_20334_(level.f_46441_.m_188500_() * 0.02, 0.05 + level.f_46441_.m_188500_() * 0.02, level.f_46441_.m_188500_() * 0.02);
            level.m_7967_((Entity)itemEntity);
            stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
            level.m_7731_(pos, (BlockState)ModRegistry.CARVED_PUMPKIN.get().m_152465_(state).m_61124_((Property)ModCarvedPumpkinBlock.f_51367_, (Comparable)player.m_6350_().m_122424_()), 11);
            if (player instanceof ServerPlayer) {
                ModCarvedPumpkinBlockTile te;
                BlockEntity blockEntity;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                Utils.awardAdvancement((ServerPlayer)serverPlayer, (ResourceLocation)HauntedHarvest.res("husbandry/carve_custom_pumpkin"));
                if (!player.m_36341_() && (blockEntity = level.m_7702_(pos)) instanceof ModCarvedPumpkinBlockTile && (te = (ModCarvedPumpkinBlockTile)blockEntity).getCarveMode().canOpenGui()) {
                    te.sendOpenGuiPacket(level, pos, player);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }
}

