/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.TetraItem;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.ItemProperties;
import se.mickelus.tetra.module.data.SynergyData;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.properties.IToolProvider;

public abstract class ModularItem
extends TetraItem
implements IModularItem,
IToolProvider {
    public static final UUID attackDamageModifier = Item.f_41374_;
    public static final UUID attackSpeedModifier = Item.f_41375_;
    private static final Logger logger = LogManager.getLogger();
    private final Cache<String, Multimap<Attribute, AttributeModifier>> attributeCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final Cache<String, ToolData> toolCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final Cache<String, EffectData> effectCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final Cache<String, ItemProperties> propertyCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    protected int honeBase = 450;
    protected int honeIntegrityMultiplier = 200;
    protected boolean canHone = true;
    protected String[] majorModuleKeys;
    protected String[] minorModuleKeys;
    protected String[] requiredModules = new String[0];
    protected int baseDurability = 0;
    protected int baseIntegrity = 0;
    protected SynergyData[] synergies = new SynergyData[0];

    public ModularItem(Item.Properties properties) {
        super(properties);
        DataManager.instance.moduleData.onReload(this::clearCaches);
    }

    @Override
    public void clearCaches() {
        logger.debug("Clearing item data caches for {}...", (Object)this.toString());
        this.attributeCache.invalidateAll();
        this.toolCache.invalidateAll();
        this.effectCache.invalidateAll();
        this.propertyCache.invalidateAll();
    }

    @Override
    public String[] getMajorModuleKeys(ItemStack itemStack) {
        return this.majorModuleKeys;
    }

    @Override
    public String[] getMinorModuleKeys(ItemStack itemStack) {
        return this.minorModuleKeys;
    }

    @Override
    public String[] getRequiredModules(ItemStack itemStack) {
        return this.requiredModules;
    }

    @Override
    public int getHoneBase(ItemStack itemStack) {
        return this.honeBase;
    }

    @Override
    public int getHoneIntegrityMultiplier(ItemStack itemStack) {
        return this.honeIntegrityMultiplier;
    }

    @Override
    public boolean canGainHoneProgress(ItemStack itemStack) {
        return this.canHone;
    }

    @Override
    public Cache<String, Multimap<Attribute, AttributeModifier>> getAttributeModifierCache() {
        return this.attributeCache;
    }

    @Override
    public Cache<String, EffectData> getEffectDataCache() {
        return this.effectCache;
    }

    @Override
    public Cache<String, ItemProperties> getPropertyCache() {
        return this.propertyCache;
    }

    public Cache<String, ToolData> getToolDataCache() {
        return this.toolCache;
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public boolean canProvideTools(ItemStack itemStack) {
        return !this.isBroken(itemStack);
    }

    @Override
    public ToolData getToolData(ItemStack itemStack) {
        try {
            return (ToolData)this.getToolDataCache().get((Object)this.getDataCacheKey(itemStack), () -> Optional.ofNullable(this.getToolDataRaw(itemStack)).orElseGet(ToolData::new));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return Optional.ofNullable(this.getToolDataRaw(itemStack)).orElseGet(ToolData::new);
        }
    }

    protected ToolData getToolDataRaw(ItemStack itemStack) {
        logger.debug("Gathering tool data for {} ({})", (Object)this.m_7626_(itemStack).getString(), (Object)this.getDataCacheKey(itemStack));
        return Stream.concat(this.getAllModules(itemStack).stream().map(module -> module.getToolData(itemStack)), Arrays.stream(this.getSynergyData(itemStack)).map(synergy -> synergy.tools)).filter(Objects::nonNull).reduce(null, ToolData::merge);
    }

    public Component m_7626_(ItemStack stack) {
        return Component.m_237113_((String)this.getItemName(stack));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.addAll(this.getTooltip(stack, world, flag));
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack itemStack) {
        return Optional.ofNullable(this.getPropertiesCached(itemStack)).map(props -> props.rarity).orElse(super.m_41460_(itemStack));
    }

    public int getMaxDamage(ItemStack itemStack) {
        return Optional.of(this.getPropertiesCached(itemStack)).map(properties -> Float.valueOf((float)(properties.durability + this.baseDurability) * properties.durabilityMultiplier)).map(Math::round).orElse(0);
    }

    public void setDamage(ItemStack itemStack, int damage) {
        super.setDamage(itemStack, Math.min(itemStack.m_41776_() - 1, damage));
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.damageItemImpl(stack, amount, entity, onBroken);
    }

    public int m_142158_(ItemStack itemStack) {
        return Math.round(13.0f - (float)itemStack.m_41773_() * 13.0f / (float)this.getMaxDamage(itemStack));
    }

    public int m_142159_(ItemStack itemStack) {
        float maxDamage = this.getMaxDamage(itemStack);
        float f = Math.max(0.0f, (maxDamage - (float)itemStack.m_41773_()) / maxDamage);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void m_7836_(ItemStack itemStack, Level world, Player player) {
        IModularItem.updateIdentifier(itemStack);
    }

    public boolean m_5812_(@Nonnull ItemStack itemStack) {
        if (((Boolean)ConfigHandler.enableGlint.get()).booleanValue()) {
            return super.m_5812_(itemStack);
        }
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @Override
    public SynergyData[] getAllSynergyData(ItemStack itemStack) {
        return this.synergies;
    }

    public boolean isBookEnchantable(ItemStack itemStack, ItemStack bookStack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemStack, Enchantment enchantment) {
        return this.acceptsEnchantment(itemStack, enchantment, true);
    }

    public int getEnchantmentValue(ItemStack itemStack) {
        return this.getEnchantability(itemStack);
    }
}

