/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.scroll;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.util.HexCodec;

@ParametersAreNonnullByDefault
public class ScrollData {
    private static final Codec<ScrollData> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(i -> i.key), (App)Codec.STRING.optionalFieldOf("details").forGetter(i -> Optional.ofNullable(i.details)), (App)Codec.BOOL.fieldOf("intricate").forGetter(i -> i.isIntricate), (App)Codec.INT.fieldOf("material").forGetter(i -> i.material), (App)HexCodec.instance.fieldOf("ribbon").forGetter(i -> i.ribbon), (App)Codec.INT.listOf().optionalFieldOf("glyphs", Collections.emptyList()).forGetter(i -> i.glyphs), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("schematics", Collections.emptyList()).forGetter(i -> i.schematics), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("effects", Collections.emptyList()).forGetter(i -> i.craftingEffects)).apply((Applicative)instance, ScrollData::new));
    public String key;
    public String details;
    public boolean isIntricate;
    public int material = 0;
    public int ribbon = 0xFFFFFF;
    public List<Integer> glyphs = Collections.emptyList();
    public List<ResourceLocation> schematics = Collections.emptyList();
    public List<ResourceLocation> craftingEffects = Collections.emptyList();

    public ScrollData() {
        this.key = "unknown";
    }

    public ScrollData(String name, Optional<String> details, boolean isIntricate, int material, int ribbon, List<Integer> glyphs, List<ResourceLocation> schematics, List<ResourceLocation> craftingEffects) {
        this.key = name;
        this.details = details.orElse(null);
        this.isIntricate = isIntricate;
        this.material = material;
        this.ribbon = ribbon;
        this.glyphs = glyphs;
        if (!schematics.isEmpty()) {
            this.schematics = schematics;
        }
        if (!craftingEffects.isEmpty()) {
            this.craftingEffects = craftingEffects;
        }
    }

    public static int readMaterialFast(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.m_41737_("BlockEntityTag")).map(tag -> tag.m_128437_("data", 10)).filter(list -> list.size() > 0).map(list -> list.m_128728_(0)).map(tag -> tag.m_128451_("material")).orElse(0);
    }

    public static int readRibbonFast(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.m_41737_("BlockEntityTag")).map(tag -> tag.m_128437_("data", 10)).filter(list -> list.size() > 0).map(list -> list.m_128728_(0)).map(tag -> tag.m_128461_("ribbon")).map(hex -> (int)Long.parseLong(hex, 16)).orElse(0);
    }

    public static ScrollData read(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.m_41737_("BlockEntityTag")).map(ScrollData::read).filter(data -> ((ScrollData[])data).length > 0).map(data -> data[0]).orElseGet(ScrollData::new);
    }

    public static ScrollData[] read(CompoundTag tag) {
        return (ScrollData[])tag.m_128437_("data", 10).stream().map(nbt -> codec.decode((DynamicOps)NbtOps.f_128958_, nbt)).map(DataResult::result).filter(Optional::isPresent).map(Optional::get).map(Pair::getFirst).toArray(ScrollData[]::new);
    }

    public static CompoundTag write(ScrollData[] data, CompoundTag tag) {
        ListTag list = Arrays.stream(data).map(scroll -> codec.encodeStart((DynamicOps)NbtOps.f_128958_, scroll)).map(DataResult::result).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(ListTag::new));
        tag.m_128365_("data", (Tag)list);
        return tag;
    }

    public static ScrollData read(JsonObject json) {
        return Optional.of(codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json)).flatMap(DataResult::result).map(Pair::getFirst).orElse(null);
    }

    public void write(ItemStack itemStack) {
        itemStack.m_41700_("BlockEntityTag", (Tag)ScrollData.write(new ScrollData[]{this}, new CompoundTag()));
    }

    public JsonElement write(JsonObject json) {
        return Optional.of(codec.encode((Object)this, (DynamicOps)JsonOps.INSTANCE, (Object)json)).flatMap(DataResult::result).orElse(null);
    }
}

