/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.util;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemStackUtils {
    public static ItemStack getMateriallyTexturedItemStackFromPlayer(Player playerEntity) {
        IDoItem offHandDoItem;
        IDoItem mainHandDoItem;
        ItemStack mainHandStack = playerEntity.m_21205_();
        ItemStack offHandStack = playerEntity.m_21206_();
        Item item = mainHandStack.m_41720_();
        if (!(item instanceof IDoItem && (mainHandDoItem = (IDoItem)item).renderPreview() || (item = offHandStack.m_41720_()) instanceof IDoItem && (offHandDoItem = (IDoItem)item).renderPreview())) {
            return ItemStack.f_41583_;
        }
        DefaultedRegistry blockRegistry = BuiltInRegistries.f_256975_;
        DefaultedRegistry itemRegistry = BuiltInRegistries.f_257033_;
        ResourceLocation mainHandItemLocation = itemRegistry.m_7981_((Object)mainHandStack.m_41720_());
        ResourceLocation offHandItemLocation = itemRegistry.m_7981_((Object)offHandStack.m_41720_());
        if (blockRegistry.m_7804_(mainHandItemLocation) && blockRegistry.m_7745_(mainHandItemLocation) instanceof IMateriallyTexturedBlock) {
            return mainHandStack;
        }
        if (blockRegistry.m_7804_(offHandItemLocation) && blockRegistry.m_7745_(offHandItemLocation) instanceof IMateriallyTexturedBlock) {
            return offHandStack;
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public static InteractionHand getHandWithMateriallyTexturedItemStackFromPlayer(Player player) {
        ItemStack materialStack = ItemStackUtils.getMateriallyTexturedItemStackFromPlayer(player);
        if (materialStack == player.m_21205_()) {
            return InteractionHand.MAIN_HAND;
        }
        if (materialStack == player.m_21206_()) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }
}

