/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.vanilla;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.types.DoorType;
import com.ldtteam.domumornamentum.block.vanilla.DoorBlock;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoorBlockItem
extends DoubleHighBlockItem
implements IDoItem {
    private final DoorBlock doorBlock;

    public DoorBlockItem(DoorBlock blockIn, Item.Properties builder) {
        super((Block)blockIn, builder);
        this.doorBlock = blockIn;
    }

    @NotNull
    public Component m_7626_(ItemStack stack) {
        CompoundTag dataNbt = stack.m_41698_("textureData");
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(dataNbt);
        IMateriallyTexturedBlockComponent coverComponent = (IMateriallyTexturedBlockComponent)this.doorBlock.getComponents().get(0);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(coverComponent.getId(), coverComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        return Component.m_237110_((String)"domum_ornamentum.door.name.format", (Object[])new Object[]{centerBlockName});
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        DoorType doorType;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        try {
            doorType = stack.m_41784_().m_128441_("type") ? DoorType.valueOf(stack.m_41784_().m_128461_("type").toUpperCase()) : DoorType.FULL;
        }
        catch (Exception ex) {
            doorType = DoorType.FULL;
        }
        tooltip.add((Component)Component.m_237115_((String)"domum_ornamentum.origin.tooltip"));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237110_((String)"domum_ornamentum.door.type.format", (Object[])new Object[]{Component.m_237115_((String)("domum_ornamentum.door.type.name." + doorType.getTranslationKeySuffix()))}));
        CompoundTag dataNbt = stack.m_41698_("textureData");
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(dataNbt);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        IMateriallyTexturedBlockComponent doorComponent = (IMateriallyTexturedBlockComponent)this.doorBlock.getComponents().get(0);
        Block doorBlock = textureData.getTexturedComponents().getOrDefault(doorComponent.getId(), doorComponent.getDefault());
        tooltip.add((Component)Component.m_237110_((String)"domum_ornamentum.desc.onlyone", (Object[])new Object[]{Component.m_237110_((String)"domum_ornamentum.desc.material", (Object[])new Object[]{BlockUtils.getHoverName(doorBlock)})}));
    }

    @Override
    public ResourceLocation getGroup() {
        return new ResourceLocation("domum_ornamentum", "ddoor");
    }
}

