/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.decorative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.block.AbstractBlock;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.components.SimpleRetexturableComponent;
import com.ldtteam.domumornamentum.block.types.PillarShapeType;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.entity.block.MateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.recipe.FinishedDORecipe;
import com.ldtteam.domumornamentum.tag.ModTags;
import com.ldtteam.domumornamentum.util.BlockUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PillarBlock
extends AbstractBlock<PillarBlock>
implements IMateriallyTexturedBlock,
ICachedItemGroupBlock,
EntityBlock {
    public static final List<IMateriallyTexturedBlockComponent> COMPONENTS = ImmutableList.builder().add((Object)new SimpleRetexturableComponent(new ResourceLocation("block/oak_planks"), ModTags.PILLAR_MATERIALS, Blocks.f_50705_)).build();
    public static final EnumProperty<PillarShapeType> COLUMN = EnumProperty.m_61587_((String)"column", PillarShapeType.class);
    private final List<ItemStack> fillItemGroupCache = Lists.newArrayList();
    private static final VoxelShape PILLAR = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final float BLOCK_HARDNESS = 3.0f;
    private static final float RESISTANCE = 1.0f;

    public PillarBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(3.0f, 1.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.FULL_PILLAR)));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return PILLAR;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext coll) {
        return Shapes.m_83144_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{COLUMN});
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getDOExplosionResistance((x$0, x$1, x$2, x$3) -> Float.valueOf(super.getExplosionResistance(x$0, x$1, x$2, x$3)), state, level, pos, explosion);
    }

    public float m_5880_(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return this.getDODestroyProgress((x$0, x$1, x$2, x$3) -> Float.valueOf(super.m_5880_(x$0, x$1, x$2, x$3)), state, player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getDOSoundType((x$0, x$1, x$2, x$3) -> super.getSoundType(x$0, x$1, x$2, x$3), state, level, pos, entity);
    }

    @Override
    public IMateriallyTexturedBlockComponent getMainComponent() {
        return COMPONENTS.get(0);
    }

    @Override
    public void fillItemCategory(@NotNull NonNullList<ItemStack> items) {
        this.fillDOItemCategory(this, items, this.fillItemGroupCache);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        BlockPos blockAbove = blockPos.m_7494_();
        BlockPos blockBelow = blockPos.m_7495_();
        BlockState stateAbove = level.m_8055_(blockAbove);
        BlockState stateBelow = level.m_8055_(blockBelow);
        Boolean base = this.isMatchingPillar(stateBelow);
        Boolean capital = this.isMatchingPillar(stateAbove);
        return this.updateShape(this.m_49966_(), base, capital);
    }

    public void m_6786_(@NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockState state) {
        super.m_6786_(world, pos, state);
        Comparable column_property = state.m_61143_(COLUMN);
        if (column_property == PillarShapeType.PILLAR_COLUMN) {
            if (this.isMatchingPillar(world.m_8055_(pos.m_7494_())) && world.m_8055_(pos.m_7494_()).m_61143_(COLUMN) == PillarShapeType.PILLAR_COLUMN) {
                world.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_BASE)), 3);
            } else if (this.isMatchingPillar(world.m_8055_(pos.m_7494_()))) {
                world.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.FULL_PILLAR)), 3);
            }
            if (this.isMatchingPillar(world.m_8055_(pos.m_7495_())) && world.m_8055_(pos.m_7495_()).m_61143_(COLUMN) == PillarShapeType.PILLAR_COLUMN) {
                world.m_7731_(pos.m_7495_(), (BlockState)state.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_CAPITAL)), 3);
            } else if (this.isMatchingPillar(world.m_8055_(pos.m_7495_()))) {
                world.m_7731_(pos.m_7495_(), (BlockState)state.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.FULL_PILLAR)), 3);
            }
        }
        if (this.isMatchingPillar(world.m_8055_(pos.m_7494_())) && column_property == PillarShapeType.PILLAR_BASE) {
            if (world.m_8055_(pos.m_7494_()).m_61143_(COLUMN) == PillarShapeType.PILLAR_COLUMN) {
                world.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_BASE)), 3);
            } else {
                world.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.FULL_PILLAR)), 3);
            }
        }
        if (this.isMatchingPillar(world.m_8055_(pos.m_7495_())) && column_property == PillarShapeType.PILLAR_CAPITAL) {
            if (world.m_8055_(pos.m_7495_()).m_61143_(COLUMN) == PillarShapeType.PILLAR_COLUMN) {
                world.m_7731_(pos.m_7495_(), (BlockState)state.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_CAPITAL)), 3);
            } else {
                world.m_7731_(pos.m_7495_(), (BlockState)state.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.FULL_PILLAR)), 3);
            }
        }
    }

    private void updateBelow(Level level, BlockPos blockPos, BlockState state) {
        BlockPos checkBelow = blockPos.m_7495_();
        if (this.isMatchingPillar(level.m_8055_(checkBelow))) {
            level.m_46597_(blockPos, (BlockState)state.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_COLUMN)));
        } else {
            level.m_46597_(blockPos, (BlockState)state.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_BASE)));
        }
    }

    private void updateAbove(Level level, BlockPos blockPos, BlockState state) {
        BlockPos checkAbove = blockPos.m_7494_();
        if (this.isMatchingPillar(level.m_8055_(checkAbove))) {
            level.m_46597_(blockPos, (BlockState)state.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_COLUMN)));
        } else {
            level.m_46597_(blockPos, (BlockState)state.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_CAPITAL)));
        }
    }

    private BlockState updateShape(BlockState blockState, Boolean base, Boolean capital) {
        if (this.isMatchingPillar(blockState)) {
            if (base.booleanValue() && capital.booleanValue()) {
                return (BlockState)blockState.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_COLUMN));
            }
            if (!base.booleanValue() && capital.booleanValue()) {
                return (BlockState)blockState.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_BASE));
            }
            if (base.booleanValue() && !capital.booleanValue()) {
                return (BlockState)blockState.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.PILLAR_CAPITAL));
            }
            blockState.m_61124_(COLUMN, (Comparable)((Object)PillarShapeType.FULL_PILLAR));
        }
        return blockState;
    }

    private boolean isMatchingPillar(@NotNull BlockState state) {
        return state.m_60734_() == this;
    }

    @NotNull
    public List<IMateriallyTexturedBlockComponent> getComponents() {
        return COMPONENTS;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new MateriallyTexturedBlockEntity(blockPos, blockState);
    }

    @Override
    public void resetCache() {
        this.fillItemGroupCache.clear();
    }

    @NotNull
    public List<ItemStack> m_49635_(@NotNull BlockState state, @NotNull LootParams.Builder builder) {
        return BlockUtils.getMaterializedItemStack(builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return BlockUtils.getMaterializedItemStack((Entity)player, world, pos);
    }

    @Override
    @NotNull
    public Block getBlock() {
        return this;
    }

    @Override
    @NotNull
    public Collection<FinishedRecipe> getValidCutterRecipes() {
        return Lists.newArrayList((Object[])new FinishedRecipe[]{new FinishedDORecipe(){

            public void m_7917_(@NotNull JsonObject json) {
                json.addProperty("count", (Number)COMPONENTS.size());
            }

            @NotNull
            public ResourceLocation m_6445_() {
                return Objects.requireNonNull(PillarBlock.this.getRegistryName(PillarBlock.this.getBlock()));
            }
        }});
    }

    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        BlockPos blockAbove = pPos.m_7494_();
        BlockPos blockBelow = pPos.m_7495_();
        BlockState stateAbove = pLevel.m_8055_(blockAbove);
        BlockState stateBelow = pLevel.m_8055_(blockBelow);
        boolean base = this.isMatchingPillar(stateBelow);
        boolean capital = this.isMatchingPillar(stateAbove);
        if (base) {
            this.updateBelow(pLevel, blockBelow, stateBelow);
        }
        if (capital) {
            this.updateAbove(pLevel, blockAbove, stateAbove);
        }
        CompoundTag textureData = pStack.m_41698_("textureData");
        BlockEntity tileEntity = pLevel.m_7702_(pPos);
        if (tileEntity instanceof MateriallyTexturedBlockEntity) {
            ((MateriallyTexturedBlockEntity)tileEntity).updateTextureDataWith(MaterialTextureData.deserializeFromNBT(textureData));
        }
    }
}

