/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block;

import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public final class MateriallyTexturedBlockManager
implements IMateriallyTexturedBlockManager {
    private static final MateriallyTexturedBlockManager INSTANCE = new MateriallyTexturedBlockManager();
    private List<IMateriallyTexturedBlock> blocks = Lists.newArrayList();
    private int maxTexturableComponentCount = -1;

    public static MateriallyTexturedBlockManager getInstance() {
        return INSTANCE;
    }

    private MateriallyTexturedBlockManager() {
    }

    @Override
    public int getMaxTexturableComponentCount() {
        if (this.maxTexturableComponentCount >= 0) {
            return this.maxTexturableComponentCount;
        }
        if (this.blocks.isEmpty()) {
            this.blocks = StreamSupport.stream(ForgeRegistries.BLOCKS.spliterator(), false).filter(IMateriallyTexturedBlock.class::isInstance).map(IMateriallyTexturedBlock.class::cast).collect(Collectors.toList());
        }
        this.maxTexturableComponentCount = this.blocks.stream().map(IMateriallyTexturedBlock::getComponents).mapToInt(Collection::size).max().orElse(0);
        return this.maxTexturableComponentCount;
    }

    @Override
    public boolean doesItemStackContainsMaterialForSlot(int slotIndex, ItemStack stack) {
        if (stack.m_41619_()) {
            return true;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.m_40614_();
        if (slotIndex >= this.getMaxTexturableComponentCount()) {
            return false;
        }
        return this.blocks.stream().map(IMateriallyTexturedBlock::getComponents).filter(c -> c.size() > slotIndex).map(ArrayList::new).map(l -> (IMateriallyTexturedBlockComponent)l.get(slotIndex)).anyMatch(c -> block.m_49966_().m_204336_(c.getValidSkins()));
    }

    @Override
    public boolean doesItemStackContainsMaterialForSlot(int slotIndex, ItemStack stack, ItemStack type) {
        IMateriallyTexturedBlock texturedBlock;
        BlockItem item;
        if (stack.m_41619_()) {
            return true;
        }
        Item item2 = stack.m_41720_();
        if (!(item2 instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item2;
        Block block = blockItem.m_40614_();
        if (slotIndex >= this.getMaxTexturableComponentCount()) {
            return false;
        }
        Item item3 = type.m_41720_();
        if (item3 instanceof BlockItem && (item3 = (item = (BlockItem)item3).m_40614_()) instanceof IMateriallyTexturedBlock && (texturedBlock = (IMateriallyTexturedBlock)item3).getComponents().size() > slotIndex) {
            return block.m_49966_().m_204336_(((IMateriallyTexturedBlockComponent)texturedBlock.getComponents().toArray()[slotIndex]).getValidSkins());
        }
        return false;
    }
}

