/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.proxy;

import com.alc.moreminecarts.MoreMinecartsMod;
import com.alc.moreminecarts.containers.ChunkLoaderContainer;
import com.alc.moreminecarts.containers.FilterUnloaderContainer;
import com.alc.moreminecarts.containers.FlagCartContainer;
import com.alc.moreminecarts.containers.MinecartUnLoaderContainer;
import com.alc.moreminecarts.entities.CouplerEntity;
import com.alc.moreminecarts.entities.PistonPushcartEntity;
import com.alc.moreminecarts.tile_entities.AbstractCommonLoader;
import com.alc.moreminecarts.tile_entities.FilterUnloaderTile;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class MoreMinecartsPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("moreminecarts", "channelname")).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "1").simpleChannel();

    public static void Init() {
        int id = 0;
        INSTANCE.messageBuilder(CouplePacket.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(CouplePacket::encode).decoder(CouplePacket::decode).consumerMainThread(CouplePacket::handle).add();
        INSTANCE.messageBuilder(ChunkLoaderPacket.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(ChunkLoaderPacket::encode).decoder(ChunkLoaderPacket::decode).consumerMainThread(ChunkLoaderPacket::handle).add();
        INSTANCE.messageBuilder(PistonPushcartPacket.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(PistonPushcartPacket::encode).decoder(PistonPushcartPacket::decode).consumerMainThread(PistonPushcartPacket::handle).add();
        INSTANCE.messageBuilder(ExtendedInteractPacket.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(ExtendedInteractPacket::encode).decoder(ExtendedInteractPacket::decode).consumerMainThread(ExtendedInteractPacket::handle).add();
        INSTANCE.messageBuilder(MinecartLoaderPacket.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(MinecartLoaderPacket::encode).decoder(MinecartLoaderPacket::decode).consumerMainThread(MinecartLoaderPacket::handle).add();
        INSTANCE.messageBuilder(FlagCartPacket.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(FlagCartPacket::encode).decoder(FlagCartPacket::decode).consumerMainThread(FlagCartPacket::handle).add();
    }

    public static void handleInteract(ServerboundInteractPacket p_9866_, final ServerPlayer player, final Connection connection) {
        ServerLevel serverlevel = player.m_284548_();
        final Entity entity = p_9866_.m_179603_(serverlevel);
        player.m_9243_();
        player.m_20260_(p_9866_.m_134061_());
        if (entity != null) {
            if (!serverlevel.m_6857_().m_61937_(entity.m_20183_())) {
                return;
            }
            double d0 = 36.0;
            if (player.m_20280_(entity) >= 36.0 && player.m_20280_(entity) < 100.0) {
                MoreMinecartsMod.LOGGER.log(org.apache.logging.log4j.Level.WARN, "PISTON PUSHCART INTERACT 4");
                p_9866_.m_179617_(new ServerboundInteractPacket.Handler(){

                    private void performInteraction(InteractionHand p_143679_, EntityInteraction p_143680_) {
                        ItemStack itemstack = player.m_21120_(p_143679_).m_41777_();
                        InteractionResult interactionresult = p_143680_.run(player, entity, p_143679_);
                        if (ForgeHooks.onInteractEntityAt((Player)player, (Entity)entity, (Vec3)entity.m_20182_(), (InteractionHand)p_143679_) != null) {
                            return;
                        }
                        if (interactionresult.m_19077_()) {
                            CriteriaTriggers.f_10565_.m_61494_(player, itemstack, entity);
                            if (interactionresult.m_19080_()) {
                                player.m_21011_(p_143679_, true);
                            }
                        }
                    }

                    public void m_142299_(InteractionHand p_143677_) {
                        this.performInteraction(p_143677_, Player::m_36157_);
                    }

                    public void m_142143_(InteractionHand p_143682_, Vec3 p_143683_) {
                        this.performInteraction(p_143682_, (p_143686_, p_143687_, p_143688_) -> p_143687_.m_7111_((Player)p_143686_, p_143683_, p_143688_));
                    }

                    public void m_141994_() {
                        if (!(entity instanceof ItemEntity || entity instanceof ExperienceOrb || entity instanceof AbstractArrow || entity == player)) {
                            player.m_5706_(entity);
                        } else {
                            MoreMinecartsPacketHandler.disconnect((Component)Component.m_237115_((String)"multiplayer.disconnect.invalid_entity_attacked"), connection);
                        }
                    }
                });
            }
        }
    }

    public static void disconnect(Component comp, Connection connection) {
        connection.m_243124_((Packet)new ClientboundDisconnectPacket(comp), (PacketSendListener)new ConnectionPacketListener(comp, connection));
        connection.m_129540_();
        connection.m_129541_();
    }

    public static class CouplePacket {
        public int coupler_id;
        public int v1;
        public int v2;

        public CouplePacket(int coupler_id, int v1, int v2) {
            this.coupler_id = coupler_id;
            this.v1 = v1;
            this.v2 = v2;
        }

        public static void encode(CouplePacket msg, FriendlyByteBuf buf) {
            buf.writeInt(msg.v1);
            buf.writeInt(msg.v2);
            buf.writeInt(msg.coupler_id);
        }

        public static CouplePacket decode(FriendlyByteBuf buf) {
            CouplePacket packet = new CouplePacket(0, 0, 0);
            packet.v1 = buf.readInt();
            packet.v2 = buf.readInt();
            packet.coupler_id = buf.readInt();
            return packet;
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Level world = MoreMinecartsMod.PROXY.getWorld();
                Entity ent = world.m_6815_(this.coupler_id);
                if (ent != null && ent instanceof CouplerEntity) {
                    CouplerEntity coupler_ent = (CouplerEntity)ent;
                    coupler_ent.vehicle1_id = this.v1;
                    coupler_ent.vehicle2_id = this.v2;
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class ChunkLoaderPacket {
        public boolean set_enabled;

        public ChunkLoaderPacket(boolean set_enabled) {
            this.set_enabled = set_enabled;
        }

        public static void encode(ChunkLoaderPacket msg, FriendlyByteBuf buf) {
            buf.writeBoolean(msg.set_enabled);
        }

        public static ChunkLoaderPacket decode(FriendlyByteBuf buf) {
            ChunkLoaderPacket packet = new ChunkLoaderPacket(false);
            packet.set_enabled = buf.readBoolean();
            return packet;
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender.f_36096_ instanceof ChunkLoaderContainer) {
                    ((ChunkLoaderContainer)sender.f_36096_).setEnabled(this.set_enabled);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class PistonPushcartPacket {
        public boolean is_up_key;
        public boolean now_down;

        public PistonPushcartPacket(boolean is_up_key, boolean now_down) {
            this.is_up_key = is_up_key;
            this.now_down = now_down;
        }

        public static void encode(PistonPushcartPacket msg, FriendlyByteBuf buf) {
            buf.writeBoolean(msg.is_up_key);
            buf.writeBoolean(msg.now_down);
        }

        public static PistonPushcartPacket decode(FriendlyByteBuf buf) {
            PistonPushcartPacket packet = new PistonPushcartPacket(false, false);
            packet.is_up_key = buf.readBoolean();
            packet.now_down = buf.readBoolean();
            return packet;
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender.m_20201_() instanceof PistonPushcartEntity) {
                    ((PistonPushcartEntity)sender.m_20201_()).setElevating(this.is_up_key, this.now_down);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class ExtendedInteractPacket
    extends ServerboundInteractPacket {
        public ExtendedInteractPacket(FriendlyByteBuf p_179602_) {
            super(p_179602_);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static ExtendedInteractPacket createExtendedInteractPacket(Entity p_179609_, boolean p_179610_, InteractionHand p_179611_) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130130_(p_179609_.m_19879_());
            buf.m_130068_((Enum)FakeInteraction.INTERACTION);
            buf.m_130068_((Enum)p_179611_);
            buf.writeBoolean(p_179610_);
            return new ExtendedInteractPacket(buf);
        }

        public static void encode(ExtendedInteractPacket msg, FriendlyByteBuf buf) {
            msg.m_5779_(buf);
        }

        public static ExtendedInteractPacket decode(FriendlyByteBuf buf) {
            ExtendedInteractPacket interact = new ExtendedInteractPacket(buf);
            return interact;
        }

        public static void handle(ExtendedInteractPacket msg, NetworkEvent.Context ctx) {
            ctx.enqueueWork(() -> {
                ServerPlayer sender = ctx.getSender();
                MoreMinecartsPacketHandler.handleInteract(msg, sender, ctx.getNetworkManager());
            });
            ctx.setPacketHandled(true);
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                MoreMinecartsPacketHandler.handleInteract(this, sender, ((NetworkEvent.Context)ctx.get()).getNetworkManager());
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class MinecartLoaderPacket {
        public boolean is_unloader;
        public boolean locked_minecarts_only;
        public boolean leave_one_item_in_stack;
        public boolean redstone_output;
        public AbstractCommonLoader.ComparatorOutputType output_type;
        public FilterUnloaderTile.FilterType filterType;

        public MinecartLoaderPacket() {
        }

        public MinecartLoaderPacket(boolean is_unloader, boolean locked_minecarts_only, boolean leave_one_item_in_stack, AbstractCommonLoader.ComparatorOutputType output_type, boolean redstone_output, FilterUnloaderTile.FilterType filterType) {
            this.is_unloader = is_unloader;
            this.locked_minecarts_only = locked_minecarts_only;
            this.leave_one_item_in_stack = leave_one_item_in_stack;
            this.output_type = output_type;
            this.redstone_output = redstone_output;
            this.filterType = filterType;
        }

        public static void encode(MinecartLoaderPacket msg, FriendlyByteBuf buf) {
            buf.writeBoolean(msg.is_unloader);
            buf.writeBoolean(msg.locked_minecarts_only);
            buf.writeBoolean(msg.leave_one_item_in_stack);
            buf.m_130068_((Enum)msg.output_type);
            buf.writeBoolean(msg.redstone_output);
            buf.m_130068_((Enum)msg.filterType);
        }

        public static MinecartLoaderPacket decode(FriendlyByteBuf buf) {
            MinecartLoaderPacket packet = new MinecartLoaderPacket();
            packet.is_unloader = buf.readBoolean();
            packet.locked_minecarts_only = buf.readBoolean();
            packet.leave_one_item_in_stack = buf.readBoolean();
            packet.output_type = (AbstractCommonLoader.ComparatorOutputType)buf.m_130066_(AbstractCommonLoader.ComparatorOutputType.class);
            packet.redstone_output = buf.readBoolean();
            packet.filterType = (FilterUnloaderTile.FilterType)buf.m_130066_(FilterUnloaderTile.FilterType.class);
            return packet;
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                AbstractContainerMenu patt16494$temp = sender.f_36096_;
                if (patt16494$temp instanceof MinecartUnLoaderContainer) {
                    MinecartUnLoaderContainer container = (MinecartUnLoaderContainer)patt16494$temp;
                    container.setOptions(this.locked_minecarts_only, this.leave_one_item_in_stack, this.output_type, this.redstone_output, this.filterType);
                } else {
                    AbstractContainerMenu patt16740$temp = sender.f_36096_;
                    if (patt16740$temp instanceof FilterUnloaderContainer) {
                        FilterUnloaderContainer container = (FilterUnloaderContainer)patt16740$temp;
                        container.setOptions(this.locked_minecarts_only, this.leave_one_item_in_stack, this.output_type, this.redstone_output, this.filterType);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class FlagCartPacket {
        public boolean is_decrement;
        public boolean is_disclude;

        public FlagCartPacket(boolean is_decrement, boolean is_disclude) {
            this.is_decrement = is_decrement;
            this.is_disclude = is_disclude;
        }

        public static void encode(FlagCartPacket msg, FriendlyByteBuf buf) {
            buf.writeBoolean(msg.is_decrement);
            buf.writeBoolean(msg.is_disclude);
        }

        public static FlagCartPacket decode(FriendlyByteBuf buf) {
            FlagCartPacket packet = new FlagCartPacket(false, false);
            packet.is_decrement = buf.readBoolean();
            packet.is_disclude = buf.readBoolean();
            return packet;
        }

        public static void handle(FlagCartPacket msg, NetworkEvent.Context ctx) {
            ctx.enqueueWork(() -> {
                ServerPlayer sender = ctx.getSender();
                if (sender.f_36096_ instanceof FlagCartContainer) {
                    ((FlagCartContainer)sender.f_36096_).changeSelection(msg.is_decrement, msg.is_disclude);
                }
            });
            ctx.setPacketHandled(true);
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender.f_36096_ instanceof FlagCartContainer) {
                    ((FlagCartContainer)sender.f_36096_).changeSelection(this.is_decrement, this.is_disclude);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class ConnectionPacketListener
    implements PacketSendListener {
        Component comp;
        Connection connection;

        public ConnectionPacketListener(Component comp, Connection connection) {
            this.comp = comp;
            this.connection = connection;
        }

        public void m_243096_() {
            this.connection.m_129507_(this.comp);
            super.m_243096_();
        }
    }

    @FunctionalInterface
    static interface EntityInteraction {
        public InteractionResult run(ServerPlayer var1, Entity var2, InteractionHand var3);
    }

    public static enum FakeInteraction {
        INTERACTION;

    }
}

