/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.blocks.PistonDisplayBlock;
import com.alc.moreminecarts.containers.BatteryCartContainer;
import com.alc.moreminecarts.misc.SettableEnergyStorage;
import com.alc.moreminecarts.registry.MMBlocks;
import com.alc.moreminecarts.registry.MMItems;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class BatteryCartEntity
extends AbstractMinecart
implements Container,
MenuProvider {
    public static String ENERGY_PROPERTY = "energy";
    private static final EntityDataAccessor<Integer> ENERGY_AMOUNT = SynchedEntityData.m_135353_(BatteryCartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return BatteryCartEntity.this.m_19879_();
                }
            }
            return 0;
        }

        public void m_8050_(int index, int set_to) {
        }

        public int m_6499_() {
            return 1;
        }
    };
    LazyOptional<IEnergyStorage> energy_handler = LazyOptional.of(() -> new CartBattery(40000));

    public BatteryCartEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public BatteryCartEntity(EntityType<?> type, Level worldIn, double x, double y, double z) {
        super(type, worldIn, x, y, z);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy_handler.cast();
        }
        return super.getCapability(cap);
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    public Item m_213728_() {
        return (Item)MMItems.BATTERY_CART_ITEM.get();
    }

    public BlockState m_6390_() {
        return (BlockState)((Block)MMBlocks.PISTON_DISPLAY_BLOCK.get()).m_49966_().m_61124_((Property)PistonDisplayBlock.VARIANT, (Comparable)Integer.valueOf(5));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inv, Player player) {
        return new BatteryCartContainer(i, this.m_9236_(), this, inv, player);
    }

    public InteractionResult m_6096_(Player p_184230_1_, InteractionHand p_184230_2_) {
        InteractionResult ret = super.m_6096_(p_184230_1_, p_184230_2_);
        if (ret.m_19077_()) {
            return ret;
        }
        p_184230_1_.m_5893_((MenuProvider)this);
        return InteractionResult.SUCCESS;
    }

    public boolean m_6542_(Player player) {
        return player.m_20275_(this.m_20182_().f_82479_ + 0.5, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_ + 0.5) <= 64.0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENERGY_AMOUNT, (Object)0);
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_(ENERGY_PROPERTY, ((IEnergyStorage)this.energy_handler.orElse(null)).getEnergyStored());
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ((IEnergyStorage)this.energy_handler.orElse(null)).receiveEnergy(compound.m_128451_(ENERGY_PROPERTY), false);
    }

    public int getEnergyAmount() {
        return (Integer)this.f_19804_.m_135370_(ENERGY_AMOUNT);
    }

    public int getComparatorSignal() {
        return (int)Math.floor((double)((float)((IEnergyStorage)this.energy_handler.resolve().get()).getEnergyStored() / (float)((IEnergyStorage)this.energy_handler.resolve().get()).getMaxEnergyStored()) * 15.0);
    }

    public int m_6643_() {
        return 0;
    }

    public boolean m_7983_() {
        return false;
    }

    public ItemStack m_8020_(int p_18941_) {
        return null;
    }

    public ItemStack m_7407_(int p_18942_, int p_18943_) {
        return null;
    }

    public ItemStack m_8016_(int p_18951_) {
        return null;
    }

    public void m_6836_(int p_18944_, ItemStack p_18945_) {
    }

    public void m_6596_() {
    }

    public void m_6211_() {
    }

    public class CartBattery
    extends SettableEnergyStorage {
        public CartBattery(int capacity) {
            super(capacity);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int ret = super.receiveEnergy(maxReceive, simulate);
            if (!simulate && BatteryCartEntity.this.m_9236_() != null) {
                BatteryCartEntity.this.f_19804_.m_135381_(ENERGY_AMOUNT, (Object)this.energy);
            }
            return ret;
        }

        public int extractEnergy(int maxReceive, boolean simulate) {
            int ret = super.extractEnergy(maxReceive, simulate);
            if (!simulate && BatteryCartEntity.this.m_9236_() != null) {
                BatteryCartEntity.this.f_19804_.m_135381_(ENERGY_AMOUNT, (Object)this.energy);
            }
            return ret;
        }
    }
}

