/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks.utility_rails;

import com.alc.moreminecarts.registry.MMTileEntities;
import com.alc.moreminecarts.tile_entities.LockingRailTile;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.BlockHitResult;

public class LockingRailBlock
extends BaseRailBlock
implements EntityBlock {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.f_61404_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty INVERTED = BooleanProperty.m_61465_((String)"inverted");

    public LockingRailBlock(BlockBehaviour.Properties builder) {
        super(true, builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(true)));
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        super.m_213897_(state, world, pos, rand);
        this.updateTileEntity(state, (Level)world, pos);
    }

    protected void m_6360_(BlockState state, Level worldIn, BlockPos pos, Block blockIn) {
        boolean new_powered;
        boolean old_powered = (Boolean)state.m_61143_((Property)POWERED);
        if (old_powered != (new_powered = worldIn.m_276867_(pos))) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(new_powered)), 3);
            this.updateTileEntity(state, worldIn, pos);
            worldIn.m_46672_(pos.m_7495_(), (Block)this);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.m_5776_()) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)INVERTED) == false)));
            worldIn.m_5594_((Player)null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.m_19078_((boolean)worldIn.m_5776_());
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        AbstractMinecart locked_minecart;
        if (worldIn.m_5776_()) {
            return;
        }
        if (entityIn instanceof AbstractMinecart && entityIn == (locked_minecart = this.updateTileEntity(state, worldIn, pos))) {
            locked_minecart.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            locked_minecart.m_20334_(0.0, 0.0, 0.0);
        }
    }

    private AbstractMinecart updateTileEntity(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof LockingRailTile) {
            boolean update_signal = ((LockingRailTile)te).updateLock((Boolean)state.m_61143_((Property)POWERED) ^ (Boolean)state.m_61143_((Property)INVERTED));
            if (update_signal) {
                worldIn.m_46717_(pos, state.m_60734_());
            }
            return ((LockingRailTile)te).locked_minecart;
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SHAPE, POWERED, INVERTED, f_152149_});
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.m_6360_(state, worldIn, pos, state.m_60734_());
            this.updateTileEntity(state, worldIn, pos);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LockingRailTile(pos, state);
    }

    public boolean m_7278_(BlockState p_149740_1_) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof LockingRailTile) {
            return ((LockingRailTile)te).getComparatorSignal();
        }
        return 0;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                switch ((RailShape)state.m_61143_(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((RailShape)state.m_61143_(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((RailShape)state.m_61143_(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        RailShape railshape = (RailShape)state.m_61143_(SHAPE);
        block0 : switch (mirrorIn) {
            case LEFT_RIGHT: {
                switch (railshape) {
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                }
                return super.m_6943_(state, mirrorIn);
            }
            case FRONT_BACK: {
                switch (railshape) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
            }
        }
        return super.m_6943_(state, mirrorIn);
    }

    public Property<RailShape> m_7978_() {
        return SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152180_, BlockState p_152181_, BlockEntityType<T> p_152182_) {
        return p_152180_.f_46443_ ? null : LockingRailBlock.createTickerHelper(p_152182_, (BlockEntityType)MMTileEntities.LOCKING_RAIL_TILE_ENTITY.get(), LockingRailTile::doTick);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }
}

