/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.misc;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatVariantRegistry;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.block.RatTubeBlock;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.github.alexthe666.rats.server.entity.rat.DiggingRat;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import com.github.alexthe666.rats.server.entity.rat.RatCommand;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatVariant;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;

public class RatUtils {
    public static final Predicate<LivingEntity> UNTAMED_RAT_SELECTOR = entity -> {
        AbstractRat rat;
        return entity instanceof AbstractRat && !(rat = (AbstractRat)((Object)entity)).m_21824_();
    };

    public static boolean isRidingOrBeingRiddenBy(Entity us, Entity entity) {
        for (Entity selected : us.m_20197_()) {
            if (selected.equals((Object)entity)) {
                return true;
            }
            if (!RatUtils.isRidingOrBeingRiddenBy(selected, entity)) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getPositionRelativetoWater(TamedRat rat, Level level, double x, double z, RandomSource rng) {
        BlockPos topY = BlockPos.m_274561_((double)x, (double)rat.m_20186_(), (double)z);
        BlockPos bottomY = BlockPos.m_274561_((double)x, (double)rat.m_20186_(), (double)z);
        while (level.m_8055_(topY).m_60713_(Blocks.f_49990_) && topY.m_123342_() < level.m_151558_()) {
            topY = topY.m_7494_();
        }
        while (level.m_8055_(bottomY).m_60713_(Blocks.f_49990_) && bottomY.m_123342_() > level.m_141937_()) {
            bottomY = bottomY.m_7495_();
        }
        for (int tries = 0; tries < 5; ++tries) {
            BlockPos pos = BlockPos.m_274561_((double)x, (double)(bottomY.m_123342_() + 1 + rng.m_188503_(Math.max(1, topY.m_123342_() - bottomY.m_123342_() - 2))), (double)z);
            if (!level.m_8055_(pos).m_60713_(Blocks.f_49990_)) continue;
            return pos;
        }
        return rat.m_20183_();
    }

    public static boolean isRatFood(ItemStack stack) {
        return (stack.m_41720_().m_41472_() || stack.m_204117_(Tags.Items.SEEDS) || stack.m_150930_(Items.f_42405_)) && !stack.m_150930_((Item)RatsItemRegistry.RAW_RAT.get()) && !stack.m_150930_((Item)RatsItemRegistry.COOKED_RAT.get());
    }

    public static boolean shouldRaidItem(ItemStack stack) {
        return RatUtils.isRatFood(stack) && !stack.m_150930_((Item)RatsItemRegistry.CONTAMINATED_FOOD.get());
    }

    public static boolean doesContainFood(Container inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!RatUtils.isRatFood(inventory.m_8020_(i))) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getFoodFromInventory(Container inventory, RandomSource random) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!RatUtils.shouldRaidItem(stack)) continue;
            items.add(stack);
        }
        if (items.isEmpty()) {
            return ItemStack.f_41583_;
        }
        if (items.size() == 1) {
            return (ItemStack)items.get(0);
        }
        return (ItemStack)items.get(random.m_188503_(items.size() - 1));
    }

    public static int getContaminatedSlot(Container inventory, RandomSource random) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!stack.m_41619_() && !stack.m_150930_((Item)RatsItemRegistry.CONTAMINATED_FOOD.get())) continue;
            items.add(i);
        }
        if (items.isEmpty()) {
            return -1;
        }
        if (items.size() == 1) {
            return (Integer)items.get(0);
        }
        return (Integer)items.get(random.m_188503_(items.size() - 1));
    }

    public static int getItemSlotFromItemHandler(TamedRat rat, IItemHandler handler, RandomSource random) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.extractItem(i, handler.getSlotLimit(i), true);
            if (!rat.canRatPickupItem(stack)) continue;
            items.add(i);
        }
        if (items.isEmpty()) {
            return -1;
        }
        if (items.size() == 1) {
            return (Integer)items.get(0);
        }
        return (Integer)items.get(random.m_188503_(items.size()));
    }

    public static boolean isPredator(Entity entity) {
        return entity instanceof Ocelot || entity instanceof Cat || entity instanceof Fox;
    }

    public static RatCommand wrapCommand(int newCommand) {
        int length = RatCommand.values().length;
        if (newCommand >= length) {
            newCommand = 0;
        }
        if (newCommand < 0) {
            newCommand = length - 1;
        }
        return RatCommand.values()[newCommand];
    }

    public static BlockPos findLowestWater(BlockPos pos, PathfinderMob rat) {
        BlockPos blockpos;
        if (rat.m_9236_().m_8055_(pos).m_60713_(Blocks.f_49990_)) {
            return pos;
        }
        while ((blockpos = pos.m_7495_()).m_123342_() > rat.m_9236_().m_141937_() && rat.m_9236_().m_8055_(blockpos).m_60713_(Blocks.f_49990_)) {
        }
        return blockpos;
    }

    public static boolean canRatBreakBlock(Level level, BlockPos pos, DiggingRat rat) {
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_60795_() || blockState.m_278721_() || level.m_7702_(pos) != null) {
            return false;
        }
        float hardness = blockState.m_60800_((BlockGetter)level, pos);
        return hardness >= 0.0f && hardness <= RatConfig.ratStrengthThreshold && ForgeHooks.canEntityDestroy((Level)level, (BlockPos)pos, (LivingEntity)rat);
    }

    public static boolean canRatPlaceBlock(Level level, BlockPos pos, DiggingRat rat) {
        return ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)rat) && !ForgeEventFactory.onBlockPlace((Entity)rat, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)pos), (Direction)Direction.UP);
    }

    public static boolean isBlockProtected(Level level, BlockPos pos, DiggingRat rat) {
        return !ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)rat) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)rat, (BlockPos)pos, (BlockState)level.m_8055_(pos));
    }

    public static boolean isOpenRatTube(BlockGetter getter, BlockPos pos) {
        BlockState state = getter.m_8055_(pos);
        if (state.m_60734_() instanceof RatTubeBlock) {
            for (int i = 0; i < Direction.values().length; ++i) {
                BooleanProperty bool = RatTubeBlock.ALL_OPEN_PROPS[i];
                if (!((Boolean)state.m_61143_((Property)bool)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCow(Entity entity) {
        String s = entity.m_6095_().m_20675_();
        return entity instanceof Cow || s.contains("cow");
    }

    public static void polinateAround(Level level, BlockPos position) {
        int RADIUS = 10;
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.m_121990_((BlockPos)position.m_7918_(-RADIUS, -RADIUS, -RADIUS), (BlockPos)position.m_7918_(RADIUS, RADIUS, RADIUS)).map(BlockPos::m_7949_).toList()) {
            if (!RatUtils.canPlantBeBonemealed(level, pos, level.m_8055_(pos))) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            for (BlockPos pos : allBlocks) {
                BonemealableBlock igrowable;
                BlockState block = level.m_8055_(pos);
                Block block2 = block.m_60734_();
                if (!(block2 instanceof BonemealableBlock) || !(igrowable = (BonemealableBlock)block2).m_7370_((LevelReader)level, pos, block, level.m_5776_()) || level.m_213780_().m_188503_(3) != 0 || level.m_5776_()) continue;
                level.m_46796_(2005, pos, 0);
                igrowable.m_214148_((ServerLevel)level, level.m_213780_(), pos, block);
            }
        }
    }

    private static boolean canPlantBeBonemealed(Level level, BlockPos pos, BlockState BlockState2) {
        Block block = BlockState2.m_60734_();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock igrowable = (BonemealableBlock)block;
            if (!(BlockState2.m_60734_() instanceof TallGrassBlock) && !(BlockState2.m_60734_() instanceof GrassBlock) && igrowable.m_7370_((LevelReader)level, pos, BlockState2, level.m_5776_()) && !level.m_5776_()) {
                return igrowable.m_214167_(level, level.m_213780_(), pos, BlockState2);
            }
        }
        return false;
    }

    public static void accelerateTick(Level level, BlockPos pos, int randomTickInt, int beTickInt) {
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (!level.m_5776_()) {
            BlockEntityTicker ticker;
            BlockEntity entity;
            if (block.m_6724_(blockState) && randomTickInt == 0) {
                block.m_213898_(blockState, (ServerLevel)level, pos, level.m_213780_());
            }
            if (beTickInt == 0 && (entity = level.m_7702_(pos)) != null && (ticker = blockState.m_155944_(level, entity.m_58903_())) != null) {
                ticker.m_155252_(level, pos, blockState, entity);
            }
        }
    }

    public static TamedRat tameRat(Rat rat, Level level) {
        TamedRat newRat = new TamedRat((EntityType<? extends TamableAnimal>)((EntityType)RatsEntityRegistry.TAMED_RAT.get()), level);
        CompoundTag tag = new CompoundTag();
        rat.m_7380_(tag);
        newRat.setToga(rat.hasToga());
        newRat.m_20035_(rat.m_20183_(), rat.m_146908_(), rat.m_146909_());
        if (rat.m_21524_() != null) {
            newRat.m_21463_(rat.m_21524_(), true);
            rat.m_21463_(null, true);
        }
        ForgeEventFactory.onFinalizeSpawn((Mob)newRat, (ServerLevelAccessor)((ServerLevelAccessor)level), (DifficultyInstance)level.m_6436_(rat.m_20183_()), (MobSpawnType)MobSpawnType.EVENT, null, null);
        newRat.m_7378_(tag);
        newRat.setColorVariant(rat.getColorVariant());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            newRat.m_8061_(slot, rat.m_6844_(slot));
        }
        level.m_7967_((Entity)newRat);
        newRat.m_9236_().m_7605_((Entity)rat, (byte)83);
        newRat.m_146922_(rat.m_146908_());
        rat.m_146870_();
        return newRat;
    }

    public static RatVariant convertOldRatVariant(int variant) {
        return switch (variant) {
            case 1 -> (RatVariant)RatVariantRegistry.BLACK.get();
            case 2 -> (RatVariant)RatVariantRegistry.BROWN.get();
            case 3 -> (RatVariant)RatVariantRegistry.GREEN.get();
            case 4 -> (RatVariant)RatVariantRegistry.ALBINO.get();
            case 5 -> (RatVariant)RatVariantRegistry.HOODED.get();
            case 6 -> (RatVariant)RatVariantRegistry.BROWN_HOODED.get();
            case 7 -> (RatVariant)RatVariantRegistry.GRAY_HOODED.get();
            case 8 -> (RatVariant)RatVariantRegistry.SIAMESE.get();
            case 9 -> (RatVariant)RatVariantRegistry.WHITE.get();
            case 10 -> (RatVariant)RatVariantRegistry.YELLOW_HOODED.get();
            case 11, 12 -> (RatVariant)RatVariantRegistry.BROWN_UNDERCOAT.get();
            default -> (RatVariant)RatVariantRegistry.BLUE.get();
        };
    }
}

