/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.events.ForgeEvents;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record SyncArmSwingPacket(ItemStack stack) {
    public static SyncArmSwingPacket decode(FriendlyByteBuf buf) {
        return new SyncArmSwingPacket(buf.m_130267_());
    }

    public static void encode(SyncArmSwingPacket packet, FriendlyByteBuf buf) {
        buf.m_130055_(packet.stack());
    }

    public static class Handler {
        public static void handle(SyncArmSwingPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> ForgeEvents.handleArmSwing(packet.stack(), (Player)Objects.requireNonNull(((NetworkEvent.Context)context.get()).getSender())));
            context.get().setPacketHandled(true);
        }
    }
}

