/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public record RatCommandPacket(int ratId, int newCommand) {
    public static RatCommandPacket decode(FriendlyByteBuf buf) {
        return new RatCommandPacket(buf.readInt(), buf.readInt());
    }

    public static void encode(RatCommandPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.ratId());
        buf.writeInt(packet.newCommand());
    }

    public static class Handler {
        public static void handle(RatCommandPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Entity entity;
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null && (entity = player.m_9236_().m_6815_(packet.ratId())) instanceof TamedRat) {
                    TamedRat rat = (TamedRat)entity;
                    rat.setCommandInteger(packet.newCommand());
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

