/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.StatBoostingUpgrade;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class StatBoostingRatUpgradeItem
extends BaseRatUpgradeItem
implements StatBoostingUpgrade {
    private final Supplier<Map<Attribute, Double>> statChanges;
    private final boolean regens;

    public StatBoostingRatUpgradeItem(Item.Properties properties, int rarity, Supplier<Map<Attribute, Double>> statChanges) {
        this(properties, rarity, 0, statChanges, false);
    }

    public StatBoostingRatUpgradeItem(Item.Properties properties, int rarity, int textLength, Supplier<Map<Attribute, Double>> statChanges, boolean regens) {
        super(properties, rarity, textLength);
        this.statChanges = statChanges;
        this.regens = regens;
    }

    @Override
    public Map<Attribute, Double> getAttributeBoosts() {
        return this.statChanges.get();
    }

    @Override
    public boolean regeneratesHealth() {
        return this.regens;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        this.statChanges.get().forEach((attribute, aDouble) -> {
            if (aDouble > 0.0) {
                tooltip.add((Component)Component.m_237110_((String)"item.rats.rat_upgrade.stat_boost", (Object[])new Object[]{aDouble.toString(), Component.m_237115_((String)attribute.m_22087_())}).m_130940_(ChatFormatting.AQUA));
            }
        });
        if (this.regens) {
            tooltip.add((Component)Component.m_237115_((String)"item.rats.rat_upgrade.regenerates_health").m_130940_(ChatFormatting.AQUA));
        }
    }
}

