/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.client.events.ModClientEvents;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MobFilterUpgradeItem
extends BaseRatUpgradeItem {
    public MobFilterUpgradeItem(Item.Properties properties) {
        super(properties, 1, 2);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.m_5776_() && player.m_21120_(hand).m_150930_((Item)this)) {
            ModClientEvents.openMobFilterScreen(hand);
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return super.m_7203_(level, player, hand);
    }

    public static boolean isWhitelist(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_("Whitelist");
    }

    public static void setWhitelist(ItemStack stack, boolean whitelist) {
        stack.m_41784_().m_128379_("Whitelist", whitelist);
    }

    public static List<String> getSelectedMobs(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> mobs = new ArrayList<String>();
        ListTag tag = stack.m_41783_().m_128437_("Mobs", 8);
        for (int i = 0; i < tag.size(); ++i) {
            String s = tag.m_128778_(i);
            mobs.add(s);
        }
        return mobs;
    }

    public static void setMobs(ItemStack stack, List<String> mobs) {
        ListTag tag = new ListTag();
        for (String mob : mobs) {
            if (!BuiltInRegistries.f_256780_.m_7804_(new ResourceLocation(mob))) continue;
            tag.add((Object)StringTag.m_129297_((String)mob));
        }
        stack.m_41784_().m_128365_("Mobs", (Tag)tag);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237110_((String)"item.rats.rat_upgrade_mob_filter.mode", (Object[])new Object[]{Component.m_237115_((String)(MobFilterUpgradeItem.isWhitelist(stack) ? "item.rats.rat_upgrade_mob_filter.whitelist" : "item.rats.rat_upgrade_mob_filter.blacklist"))}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.rats.rat_upgrade_mob_filter.selected_mobs").m_130940_(ChatFormatting.GRAY));
        if (!MobFilterUpgradeItem.getSelectedMobs(stack).isEmpty()) {
            List<String> mobs = MobFilterUpgradeItem.getSelectedMobs(stack);
            for (int i = 0; i < mobs.size() && i < 3; ++i) {
                tooltip.add((Component)CommonComponents.m_264333_().m_7220_((Component)Component.m_237113_((String)mobs.get(i)).m_130940_(ChatFormatting.GRAY)));
            }
            if (mobs.size() > 3) {
                tooltip.add((Component)CommonComponents.m_264333_().m_7220_((Component)Component.m_237110_((String)"rats.and_more", (Object[])new Object[]{mobs.size() - 3}).m_130940_(ChatFormatting.GRAY)));
            }
        }
    }
}

