/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.mount;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.mount.RatMountBase;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class RatBeastMount
extends RatMountBase
implements IAnimatedEntity {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SLASH = Animation.create((int)25);
    public static final Animation ANIMATION_SNIFF = Animation.create((int)20);
    private static final EntityDataAccessor<Integer> COLOR_VARIANT = SynchedEntityData.m_135353_(RatBeastMount.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int animationTick;
    private Animation currentAnimation;

    public RatBeastMount(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22284_, 5.0);
    }

    public boolean m_7327_(Entity entity) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.m_217043_().m_188499_() ? ANIMATION_SLASH : ANIMATION_BITE);
        }
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(COLOR_VARIANT, (Object)0);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        float idleSpeed = 0.3f;
        float idleDegree = 0.015f;
        float walkSpeed = 0.4f;
        float walkDegree = 0.1f;
        float bob = -((float)(Math.sin((float)this.f_19797_ * idleSpeed) * (double)idleDegree - (double)idleDegree));
        float bob_walk = -((float)(Math.sin(this.f_267362_.m_267756_() * walkSpeed) * (double)this.f_267362_.m_267731_() * (double)walkDegree - (double)walkDegree));
        this.riderY = 0.8f + bob + bob_walk;
        this.riderXZ = 0.1f;
        if (this.getAnimation() == ANIMATION_SNIFF || this.getAnimation() == ANIMATION_SLASH) {
            float max;
            float jumpAdd = max = 0.75f;
            if (this.getAnimationTick() < 5) {
                jumpAdd = (float)this.getAnimationTick() * (max / 3.0f);
            }
            if (this.getAnimationTick() > 15) {
                jumpAdd = (float)(20 - this.getAnimationTick()) * (max / 10.0f);
            }
            this.riderY += (double)jumpAdd;
        }
        if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) < 5.0f && this.m_142582_((Entity)this.m_5448_()) && this.m_5448_().m_6084_()) {
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 80.0f);
            if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() > 8 && this.getAnimationTick() < 12) {
                this.m_5448_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 5.0f);
                this.m_5448_().m_147240_(0.25, this.m_20185_() - this.m_5448_().m_20185_(), this.m_20189_() - this.m_5448_().m_20189_());
            }
            if (this.getAnimation() == ANIMATION_SLASH && (this.getAnimationTick() == 8 || this.getAnimationTick() == 16)) {
                this.m_5448_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 5.0f);
                this.m_5448_().m_147240_(0.25, this.m_20185_() - this.m_5448_().m_20185_(), this.m_20189_() - this.m_5448_().m_20189_());
            }
        }
        if (!this.m_9236_().m_5776_() && this.m_5448_() == null && this.m_217043_().m_188503_(150) == 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SNIFF);
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.getAnimation() == ANIMATION_SLASH || this.getAnimation() == ANIMATION_SNIFF) {
            return EntityDimensions.m_20398_((float)1.85f, (float)2.25f);
        }
        return super.m_6972_(pose);
    }

    public int getColorVariant() {
        return (Integer)this.m_20088_().m_135370_(COLOR_VARIANT);
    }

    public void setColorVariant(int color) {
        this.m_20088_().m_135381_(COLOR_VARIANT, (Object)color);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ColorVariant", this.getColorVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setColorVariant(compound.m_128451_("ColorVariant"));
    }

    protected int m_5639_(float dist, float multiplier) {
        return super.m_5639_(dist, multiplier) - 5;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        this.setColorVariant(this.m_217043_().m_188503_(4));
        return spawnData;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
        this.m_6210_();
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_SLASH, ANIMATION_SNIFF};
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)RatsSoundRegistry.RAT_BEAST_GROWL.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)RatsSoundRegistry.RAT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)RatsSoundRegistry.RAT_DIE.get();
    }

    public float m_6100_() {
        return super.m_6100_() * 0.4f;
    }

    @Override
    public Item getUpgradeItem() {
        return (Item)RatsItemRegistry.RAT_UPGRADE_BEAST_MOUNT.get();
    }

    @Override
    public void adjustRatTailRotation(AbstractRat rat, AdvancedModelBox upperTail, AdvancedModelBox lowerTail) {
        this.progressRotation(upperTail, rat.sitProgress, 1.3f, 0.0f, 0.0f, 20.0f);
        this.progressRotation(lowerTail, rat.sitProgress, -0.2f, 0.0f, 0.0f, 20.0f);
    }
}

