/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.misc;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.AdjustsRatTail;
import com.github.alexthe666.rats.server.entity.projectile.ArrowlikeProjectile;
import com.github.alexthe666.rats.server.entity.projectile.RattlingGunBullet;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RattlingGun
extends Entity
implements AdjustsRatTail {
    private static final EntityDataAccessor<Boolean> FIRING = SynchedEntityData.m_135353_(RattlingGun.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean prevFire;
    private int fireCooldown = 0;
    private boolean markedDead;
    private int damageTaken;

    public RattlingGun(EntityType<? extends Entity> type, Level level) {
        super(type, level);
        this.m_6210_();
    }

    protected void m_7378_(CompoundTag tag) {
    }

    protected void m_7380_(CompoundTag tag) {
    }

    public LivingEntity m_6688_() {
        if (!this.m_20197_().isEmpty()) {
            for (Entity entity : this.m_20197_()) {
                if (!(entity instanceof TamedRat)) continue;
                TamedRat rat = (TamedRat)entity;
                return rat;
            }
        }
        return null;
    }

    public double m_6049_() {
        return 0.45;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        float radius = 0.9f;
        float angle = (float)Math.PI / 180 * (this.m_146908_() + 150.0f);
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double extraY = 1.3;
        callback.m_20372_(passenger, this.m_20185_() + extraX, this.m_20186_() + extraY, this.m_20189_() + extraZ);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(FIRING, (Object)false);
    }

    public boolean isFiring() {
        return (Boolean)this.m_20088_().m_135370_(FIRING);
    }

    public void setFiring(boolean firing) {
        this.m_20088_().m_135381_(FIRING, (Object)firing);
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity passenger = this.m_6688_();
        if (this.m_20202_() != null && !this.m_20202_().m_20159_()) {
            this.m_20202_().m_7998_((Entity)this, true);
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.prevFire != this.isFiring()) {
                this.fireCooldown = 4;
            }
            if (this.isFiring() && this.fireCooldown == 0) {
                this.setFiring(false);
            }
            if (this.fireCooldown > 0) {
                --this.fireCooldown;
            }
            this.prevFire = this.isFiring();
            if (passenger != null) {
                TamedRat rat;
                this.m_146922_(passenger.m_146908_());
                this.f_19859_ = passenger.m_146908_();
                if (passenger instanceof TamedRat && (rat = (TamedRat)passenger).m_5448_() != null && rat.m_5448_().m_6084_() && rat.m_5448_().m_19879_() != this.m_19879_()) {
                    this.shoot(rat);
                }
            }
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        this.m_20101_();
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.m_6688_() == null) {
            if (!player.m_20197_().isEmpty()) {
                boolean flag = false;
                for (Entity entity : player.m_20197_()) {
                    if (!(entity instanceof TamedRat)) continue;
                    flag = true;
                    entity.m_7998_((Entity)this, false);
                    break;
                }
                return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
            if (player.m_6144_()) {
                this.m_19998_((ItemLike)RatlantisItemRegistry.RATTLING_GUN.get());
                this.m_146870_();
                return InteractionResult.SUCCESS;
            }
        } else {
            TamedRat rat;
            LivingEntity passenger = this.m_6688_();
            if (passenger instanceof TamedRat && (rat = (TamedRat)passenger).m_21830_((LivingEntity)player)) {
                passenger.m_8127_();
                passenger.m_20329_((Entity)player);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void shoot(TamedRat rat) {
        LivingEntity target = rat.m_5448_();
        if (target != null) {
            double d0 = target.m_20185_() - this.m_20185_();
            double d2 = target.m_20189_() - this.m_20189_();
            float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            this.m_146922_(f % 360.0f);
            rat.f_20883_ = f % 360.0f;
            rat.m_146922_(f % 360.0f);
            rat.f_20885_ = f % 360.0f;
            RattlingGunBullet bullet = new RattlingGunBullet((EntityType<? extends ArrowlikeProjectile>)((EntityType)RatlantisEntityRegistry.RATTLING_GUN_BULLET.get()), this.m_9236_(), (LivingEntity)rat);
            float radius = 1.6f;
            float angle = (float)Math.PI / 180 * this.m_146908_();
            double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + this.m_20185_() + (double)(this.f_19796_.m_188501_() * 0.2f) - 0.1;
            double extraZ = (double)(radius * Mth.m_14089_((float)angle)) + this.m_20189_() + (double)(this.f_19796_.m_188501_() * 0.2f) - 0.1;
            double extraY = 1.35 + this.m_20186_() + (double)(this.f_19796_.m_188501_() * 0.1f) - 0.05;
            double d02 = target.m_20186_() + (double)target.m_20192_() / 2.0;
            double d1 = target.m_20185_() - extraX;
            double d3 = target.m_20189_() - extraZ;
            double d22 = d02 - extraY;
            float velocity = 2.2f;
            bullet.m_6034_(extraX, extraY, extraZ);
            bullet.m_6686_(d1, d22, d3, velocity, 0.4f);
            this.m_5496_((SoundEvent)RatsSoundRegistry.RATTLING_GUN_SHOOT.get(), 0.5f, 2.3f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_7967_((Entity)bullet);
            }
            this.setFiring(true);
        }
    }

    @Override
    public void adjustRatTailRotation(AbstractRat rat, AdvancedModelBox upperTail, AdvancedModelBox lowerTail) {
        this.progressRotation(upperTail, rat.sitProgress, 1.1f, 0.17453292f, 0.6981317f, 20.0f);
        this.progressRotation(lowerTail, rat.sitProgress, 0.3f, 0.61086524f, 0.0f, 20.0f);
    }
}

