/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal.harvest;

import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.ai.goal.RatWorkGoal;
import com.github.alexthe666.rats.server.entity.rat.RatCommand;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRatHarvestGoal
extends Goal
implements RatWorkGoal {
    private final BlockSorter targetSorter;
    @Nullable
    private BlockPos targetBlock = null;
    @Nullable
    private Entity targetEntity = null;
    protected final TamedRat rat;
    protected int nextStartTick;

    protected BaseRatHarvestGoal(TamedRat rat) {
        this.rat = rat;
        this.targetSorter = new BlockSorter((Entity)rat);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean checkTheBasics(boolean checkForItems, boolean checkForItemHolding) {
        if (!this.rat.canMove() || this.rat.getCommand() != RatCommand.HARVEST || this.rat.isInCage()) {
            return false;
        }
        if (checkForItemHolding && !this.checkIfItemCanBeHeld()) {
            return false;
        }
        return !checkForItems || !this.anyHoldableItemsAround();
    }

    public boolean m_8036_() {
        return this.isReadyToFire();
    }

    public boolean isReadyToFire() {
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        this.nextStartTick = this.m_183277_(20);
        return true;
    }

    protected boolean checkIfItemCanBeHeld() {
        ItemStack stack = this.rat.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41619_()) {
            return true;
        }
        return RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_PLATTER.get()) && stack.m_41613_() < 64;
    }

    private boolean anyHoldableItemsAround() {
        List items = this.rat.m_9236_().m_6443_(ItemEntity.class, this.getTargetableArea(), item -> (item.m_20096_() || item.m_20069_()) && this.rat.canRatPickupItem(item.m_32055_()));
        if (items.isEmpty()) {
            return false;
        }
        items.sort(Comparator.comparingDouble(arg_0 -> ((TamedRat)this.rat).m_20280_(arg_0)));
        ArrayList<ItemEntity> revisedList = new ArrayList<ItemEntity>();
        for (ItemEntity item2 : items) {
            Path toPath = this.rat.m_21573_().m_6570_((Entity)item2, 1);
            if (toPath == null || !toPath.m_77403_() || !this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_PLATTER.get()) && !ItemStack.m_150942_((ItemStack)item2.m_32055_(), (ItemStack)this.rat.m_21120_(InteractionHand.MAIN_HAND))) continue;
            revisedList.add(item2);
        }
        return !revisedList.isEmpty();
    }

    protected AABB getTargetableArea() {
        if (this.rat.m_21824_() && this.rat.getRadiusCenter().isPresent()) {
            Vec3 center = new Vec3((double)this.rat.getSearchCenter().m_123341_() + 0.5, (double)this.rat.getSearchCenter().m_123342_() + 0.5, (double)this.rat.getSearchCenter().m_123343_() + 0.5);
            double radius = this.rat.getRadius();
            AABB aabb = new AABB(-radius, -radius, -radius, radius, radius, radius);
            return aabb.m_82383_(center);
        }
        return this.rat.m_20191_().m_82400_(8.0);
    }

    public void m_8056_() {
        this.rat.isCurrentlyWorking = true;
    }

    public void m_8041_() {
        this.rat.isCurrentlyWorking = false;
        this.rat.m_21573_().m_26573_();
        this.setTargetBlock(null);
        this.setTargetEntity(null);
    }

    public BlockSorter getTargetSorter() {
        return this.targetSorter;
    }

    @Nullable
    public BlockPos getTargetBlock() {
        return this.targetBlock;
    }

    public void setTargetBlock(@Nullable BlockPos pos) {
        this.targetBlock = pos;
    }

    @Nullable
    public Entity getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(@Nullable Entity entity) {
        this.targetEntity = entity;
    }

    public void holdItemHarvestedIfPossible(TamedRat rat, List<ItemStack> items) {
        for (ItemStack stack : items) {
            if (rat.m_21205_().m_41619_() && rat.canRatPickupItem(stack)) {
                rat.m_21008_(InteractionHand.MAIN_HAND, stack);
                continue;
            }
            if (ItemStack.m_41656_((ItemStack)rat.m_21205_(), (ItemStack)stack) && stack.m_41613_() + rat.m_21205_().m_41613_() <= 64) {
                rat.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)rat.m_21205_().m_41720_(), rat.m_21205_().m_41613_() + stack.m_41613_()));
                continue;
            }
            ItemEntity item = new ItemEntity(this.rat.m_9236_(), this.rat.m_20185_(), this.rat.m_20186_(), this.rat.m_20189_(), stack);
            item.m_32064_();
            item.m_32061_();
            this.rat.m_9236_().m_7967_((Entity)item);
        }
    }

    @Override
    public RatWorkGoal.TaskType getRatTaskType() {
        return RatWorkGoal.TaskType.HARVEST;
    }

    public record BlockSorter(Entity entity) implements Comparator<BlockPos>
    {
        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = this.distanceTo(pos1);
            double distance2 = this.distanceTo(pos2);
            return Double.compare(distance1, distance2);
        }

        private double distanceTo(BlockPos pos) {
            double deltaX = this.entity.m_20185_() - ((double)pos.m_123341_() + 0.5);
            double deltaY = this.entity.m_20186_() + (double)this.entity.m_20192_() - ((double)pos.m_123342_() + 0.5);
            double deltaZ = this.entity.m_20189_() - ((double)pos.m_123343_() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

