/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.block.IceSheetBlock;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.IceSheetConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class IceSheetFeature
extends Feature<IceSheetConfiguration> {
    public IceSheetFeature(Codec<IceSheetConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<IceSheetConfiguration> featurePlaceContext) {
        WorldGenLevel worldGenLevel = featurePlaceContext.m_159774_();
        BlockPos originPos = featurePlaceContext.m_159777_();
        IceSheetConfiguration config = (IceSheetConfiguration)featurePlaceContext.m_159778_();
        int radius = config.searchRange;
        BlockPos.MutableBlockPos blockPos = originPos.m_122032_();
        BlockPos.MutableBlockPos neighborPos = blockPos.m_122032_();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double dx = (double)x / (double)radius;
                    double dy = (double)y / (double)radius;
                    double dz = (double)z / (double)radius;
                    if (dx * dx + dy * dy + dz * dz > 1.0) continue;
                    blockPos.m_122154_((Vec3i)originPos, x, y, z);
                    BlockState blockState = worldGenLevel.m_8055_((BlockPos)blockPos);
                    if (!IceSheetFeature.isAirOrWater(blockState)) continue;
                    for (Direction direction : config.validDirections) {
                        IceSheetBlock iceSheetBlock;
                        BlockState updatedBlockState;
                        neighborPos.m_122159_((Vec3i)blockPos, direction);
                        BlockState neighborBlockState = worldGenLevel.m_8055_((BlockPos)neighborPos);
                        if (neighborBlockState.m_204336_(BlockModule.ICE_SHEET_FEATURE_AVOID) || (updatedBlockState = (iceSheetBlock = (IceSheetBlock)((Object)BlockModule.ICE_SHEET.get())).m_153940_(blockState, (BlockGetter)worldGenLevel, (BlockPos)blockPos, direction)) == null) continue;
                        blockState = updatedBlockState;
                    }
                    if (!blockState.m_60713_((Block)BlockModule.ICE_SHEET.get())) continue;
                    blockState = (BlockState)blockState.m_61124_((Property)IceSheetBlock.GROWTH_DISTANCE, (Comparable)Integer.valueOf(3));
                    worldGenLevel.m_7731_((BlockPos)blockPos, blockState, 3);
                    worldGenLevel.m_46865_((BlockPos)blockPos).m_8113_((BlockPos)blockPos);
                }
            }
        }
        return true;
    }

    private static boolean isAirOrWater(BlockState blockState) {
        return blockState.m_60795_() || blockState.m_60713_(Blocks.f_49990_);
    }
}

