/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.client.FARenderTypes;
import com.stal111.forbidden_arcanus.client.model.MagicCircleModel;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.RitualManager;
import com.stal111.forbidden_arcanus.common.network.NetworkHandler;
import com.stal111.forbidden_arcanus.common.network.clientbound.CreateMagicCirclePacket;
import com.stal111.forbidden_arcanus.common.network.clientbound.RemoveMagicCirclePacket;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class MagicCircle {
    private final Level level;
    private final BlockPos pos;
    private final ResourceLocation innerTexture;
    private final ResourceLocation outerTexture;
    private int counter;

    public MagicCircle(Level level, BlockPos pos, ResourceLocation innerTexture, ResourceLocation outerTexture) {
        this.level = level;
        this.pos = pos;
        this.innerTexture = innerTexture;
        this.outerTexture = outerTexture;
    }

    public void tick() {
        ++this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public void render(PoseStack poseStack, float partialTicks, MultiBufferSource buffer, int packedLight, MagicCircleModel model) {
        float rotation = (float)this.counter + partialTicks;
        float ritualProgress = RitualManager.getRitualProgress(rotation);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        float size = this.easeSineOut(Math.min((double)ritualProgress, 0.25), 1.25, 7.25, 0.25);
        poseStack.m_85841_(size, 1.0f, size);
        float alpha = ritualProgress > 0.9f ? this.easeSineOut(ritualProgress - 0.9f, 1.0, -1.0, 0.1) : 1.0f;
        poseStack.m_252781_(Axis.f_252392_.m_252977_(rotation));
        model.outerRing().m_104306_(poseStack, buffer.m_6299_(FARenderTypes.entityFullbrightTranslucent(this.outerTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(-rotation * 2.0f));
        model.innerRing().m_104306_(poseStack, buffer.m_6299_(FARenderTypes.entityFullbrightTranslucent(this.innerTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
        poseStack.m_85849_();
        if (ritualProgress > 0.9f) {
            RandomSource random = this.level.m_213780_();
            double posX = (double)this.pos.m_123341_() + 0.25 + (double)random.m_188501_() + (double)random.m_188503_(4);
            double posZ = (double)this.pos.m_123343_() + 0.25 + (double)random.m_188501_() + (double)random.m_188503_(4);
            double ySpeed = ((double)random.m_188501_() - 0.4) * 0.125;
            this.level.m_7106_((ParticleOptions)ModParticles.AUREAL_MOTE.get(), posX - 2.0, (double)((float)this.pos.m_123342_() + 0.1f), posZ - 2.0, 0.0, ySpeed, 0.0);
        }
    }

    public float easeSineIn(double progress, double start, double change, double duration) {
        return (float)(-change * Math.cos(progress / duration * 1.5707963267948966) + change + start);
    }

    public float easeSineOut(double progress, double start, double change, double duration) {
        return (float)(change * Math.sin(progress / duration * 1.5707963267948966) + start);
    }

    public static interface TextureProvider {
        public ResourceLocation getInnerTexture();

        public ResourceLocation getOuterTexture();

        default public void createMagicCircle(Level level, BlockPos pos, int progress) {
            NetworkHandler.sendToTrackingChunk(level.m_46745_(pos), new CreateMagicCirclePacket(pos, this, progress));
        }

        default public void removeMagicCircle(Level level, BlockPos pos) {
            NetworkHandler.sendToTrackingChunk(level.m_46745_(pos), new RemoveMagicCirclePacket(pos));
        }
    }

    public record Config(ResourceLocation innerTexture, ResourceLocation outerTexture) {
        private static final ResourceLocation DEFAULT_INNER_TEXTURE = new ResourceLocation("forbidden_arcanus", "textures/effect/magic_circle/inner/union.png");
        private static final ResourceLocation DEFAULT_OUTER_TEXTURE = new ResourceLocation("forbidden_arcanus", "textures/effect/magic_circle/outer/pure.png");
        public static final Config DEFAULT = new Config(DEFAULT_INNER_TEXTURE, DEFAULT_OUTER_TEXTURE);
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("inner_texture").forGetter(config -> config.innerTexture), (App)ResourceLocation.f_135803_.fieldOf("outer_texture").forGetter(config -> config.outerTexture)).apply((Applicative)instance, Config::new));
    }
}

