/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.items.IItemHandler;

public abstract class ItemRequirement
implements Predicate<ItemStack> {
    private static ItemRequirement NULL = null;
    private int count;

    @Nonnull
    public static ItemRequirement getNull() {
        if (NULL == null) {
            NULL = new NullRequirement();
        }
        return NULL;
    }

    public int getCount() {
        return this.count;
    }

    private ItemRequirement(int count) {
        this.count = count;
    }

    @Override
    public abstract boolean test(ItemStack var1);

    public final boolean isNull() {
        return this instanceof NullRequirement || this.count <= 0;
    }

    public boolean tryMerge(@Nonnull ItemRequirement other) {
        if (this.matches(other)) {
            this.count += other.count;
            other.count = 0;
            return true;
        }
        return false;
    }

    public static ItemRequirement of(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return ItemRequirement.getNull();
        }
        return new StackMatch(stack, stack.m_41613_());
    }

    public static ItemRequirement ofItemNoNBT(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return ItemRequirement.getNull();
        }
        return ItemRequirement.of(stack.m_41720_(), stack.m_41613_());
    }

    public static ItemRequirement of(Item item, int count) {
        if (item == null || item == Items.f_41852_) {
            return ItemRequirement.getNull();
        }
        return new ItemMatch(item, count);
    }

    public static ItemRequirement of(Ingredient ingredient, int count) {
        if (ingredient == null) {
            return ItemRequirement.getNull();
        }
        return new IngredientRequirement(ingredient, count);
    }

    public static List<ItemStack> getRandomItemsMatchingRequirements(IItemHandler container, ItemRequirement requirement1, ItemRequirement requirement2) {
        if (requirement1.isNull() && requirement2.isNull()) {
            return null;
        }
        if (requirement1.isNull()) {
            List<ItemStack> validItems = ItemRequirement.getValidItems(container, requirement2);
            if (validItems.isEmpty()) {
                return null;
            }
            return Lists.newArrayList((Object[])new ItemStack[]{ItemRequirement.getRandomItem(validItems, requirement2.count)});
        }
        if (requirement2.isNull()) {
            List<ItemStack> validItems = ItemRequirement.getValidItems(container, requirement1);
            if (validItems.isEmpty()) {
                return null;
            }
            return Lists.newArrayList((Object[])new ItemStack[]{ItemRequirement.getRandomItem(validItems, requirement1.count)});
        }
        List<ItemStack> validItems1 = ItemRequirement.getValidItems(container, requirement1);
        List<ItemStack> validItems2 = ItemRequirement.getValidItems(container, requirement2);
        for (int x = 0; x < validItems1.size(); ++x) {
            ItemStack s1 = validItems1.get(x);
            for (int y = 0; y < validItems2.size(); ++y) {
                int count;
                ItemStack s2 = validItems2.get(y);
                if (!InventoryUtil.ItemMatches(s1, s2) || (count = InventoryUtil.GetItemCount(container, s1)) >= requirement1.count + requirement2.count) continue;
                if (validItems2.size() == 1) {
                    validItems1.remove(s1);
                    --x;
                    continue;
                }
                validItems2.remove(s2);
                --y;
            }
        }
        if (!validItems1.isEmpty() && !validItems2.isEmpty()) {
            return Lists.newArrayList((Object[])new ItemStack[]{ItemRequirement.getRandomItem(validItems1, requirement1.count), ItemRequirement.getRandomItem(validItems2, requirement2.count)});
        }
        return null;
    }

    public static List<ItemStack> getValidItems(IItemHandler container, ItemRequirement requirement) {
        ArrayList<ItemStack> validItems = new ArrayList<ItemStack>();
        for (int i = 0; i < container.getSlots(); ++i) {
            ItemStack stack = container.getStackInSlot(i);
            if (!requirement.test(stack) || InventoryUtil.GetItemCount(container, stack) < requirement.count || !ItemRequirement.isNotInList(validItems, stack)) continue;
            validItems.add(stack.m_41777_());
        }
        return validItems;
    }

    public static boolean isNotInList(List<ItemStack> list, ItemStack stack) {
        for (ItemStack i : list) {
            if (!InventoryUtil.ItemMatches(i, stack)) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getRandomItem(List<ItemStack> validItems, int count) {
        if (validItems.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = validItems.get(new Random().nextInt(validItems.size()));
        stack.m_41764_(count);
        return stack;
    }

    public static List<ItemStack> getFirstItemsMatchingRequirements(Container container, ItemRequirement ... requirements) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        HashMap<Integer, Integer> consumedItems = new HashMap<Integer, Integer>();
        for (ItemRequirement requirement : requirements) {
            int leftToConsume = requirement.count;
            for (int i = 0; i < container.m_6643_() && leftToConsume > 0; ++i) {
                ItemStack stack = container.m_8020_(i);
                if (!requirement.test(stack)) continue;
                int alreadyConsumed = consumedItems.getOrDefault(i, 0);
                int consumeCount = Math.min(leftToConsume, stack.m_41613_() - alreadyConsumed);
                leftToConsume -= consumeCount;
                if (consumeCount <= 0) continue;
                consumedItems.put(i, alreadyConsumed + consumeCount);
                boolean query = true;
                for (int x = 0; x < results.size() && query; ++x) {
                    if (!InventoryUtil.ItemMatches((ItemStack)results.get(x), stack)) continue;
                    query = false;
                    ((ItemStack)results.get(x)).m_41769_(consumeCount);
                }
                if (!query) continue;
                ItemStack result = stack.m_41777_();
                result.m_41764_(consumeCount);
                results.add(result);
            }
            if (leftToConsume <= 0) continue;
            return null;
        }
        return results;
    }

    public static List<ItemStack> getFirstItemsMatchingRequirements(IItemHandler container, ItemRequirement ... requirements) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        HashMap<Integer, Integer> consumedItems = new HashMap<Integer, Integer>();
        for (ItemRequirement requirement : requirements) {
            int leftToConsume = requirement.count;
            for (int i = 0; i < container.getSlots() && leftToConsume > 0; ++i) {
                ItemStack stack = container.getStackInSlot(i);
                if (!requirement.test(stack)) continue;
                int alreadyConsumed = consumedItems.getOrDefault(i, 0);
                int consumeCount = Math.min(leftToConsume, stack.m_41613_() - alreadyConsumed);
                leftToConsume -= consumeCount;
                if (consumeCount <= 0) continue;
                consumedItems.put(i, alreadyConsumed + consumeCount);
                boolean query = true;
                for (int x = 0; x < results.size() && query; ++x) {
                    if (!InventoryUtil.ItemMatches((ItemStack)results.get(x), stack)) continue;
                    query = false;
                    ((ItemStack)results.get(x)).m_41769_(consumeCount);
                }
                if (!query) continue;
                ItemStack result = stack.m_41777_();
                result.m_41764_(consumeCount);
                results.add(result);
            }
            if (leftToConsume <= 0) continue;
            return null;
        }
        return results;
    }

    public abstract boolean matches(@Nonnull ItemRequirement var1);

    private static class NullRequirement
    extends ItemRequirement {
        private NullRequirement() {
            super(0);
        }

        @Override
        public boolean test(ItemStack stack) {
            return false;
        }

        @Override
        public boolean matches(@Nonnull ItemRequirement otherRequirement) {
            return otherRequirement instanceof NullRequirement;
        }
    }

    private static class StackMatch
    extends ItemRequirement {
        private final ItemStack stack;

        private StackMatch(@Nonnull ItemStack stack) {
            this(stack, stack.m_41613_());
        }

        private StackMatch(@Nonnull ItemStack stack, int count) {
            super(count);
            this.stack = stack;
        }

        @Override
        public boolean test(ItemStack stack) {
            return InventoryUtil.ItemMatches(this.stack, stack);
        }

        @Override
        public boolean matches(@Nonnull ItemRequirement otherRequirement) {
            if (otherRequirement instanceof StackMatch) {
                StackMatch pm = (StackMatch)otherRequirement;
                return InventoryUtil.ItemMatches(this.stack, pm.stack);
            }
            return false;
        }
    }

    private static class ItemMatch
    extends ItemRequirement {
        private final Item item;

        private ItemMatch(@Nonnull Item item, int count) {
            super(count);
            this.item = item;
        }

        @Override
        public boolean test(ItemStack stack) {
            return stack.m_41720_() == this.item;
        }

        @Override
        public boolean matches(@Nonnull ItemRequirement otherRequirement) {
            if (otherRequirement instanceof ItemMatch) {
                ItemMatch im = (ItemMatch)otherRequirement;
                return im.item == this.item;
            }
            return false;
        }
    }

    private static class IngredientRequirement
    extends ItemRequirement {
        private final Ingredient ingredient;

        private IngredientRequirement(Ingredient ingredient, int count) {
            super(count);
            this.ingredient = ingredient;
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.ingredient.test(stack);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(@Nonnull ItemRequirement otherRequirement) {
            if (!(otherRequirement instanceof IngredientRequirement)) return false;
            IngredientRequirement other = (IngredientRequirement)otherRequirement;
            if (!other.ingredient.equals(this.ingredient)) return false;
            return true;
        }
    }
}

