/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.jeiplugin.util;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.input.ClickableIngredient;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class JEIScreenArea<T extends EasyMenuScreen<?>>
implements IGuiContainerHandler<T> {
    private final IIngredientManager manager;

    public static <T extends EasyMenuScreen<?>> JEIScreenArea<T> create(Class<T> clazz, IIngredientManager manager) {
        return new JEIScreenArea<T>(manager);
    }

    private JEIScreenArea(IIngredientManager manager) {
        this.manager = manager;
    }

    @Nonnull
    public List<Rect2i> getGuiExtraAreas(@Nonnull T screen) {
        ArrayList<Rect2i> list = new ArrayList<Rect2i>();
        ScreenArea screenArea = ((EasyMenuScreen)screen).getArea();
        for (GuiEventListener child : screen.m_6702_()) {
            ScreenArea area;
            if (!(child instanceof EasyWidget)) continue;
            EasyWidget widget = (EasyWidget)child;
            if (!widget.f_93624_ || !screenArea.isOutside(area = widget.getArea())) continue;
            list.add(new Rect2i(area.x, area.y, area.width, area.height));
        }
        return list;
    }

    @Nonnull
    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(@Nonnull T screen, double mouseX, double mouseY) {
        ScreenPosition mousePos = ScreenPosition.of(mouseX, mouseY);
        Pair item = screen.getHoveredItem(mousePos);
        if (item != null && !((ItemStack)item.getFirst()).m_41619_()) {
            return this.createClickable((ItemStack)item.getFirst(), (ScreenArea)item.getSecond());
        }
        Pair fluid = screen.getHoveredFluid(mousePos);
        if (fluid != null && !((FluidStack)fluid.getFirst()).isEmpty()) {
            return this.createClickable((FluidStack)fluid.getFirst(), (ScreenArea)fluid.getSecond());
        }
        return super.getClickableIngredientUnderMouse(screen, mouseX, mouseY);
    }

    private Optional<IClickableIngredient<?>> createClickable(ItemStack item, ScreenArea area) {
        return this.manager.createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)item).map(t -> new ClickableIngredient(t, JEIScreenArea.asRect(area)));
    }

    private Optional<IClickableIngredient<?>> createClickable(FluidStack fluid, ScreenArea area) {
        return this.manager.createTypedIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)fluid).map(t -> new ClickableIngredient(t, JEIScreenArea.asRect(area)));
    }

    private static ImmutableRect2i asRect(ScreenArea area) {
        return new ImmutableRect2i(area.x, area.y, area.width, area.height);
    }
}

