/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.TraderPeripheral;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Direction;

public abstract class InputTraderPeripheral<BE extends TraderBlockEntity<T>, T extends InputTraderData>
extends TraderPeripheral<BE, T> {
    public InputTraderPeripheral(BE be) {
        super(be);
    }

    public InputTraderPeripheral(T trader) {
        super(trader);
    }

    @Override
    public Set<String> getAdditionalTypes() {
        HashSet<String> set = new HashSet<String>(super.getAdditionalTypes());
        set.add("lc_trader_input");
        return set;
    }

    @LuaFunction(mainThread=true)
    public boolean allowsInputs() throws LuaException {
        return ((InputTraderData)this.getTrader()).allowInputs();
    }

    @LuaFunction(mainThread=true)
    public boolean allowInputSide(String sideName) throws LuaException {
        Direction side = (Direction)EnumUtil.enumFromString((String)sideName, (Enum[])Direction.values(), null);
        if (side == null) {
            return false;
        }
        return ((InputTraderData)this.getTrader()).allowInputSide(side);
    }

    @LuaFunction(mainThread=true)
    public String[] getInputSides() throws LuaException {
        InputTraderData trader = (InputTraderData)this.getTrader();
        ArrayList<String> sides = new ArrayList<String>();
        for (Direction side : Direction.values()) {
            if (!trader.allowInputSide(side)) continue;
            sides.add(side.toString());
        }
        return (String[])sides.toArray(String[]::new);
    }

    @LuaFunction
    public boolean allowsOutputs() throws LuaException {
        return ((InputTraderData)this.getTrader()).allowOutputs();
    }

    @LuaFunction(mainThread=true)
    public boolean allowOutputSide(String sideName) throws LuaException {
        Direction side = (Direction)EnumUtil.enumFromString((String)sideName, (Enum[])Direction.values(), null);
        if (side == null) {
            return false;
        }
        return ((InputTraderData)this.getTrader()).allowOutputSide(side);
    }

    @LuaFunction(mainThread=true)
    public String[] getOutputSides() throws LuaException {
        InputTraderData trader = (InputTraderData)this.getTrader();
        ArrayList<String> sides = new ArrayList<String>();
        for (Direction side : Direction.values()) {
            if (!trader.allowOutputSide(side)) continue;
            sides.add(side.toString());
        }
        return (String[])sides.toArray(String[]::new);
    }
}

