/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.claiming;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.integration.claiming.IClaimPurchaseHandler;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;

public class LCClaiming {
    private static IClaimPurchaseHandler currentHandler = null;

    public static void setup(@Nonnull IClaimPurchaseHandler handler) {
        if (currentHandler != null && currentHandler != handler) {
            LightmansCurrency.LogWarning("Multiple compatible Claim Mods are available!");
        }
        if (currentHandler == null) {
            MinecraftForge.EVENT_BUS.addListener(LCClaiming::registerCommand);
        }
        currentHandler = handler;
    }

    private static void registerCommand(@Nonnull RegisterCommandsEvent event) {
        if (currentHandler == null) {
            return;
        }
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder lcclaimscommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lcclaims").requires(CommandSourceStack::m_230897_)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"buy").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"claim").executes(c -> LCClaiming.tryBuyClaim((CommandContext<CommandSourceStack>)c, 1))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> LCClaiming.tryBuyClaim((CommandContext<CommandSourceStack>)c, IntegerArgumentType.getInteger((CommandContext)c, (String)"count")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"forceload").executes(c -> LCClaiming.tryBuyForceload((CommandContext<CommandSourceStack>)c, 1))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> LCClaiming.tryBuyForceload((CommandContext<CommandSourceStack>)c, IntegerArgumentType.getInteger((CommandContext)c, (String)"count"))))))).then(Commands.m_82127_((String)"info").executes(LCClaiming::info));
        dispatcher.register(lcclaimscommand);
    }

    private static int info(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        ServerPlayer player = source.m_81375_();
        if (currentHandler == null) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_CLAIM_FAIL_NO_DATA.get(new Object[0]));
            return 0;
        }
        int count = 0;
        if (currentHandler.canBuyClaims(player)) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_CLAIM_INFO_CLAIMS.get(currentHandler.getCurrentBonusClaims(player), LCConfig.SERVER.claimingMaxClaimCount.get()), false);
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_CLAIM_INFO_PRICE.get(((MoneyValue)LCConfig.SERVER.claimingClaimPrice.get()).getText(LCText.COMMAND_CLAIM_INVALID.get(new Object[0]))), false);
            ++count;
        }
        if (currentHandler.canBuyForceload(player)) {
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_CLAIM_INFO_FORCELOAD.get(currentHandler.getCurrentBonusForceloadChunks(player), LCConfig.SERVER.claimingMaxForceloadCount.get()), false);
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_CLAIM_INFO_PRICE.get(((MoneyValue)LCConfig.SERVER.claimingForceloadPrice.get()).getText(LCText.COMMAND_CLAIM_INVALID.get(new Object[0]))), false);
            ++count;
        }
        if (count <= 0) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_CLAIM_INFO_DISABLED.get(new Object[0]));
        }
        return count;
    }

    private static int tryBuyClaim(CommandContext<CommandSourceStack> commandContext, int count) throws CommandSyntaxException {
        int boughtCount;
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        ServerPlayer player = source.m_81375_();
        if (currentHandler == null) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_CLAIM_FAIL_NO_DATA.get(new Object[0]));
            return 0;
        }
        if (!currentHandler.canBuyClaims(player)) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_CLAIM_BUY_CLAIM_DISABLED.get(new Object[0]));
            return 0;
        }
        MoneyValue price = (MoneyValue)LCConfig.SERVER.claimingClaimPrice.get();
        boolean hitLimit = false;
        boolean invalidPrice = price.isEmpty();
        for (boughtCount = 0; boughtCount < count && !invalidPrice; ++boughtCount) {
            int allowedToBuy = (Integer)LCConfig.SERVER.claimingMaxClaimCount.get() - currentHandler.getCurrentBonusClaims(player) - boughtCount;
            if (allowedToBuy <= 0) {
                hitLimit = true;
                break;
            }
            IMoneyHolder handler = MoneyAPI.API.GetPlayersMoneyHandler((Player)player);
            if (!handler.extractMoney(price, true).isEmpty()) break;
            handler.extractMoney(price, false);
        }
        if (boughtCount > 0) {
            currentHandler.addBonusClaims(player, boughtCount);
            if (hitLimit) {
                EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_CLAIM_BUY_CLAIM_LIMIT_REACHED.get(LCConfig.SERVER.claimingMaxClaimCount.get()), true);
            }
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_CLAIM_BUY_CLAIM_SUCCESS.get(boughtCount), true);
            return boughtCount;
        }
        if (invalidPrice) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_CLAIM_FAIL_INVALID_PRICE.get(new Object[0]));
        } else if (hitLimit) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_CLAIM_BUY_CLAIM_LIMIT_REACHED.get(LCConfig.SERVER.claimingMaxClaimCount.get()));
        } else {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_CLAIM_BUY_CLAIM_CANNOT_AFFORD.get(new Object[0]));
        }
        return 0;
    }

    private static int tryBuyForceload(CommandContext<CommandSourceStack> commandContext, int count) throws CommandSyntaxException {
        int boughtCount;
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        ServerPlayer player = source.m_81375_();
        if (currentHandler == null) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_CLAIM_FAIL_NO_DATA.get(new Object[0]));
            return 0;
        }
        if (!currentHandler.canBuyForceload(player)) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_CLAIM_BUY_FORCELOAD_DISABLED.get(new Object[0]));
            return 0;
        }
        MoneyValue price = (MoneyValue)LCConfig.SERVER.claimingForceloadPrice.get();
        boolean hitLimit = false;
        boolean invalidPrice = price.isEmpty();
        for (boughtCount = 0; boughtCount < count && !invalidPrice; ++boughtCount) {
            int allowedToBuy = (Integer)LCConfig.SERVER.claimingMaxForceloadCount.get() - currentHandler.getCurrentBonusForceloadChunks(player) - boughtCount;
            if (allowedToBuy <= 0) {
                hitLimit = true;
                break;
            }
            IMoneyHolder handler = MoneyAPI.API.GetPlayersMoneyHandler((Player)player);
            if (!handler.extractMoney(price, true).isEmpty()) break;
            handler.extractMoney(price, false);
        }
        if (boughtCount > 0) {
            currentHandler.addBonusForceloadChunks(player, boughtCount);
            if (hitLimit) {
                EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_CLAIM_BUY_FORCELOAD_LIMIT_REACHED.get(LCConfig.SERVER.claimingMaxForceloadCount.get()), true);
            }
            EasyText.sendCommandSucess(source, (Component)LCText.COMMAND_CLAIM_BUY_FORCELOAD_SUCCESS.get(boughtCount), true);
            return boughtCount;
        }
        if (invalidPrice) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_CLAIM_FAIL_INVALID_PRICE.get(new Object[0]));
        } else if (hitLimit) {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_CLAIM_BUY_FORCELOAD_LIMIT_REACHED.get(LCConfig.SERVER.claimingMaxForceloadCount.get()));
        } else {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_CLAIM_BUY_FORCELOAD_CANNOT_AFFORD.get(new Object[0]));
        }
        return 0;
    }
}

