/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.crafting.builders;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CouponRecipeBuilder
implements RecipeBuilder {
    private final Ingredient ingredient;
    private Item result;
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();

    private CouponRecipeBuilder(@Nonnull Ingredient ingredient) {
        this.ingredient = ingredient;
    }

    public static CouponRecipeBuilder of(@Nonnull TagKey<Item> tag) {
        return CouponRecipeBuilder.of(Ingredient.m_204132_(tag));
    }

    public static CouponRecipeBuilder of(@Nonnull ItemLike item) {
        return CouponRecipeBuilder.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public static CouponRecipeBuilder of(@Nonnull Ingredient ingredient) {
        return new CouponRecipeBuilder(ingredient);
    }

    @Nonnull
    public CouponRecipeBuilder withResult(@Nonnull Supplier<? extends ItemLike> result) {
        return this.withResult(result.get());
    }

    public CouponRecipeBuilder withResult(@Nonnull ItemLike result) {
        this.result = result.m_5456_();
        return this;
    }

    @Nonnull
    public CouponRecipeBuilder unlockedBy(@Nonnull String name, @Nonnull CriterionTriggerInstance criteria) {
        this.advancement.m_138386_(name, criteria);
        return this;
    }

    @Nonnull
    public CouponRecipeBuilder group(@Nullable String group) {
        return this;
    }

    @Nonnull
    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(id, this.ingredient, this.result, this.advancement, id.m_246208_("recipes/ticket_machine/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
        if (this.ingredient == null) {
            throw new IllegalStateException("No ingredient defined for " + id);
        }
        if (this.result == null) {
            throw new IllegalStateException("No result defined for " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Item result;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(@Nonnull ResourceLocation id, @Nonnull Ingredient ingredient, @Nonnull Item result, @Nonnull Advancement.Builder advancement, @Nonnull ResourceLocation advancementId) {
            this.id = id;
            this.ingredient = ingredient;
            this.result = result;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(@Nonnull JsonObject json) {
            json.add("ingredient", this.ingredient.m_43942_());
            json.addProperty("result", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return ModRecipes.COUPON.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

