/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.crafting;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.conditions.ConfigCraftingCondition;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.BooleanOption;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.common.crafting.condition.LCCraftingConditions;
import io.github.lightman314.lightmanscurrency.datagen.common.crafting.builders.CouponRecipeBuilder;
import io.github.lightman314.lightmanscurrency.datagen.common.crafting.builders.MasterTicketRecipeBuilder;
import io.github.lightman314.lightmanscurrency.datagen.common.crafting.builders.MintRecipeBuilder;
import io.github.lightman314.lightmanscurrency.datagen.common.crafting.builders.TicketRecipeBuilder;
import io.github.lightman314.lightmanscurrency.datagen.common.crafting.builders.WalletUpgradeRecipeBuilder;
import io.github.lightman314.lightmanscurrency.datagen.util.ColorHelper;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class LCRecipeProvider
extends RecipeProvider {
    private static final String ADV_PREFIX = "recipes/misc/";

    public LCRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(@Nonnull Consumer<FinishedRecipe> consumer) {
        LCCraftingConditions.register();
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.TRADING_CORE.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126130_("rqr").m_126130_("rdr").m_126130_("rpr").m_206416_(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('q'), Tags.Items.GEMS_QUARTZ).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_42162_).m_126127_(Character.valueOf('p'), (ItemLike)Items.f_42351_).m_126140_(consumer, LCRecipeProvider.ItemID(ModItems.TRADING_CORE));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ATM.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126130_("igi").m_126130_("igi").m_126130_("iri").m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('g'), Tags.Items.GLASS_PANES_COLORLESS).m_206416_(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).m_126140_(consumer, LCRecipeProvider.ItemID(ModBlocks.ATM));
        LCRecipeProvider.GenerateSwapRecipes(consumer, (ItemLike)ModBlocks.ATM.get(), (ItemLike)ModItems.PORTABLE_ATM.get(), Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"money", (Object)LCRecipeProvider.MoneyKnowledge())}));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.TERMINAL.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("sgs").m_126130_("sgs").m_126130_("iei").m_126127_(Character.valueOf('e'), (ItemLike)Items.f_42545_).m_206416_(Character.valueOf('g'), Tags.Items.GLASS_COLORLESS).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('s'), Tags.Items.STONE).m_126140_(consumer, LCRecipeProvider.ItemID(ModBlocks.TERMINAL));
        LCRecipeProvider.GenerateSwapRecipes(consumer, (ItemLike)ModBlocks.TERMINAL.get(), (ItemLike)ModItems.PORTABLE_TERMINAL.get(), Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"money", (Object)LCRecipeProvider.MoneyKnowledge()), Pair.of((Object)"trader", (Object)LCRecipeProvider.TraderKnowledge())}));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.GEM_TERMINAL.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("aaa").m_126130_("aea").m_126130_("asa").m_126127_(Character.valueOf('e'), (ItemLike)Items.f_42545_).m_206416_(Character.valueOf('a'), Tags.Items.GEMS_AMETHYST).m_206416_(Character.valueOf('s'), Tags.Items.STONE).m_126140_(consumer, LCRecipeProvider.ItemID(ModBlocks.GEM_TERMINAL));
        LCRecipeProvider.GenerateSwapRecipes(consumer, (ItemLike)ModBlocks.GEM_TERMINAL.get(), (ItemLike)ModItems.PORTABLE_GEM_TERMINAL.get(), Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"money", (Object)LCRecipeProvider.MoneyKnowledge()), Pair.of((Object)"trader", (Object)LCRecipeProvider.TraderKnowledge())}));
        LCRecipeProvider.GenerateWalletRecipes(consumer, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER), ModItems.WALLET_COPPER), Pair.of((Object)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON), ModItems.WALLET_IRON), Pair.of((Object)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD), ModItems.WALLET_GOLD), Pair.of((Object)Ingredient.m_204132_((TagKey)Tags.Items.GEMS_EMERALD), ModItems.WALLET_EMERALD), Pair.of((Object)Ingredient.m_204132_((TagKey)Tags.Items.GEMS_DIAMOND), ModItems.WALLET_DIAMOND), Pair.of((Object)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_NETHERITE), ModItems.WALLET_NETHERITE), Pair.of((Object)Ingredient.m_204132_((TagKey)Tags.Items.NETHER_STARS), ModItems.WALLET_NETHER_STAR)}));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.WALLET_LEATHER.get())).m_126145_("wallet_crafting").m_126132_("coin", LCRecipeProvider.MoneyKnowledge()).m_126132_("wallet", LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).m_206419_(Tags.Items.LEATHER).m_206419_(Tags.Items.STRING).m_206419_(Tags.Items.LEATHER).m_126140_(consumer, LCRecipeProvider.ItemID("wallet/", ModItems.WALLET_LEATHER));
        WalletUpgradeRecipeBuilder.shapeless(RecipeCategory.MISC, (ItemLike)ModItems.WALLET_IRON.get()).group("wallet_crafting").unlockedBy("coin", LCRecipeProvider.MoneyKnowledge()).unlockedBy("wallet", LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).requires((ItemLike)ModItems.WALLET_LEATHER.get()).requires((TagKey<Item>)Tags.Items.INGOTS_IRON).m_126140_(consumer, LCRecipeProvider.ItemID("wallet/upgrade_leather_wallet_to", ModItems.WALLET_IRON));
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_COPPER, ModBlocks.COINPILE_COPPER, ModBlocks.COINBLOCK_COPPER);
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_IRON, ModBlocks.COINPILE_IRON, ModBlocks.COINBLOCK_IRON);
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_GOLD, ModBlocks.COINPILE_GOLD, ModBlocks.COINBLOCK_GOLD);
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_EMERALD, ModBlocks.COINPILE_EMERALD, ModBlocks.COINBLOCK_EMERALD);
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_DIAMOND, ModBlocks.COINPILE_DIAMOND, ModBlocks.COINBLOCK_DIAMOND);
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_NETHERITE, ModBlocks.COINPILE_NETHERITE, ModBlocks.COINBLOCK_NETHERITE);
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_CHOCOLATE_COPPER, ModBlocks.COINPILE_CHOCOLATE_COPPER, ModBlocks.COINBLOCK_CHOCOLATE_COPPER, "chocolate_", LCRecipeProvider.LazyTrigger(LCTags.Items.EVENT_COIN_CHOCOLATE));
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_CHOCOLATE_IRON, ModBlocks.COINPILE_CHOCOLATE_IRON, ModBlocks.COINBLOCK_CHOCOLATE_IRON, "chocolate_", LCRecipeProvider.LazyTrigger(LCTags.Items.EVENT_COIN_CHOCOLATE));
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_CHOCOLATE_GOLD, ModBlocks.COINPILE_CHOCOLATE_GOLD, ModBlocks.COINBLOCK_CHOCOLATE_GOLD, "chocolate_", LCRecipeProvider.LazyTrigger(LCTags.Items.EVENT_COIN_CHOCOLATE));
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_CHOCOLATE_EMERALD, ModBlocks.COINPILE_CHOCOLATE_EMERALD, ModBlocks.COINBLOCK_CHOCOLATE_EMERALD, "chocolate_", LCRecipeProvider.LazyTrigger(LCTags.Items.EVENT_COIN_CHOCOLATE));
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_CHOCOLATE_DIAMOND, ModBlocks.COINPILE_CHOCOLATE_DIAMOND, ModBlocks.COINBLOCK_CHOCOLATE_DIAMOND, "chocolate_", LCRecipeProvider.LazyTrigger(LCTags.Items.EVENT_COIN_CHOCOLATE));
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, ModItems.COIN_CHOCOLATE_NETHERITE, ModBlocks.COINPILE_CHOCOLATE_NETHERITE, ModBlocks.COINBLOCK_CHOCOLATE_NETHERITE, "chocolate_", LCRecipeProvider.LazyTrigger(LCTags.Items.EVENT_COIN_CHOCOLATE));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.COIN_MINT.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("material", LCRecipeProvider.LazyTrigger(LCTags.Items.COIN_MINTING_MATERIAL)).m_126130_("ipi").m_126130_("i i").m_126130_("sss").m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('p'), (ItemLike)Items.f_41869_).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_41994_).m_176498_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ItemID(ModBlocks.COIN_MINT), ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinMint)));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.TICKET_STATION.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("ticket_trader", LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_KIOSK)).m_126132_("ticket", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).m_126132_("ticket_material", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).m_126130_("igi").m_126130_("igi").m_126130_("rrr").m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('g'), (ItemLike)Items.f_42532_).m_206416_(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).m_126140_(consumer, LCRecipeProvider.ID("ticket_station"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.CASH_REGISTER.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("iii").m_126130_("ede").m_126130_("iii").m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('e'), Tags.Items.ENDER_PEARLS).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_42162_).m_126140_(consumer, LCRecipeProvider.ItemID(ModBlocks.CASH_REGISTER));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.COIN_CHEST.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126130_("ppp").m_126130_("prp").m_126130_("ppp").m_206416_(Character.valueOf('p'), ItemTags.f_13168_).m_126127_(Character.valueOf('r'), (ItemLike)Items.f_42351_).m_176498_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ItemID(ModBlocks.COIN_CHEST), ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChest)));
        ModBlocks.DISPLAY_CASE.forEach((color, display) -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)display.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126145_("display_case").m_126130_("g").m_126130_("x").m_126130_("w").m_126127_(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).m_206416_(Character.valueOf('g'), Tags.Items.GLASS_COLORLESS).m_126127_(Character.valueOf('w'), (ItemLike)ColorHelper.GetWoolOfColor(color)).m_126140_(consumer, LCRecipeProvider.ID("traders/display_case/" + color.getResourceSafeName())));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.VENDING_MACHINE.get(Color.WHITE))).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("igi").m_126130_("igi").m_126130_("cxc").m_126127_(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).m_206416_(Character.valueOf('g'), Tags.Items.GLASS_COLORLESS).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).m_126140_(consumer, LCRecipeProvider.ItemID("traders/", (ItemLike)ModBlocks.VENDING_MACHINE.get(Color.WHITE)));
        LCRecipeProvider.GenerateColoredDyeAndWashRecipes(consumer, ModBlocks.VENDING_MACHINE, (ItemLike)ModBlocks.VENDING_MACHINE.get(Color.WHITE), "vending_machine_dyes", "traders/vending_machine/", Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"money", (Object)LCRecipeProvider.MoneyKnowledge()), Pair.of((Object)"trader", (Object)LCRecipeProvider.TraderKnowledge())}));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Color.WHITE))).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126132_("vending_machine", LCRecipeProvider.LazyTrigger((ItemLike)ModBlocks.VENDING_MACHINE.get(Color.WHITE))).m_126130_("igi").m_126130_("igi").m_126130_("cxc").m_126127_(Character.valueOf('x'), (ItemLike)ModBlocks.VENDING_MACHINE.get(Color.WHITE)).m_206416_(Character.valueOf('g'), Tags.Items.GLASS_COLORLESS).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).m_126140_(consumer, LCRecipeProvider.ItemID("traders/", (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Color.WHITE)));
        LCRecipeProvider.GenerateColoredDyeAndWashRecipes(consumer, ModBlocks.VENDING_MACHINE_LARGE, (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Color.WHITE), "vending_machine_large_dyes", "traders/large_vending_machine/", Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"money", (Object)LCRecipeProvider.MoneyKnowledge()), Pair.of((Object)"trader", (Object)LCRecipeProvider.TraderKnowledge())}));
        ModBlocks.SHELF.forEach((woodType, shelf) -> {
            WoodData data;
            Item slab;
            ArrayList<ICondition> conditions = new ArrayList<ICondition>();
            if (woodType.isModded()) {
                conditions.add((ICondition)new ModLoadedCondition(woodType.getModID()));
            }
            Item item = slab = (data = woodType.getData()) == null ? null : data.getSlab();
            if (slab != null) {
                ResourceLocation id = LCRecipeProvider.WoodID("traders/shelf/", woodType);
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)shelf.get())).m_126145_("shelf_trader").m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("x").m_126130_("s").m_126127_(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).m_126127_(Character.valueOf('s'), (ItemLike)slab).m_126140_(LCRecipeProvider.lazyConditional(consumer, id, conditions), id);
            } else {
                LightmansCurrency.LogDebug("Could not generate shelf recipe for WoodType '" + woodType.id + "' as it has no defined slab item.");
            }
        });
        ModBlocks.SHELF_2x2.forEach((woodType, shelf) -> {
            WoodData data;
            ArrayList<ICondition> conditions = new ArrayList<ICondition>();
            if (woodType.isModded()) {
                conditions.add((ICondition)new ModLoadedCondition(woodType.getModID()));
            }
            Item slab = (data = woodType.getData()) == null ? null : data.getSlab();
            ItemLike trader = (ItemLike)ModBlocks.SHELF.get((WoodType)woodType);
            if (slab != null && trader != null) {
                ResourceLocation id = LCRecipeProvider.WoodID("traders/shelf2/", woodType);
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)shelf.get())).m_126145_("shelf_trader_2x2").m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126132_("shelf", LCRecipeProvider.LazyTrigger(trader)).m_126130_("c").m_126130_("x").m_126130_("s").m_206416_(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).m_126127_(Character.valueOf('x'), trader).m_126127_(Character.valueOf('s'), (ItemLike)slab).m_126140_(LCRecipeProvider.lazyConditional(consumer, id, conditions), id);
            } else {
                LightmansCurrency.LogDebug("Could not generate 2x2 shelf recipe for WoodType '" + woodType.id + "' as it has no defined slab item.");
            }
        });
        ModBlocks.CARD_DISPLAY.forEach((woodType, color, card_display) -> {
            WoodData data;
            Item log;
            ArrayList<ICondition> conditions = new ArrayList<ICondition>();
            if (woodType.isModded()) {
                conditions.add((ICondition)new ModLoadedCondition(woodType.getModID()));
            }
            Item item = log = (data = woodType.getData()) == null ? null : data.getLog();
            if (log != null) {
                ResourceLocation id = LCRecipeProvider.ColoredWoodID("traders/card_display/", woodType, color);
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)card_display.get())).m_126145_("card_display_trader_" + woodType.id).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("  w").m_126130_(" xl").m_126130_("llc").m_126127_(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).m_126127_(Character.valueOf('l'), (ItemLike)log).m_126127_(Character.valueOf('w'), (ItemLike)ColorHelper.GetWoolOfColor(color)).m_206416_(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).m_126140_(LCRecipeProvider.lazyConditional(consumer, id, conditions), id);
            } else {
                LightmansCurrency.LogDebug("Could not generate card display recipe for WoodType '" + woodType.id + "' as it has no defined log item.");
            }
        });
        for (Color c : Color.values()) {
            Item cp = ColorHelper.GetConcretePowderOfColor(c);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.FREEZER.get(c))).m_126145_("freezer_crafting").m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("igi").m_126130_("igi").m_126130_("cxc").m_126127_(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).m_206416_(Character.valueOf('g'), Tags.Items.GLASS_COLORLESS).m_126127_(Character.valueOf('i'), (ItemLike)cp).m_206416_(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).m_126140_(consumer, LCRecipeProvider.ID("traders/freezer/" + c.getResourceSafeName()));
        }
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ITEM_NETWORK_TRADER_1.get())).m_126145_("item_network_trader").m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126132_("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).m_126130_("ici").m_126130_("ixi").m_126130_("iei").m_126127_(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).m_126127_(Character.valueOf('e'), (ItemLike)Items.f_42545_).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).m_176498_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ID("network/item_network_trader_1"), LCCraftingConditions.NETWORK_TRADER));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ITEM_NETWORK_TRADER_2.get())).m_126145_("item_network_trader").m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126132_("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).m_126132_("previous", LCRecipeProvider.LazyTrigger(ModBlocks.ITEM_NETWORK_TRADER_1)).m_126130_("c").m_126130_("x").m_126130_("i").m_126127_(Character.valueOf('x'), (ItemLike)ModBlocks.ITEM_NETWORK_TRADER_1.get()).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).m_176498_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ID("network/item_network_trader_2"), LCCraftingConditions.NETWORK_TRADER));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ITEM_NETWORK_TRADER_3.get())).m_126145_("item_network_trader").m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126132_("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).m_126132_("previous", LCRecipeProvider.LazyTrigger(ModBlocks.ITEM_NETWORK_TRADER_2)).m_126130_("c").m_126130_("x").m_126130_("i").m_126127_(Character.valueOf('x'), (ItemLike)ModBlocks.ITEM_NETWORK_TRADER_2.get()).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).m_176498_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ID("network/item_network_trader_3"), LCCraftingConditions.NETWORK_TRADER));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ITEM_NETWORK_TRADER_4.get())).m_126145_("item_network_trader").m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126132_("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).m_126132_("previous", LCRecipeProvider.LazyTrigger(ModBlocks.ITEM_NETWORK_TRADER_3)).m_126130_("c").m_126130_("x").m_126130_("i").m_126127_(Character.valueOf('x'), (ItemLike)ModBlocks.ITEM_NETWORK_TRADER_3.get()).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).m_176498_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ID("network/item_network_trader_4"), LCCraftingConditions.NETWORK_TRADER));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ARMOR_DISPLAY.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("ggg").m_126130_("gag").m_126130_("ixi").m_126127_(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).m_206416_(Character.valueOf('g'), Tags.Items.GLASS_COLORLESS).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42650_).m_126140_(consumer, LCRecipeProvider.ItemID("traders/", ModBlocks.ARMOR_DISPLAY));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.TICKET_KIOSK.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("iii").m_126130_("igi").m_126130_("rxr").m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('g'), (ItemLike)Items.f_42532_).m_206416_(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).m_126140_(consumer, LCRecipeProvider.ItemID("traders/", ModBlocks.TICKET_KIOSK));
        ModBlocks.BOOKSHELF_TRADER.forEach((woodType, bookshelf) -> {
            Item slab;
            WoodData data;
            ArrayList<ICondition> conditions = new ArrayList<ICondition>();
            if (woodType.isModded()) {
                conditions.add((ICondition)new ModLoadedCondition(woodType.getModID()));
            }
            Item plank = (data = woodType.getData()) == null ? null : data.getPlank();
            Item item = slab = data == null ? null : data.getSlab();
            if (plank != null && slab != null) {
                ResourceLocation id = LCRecipeProvider.WoodID("traders/bookshelf/", woodType);
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)bookshelf.get())).m_126145_("bookshelf_trader").m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("ppp").m_126130_("sxs").m_126130_("ppp").m_126127_(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).m_126127_(Character.valueOf('p'), (ItemLike)plank).m_126127_(Character.valueOf('s'), (ItemLike)slab).m_126140_(LCRecipeProvider.lazyConditional(consumer, id, conditions), id);
            } else {
                LightmansCurrency.LogDebug("Could not generate bookshelf recipe for WoodType '" + woodType.id + "' as it has no defined plank and/or slab item.");
            }
        });
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.SLOT_MACHINE.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("igi").m_126130_("idi").m_126130_("rxr").m_126127_(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).m_206416_(Character.valueOf('g'), Tags.Items.GLASS_COLORLESS).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('r'), (ItemLike)Items.f_42351_).m_206416_(Character.valueOf('d'), Tags.Items.DUSTS_GLOWSTONE).m_126140_(consumer, LCRecipeProvider.ItemID("traders/", ModBlocks.SLOT_MACHINE));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.PAYGATE.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126132_("ticket", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).m_126132_("ticket_material", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).m_126130_("iri").m_126130_("ixi").m_126130_("iti").m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('t'), (ItemLike)Items.f_41978_).m_126127_(Character.valueOf('r'), (ItemLike)Items.f_42153_).m_126127_(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).m_126140_(consumer, LCRecipeProvider.ItemID("traders/", ModBlocks.PAYGATE));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ITEM_TRADER_INTERFACE.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126132_("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).m_126130_("ici").m_126130_("iti").m_126130_("ici").m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('t'), LCTags.Items.NETWORK_TERMINAL).m_206416_(Character.valueOf('c'), Tags.Items.CHESTS_WOODEN).m_176498_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ItemID(ModBlocks.ITEM_TRADER_INTERFACE), LCCraftingConditions.TRADER_INTERFACE));
        ModBlocks.AUCTION_STAND.forEach((woodType, auction_stand) -> {
            WoodData data;
            Item log;
            ArrayList conditions = Lists.newArrayList((Object[])new ICondition[]{ConfigCraftingCondition.of(LCConfig.COMMON.canCraftAuctionStands)});
            if (woodType.isModded()) {
                conditions.add(new ModLoadedCondition(woodType.getModID()));
            }
            Item item = log = (data = woodType.getData()) == null ? null : data.getLog();
            if (log != null) {
                ResourceLocation id = LCRecipeProvider.WoodID("auction_stand/", woodType);
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)auction_stand.get())).m_126145_("auction_stand").m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126132_("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).m_126130_("g").m_126130_("x").m_126130_("l").m_126127_(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).m_206416_(Character.valueOf('g'), Tags.Items.GLASS_COLORLESS).m_126127_(Character.valueOf('l'), (ItemLike)log).m_126140_(LCRecipeProvider.lazyConditional(consumer, id, conditions), id);
            } else {
                LightmansCurrency.LogDebug("Could not generate auction stand recipe for WoodType '" + woodType.id + "' as it has no defined log item.");
            }
        });
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.PIGGY_BANK.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("wallet", LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).m_126130_("b  ").m_126130_("bbb").m_126130_("bdb").m_206416_(Character.valueOf('b'), Tags.Items.INGOTS_BRICK).m_206416_(Character.valueOf('d'), Tags.Items.DYES_PINK).m_126140_(consumer, LCRecipeProvider.ItemID("coin_jar/", ModBlocks.PIGGY_BANK));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.COINJAR_BLUE.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("wallet", LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).m_126130_("b b").m_126130_("bdb").m_126130_(" b ").m_206416_(Character.valueOf('b'), Tags.Items.INGOTS_BRICK).m_206416_(Character.valueOf('d'), Tags.Items.DYES_BLUE).m_126140_(consumer, LCRecipeProvider.ID("coin_jar/blue"));
        LCRecipeProvider.GenerateMintAndMeltRecipes(consumer, ModItems.COIN_COPPER, (TagKey<Item>)Tags.Items.INGOTS_COPPER, (ItemLike)Items.f_151052_, LCConfig.COMMON.coinMintMintableCopper, LCConfig.COMMON.coinMintMeltableCopper);
        LCRecipeProvider.GenerateMintAndMeltRecipes(consumer, ModItems.COIN_IRON, (TagKey<Item>)Tags.Items.INGOTS_IRON, (ItemLike)Items.f_42416_, LCConfig.COMMON.coinMintMintableIron, LCConfig.COMMON.coinMintMeltableIron);
        LCRecipeProvider.GenerateMintAndMeltRecipes(consumer, ModItems.COIN_GOLD, (TagKey<Item>)Tags.Items.INGOTS_GOLD, (ItemLike)Items.f_42417_, LCConfig.COMMON.coinMintMintableGold, LCConfig.COMMON.coinMintMeltableGold);
        LCRecipeProvider.GenerateMintAndMeltRecipes(consumer, ModItems.COIN_EMERALD, (TagKey<Item>)Tags.Items.GEMS_EMERALD, (ItemLike)Items.f_42616_, LCConfig.COMMON.coinMintMintableEmerald, LCConfig.COMMON.coinMintMeltableEmerald);
        LCRecipeProvider.GenerateMintAndMeltRecipes(consumer, ModItems.COIN_DIAMOND, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, (ItemLike)Items.f_42415_, LCConfig.COMMON.coinMintMintableDiamond, LCConfig.COMMON.coinMintMeltableDiamond);
        LCRecipeProvider.GenerateMintAndMeltRecipes(consumer, ModItems.COIN_NETHERITE, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE, (ItemLike)Items.f_42418_, LCConfig.COMMON.coinMintMintableNetherite, LCConfig.COMMON.coinMintMeltableNetherite);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("nnn").m_126130_("ncn").m_126130_("nnn").m_126127_(Character.valueOf('c'), (ItemLike)ModItems.TRADING_CORE.get()).m_206416_(Character.valueOf('n'), Tags.Items.NUGGETS_IRON).m_126140_(consumer, LCRecipeProvider.ID("upgrades/create_template"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get()), (int)2).m_126145_("lightmans_template_copy").m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126132_("template", LCRecipeProvider.LazyTrigger((ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get())).m_126130_("nnn").m_126130_("ntn").m_126130_("nnn").m_126127_(Character.valueOf('t'), (ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get()).m_206416_(Character.valueOf('n'), Tags.Items.NUGGETS_IRON).m_126140_(consumer, LCRecipeProvider.ID("upgrades/copy_template"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get()), (int)10).m_126145_("lightmans_template_copy").m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126132_("template", LCRecipeProvider.LazyTrigger((ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get())).m_126130_("iii").m_126130_("iti").m_126130_("iii").m_126127_(Character.valueOf('t'), (ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get()).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_126140_(consumer, LCRecipeProvider.ID("upgrades/copy_template_bulk"));
        Ingredient TEMPLATE = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get()});
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.CHESTS_WOODEN), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.ITEM_CAPACITY_UPGRADE_1.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader", LCRecipeProvider.TraderKnowledge()).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.ITEM_CAPACITY_UPGRADE_1));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ITEM_CAPACITY_UPGRADE_1.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.ITEM_CAPACITY_UPGRADE_2.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader", LCRecipeProvider.TraderKnowledge()).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.ITEM_CAPACITY_UPGRADE_1)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.ITEM_CAPACITY_UPGRADE_2));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ITEM_CAPACITY_UPGRADE_2.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.GEMS_DIAMOND), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.ITEM_CAPACITY_UPGRADE_3.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader", LCRecipeProvider.TraderKnowledge()).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.ITEM_CAPACITY_UPGRADE_2)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.ITEM_CAPACITY_UPGRADE_3));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ITEM_CAPACITY_UPGRADE_3.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.ITEM_CAPACITY_UPGRADE_4.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader", LCRecipeProvider.TraderKnowledge()).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.ITEM_CAPACITY_UPGRADE_3)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.ITEM_CAPACITY_UPGRADE_4));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42545_}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.NETWORK_UPGRADE.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader", LCRecipeProvider.TraderKnowledge()).m_266439_("terminal", LCRecipeProvider.TerminalKnowledge()).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.NETWORK_UPGRADE));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42155_}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.HOPPER_UPGRADE.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.HOPPER_UPGRADE));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42524_}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.SPEED_UPGRADE_1.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).m_266439_("coin_mint", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_MINT)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.SPEED_UPGRADE_1));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SPEED_UPGRADE_1.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.SPEED_UPGRADE_2.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).m_266439_("coin_mint", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_MINT)).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.SPEED_UPGRADE_1)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.SPEED_UPGRADE_2));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SPEED_UPGRADE_2.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.GEMS_EMERALD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.SPEED_UPGRADE_3.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).m_266439_("coin_mint", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_MINT)).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.SPEED_UPGRADE_2)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.SPEED_UPGRADE_3));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SPEED_UPGRADE_3.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.GEMS_DIAMOND), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.SPEED_UPGRADE_4.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).m_266439_("coin_mint", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_MINT)).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.SPEED_UPGRADE_3)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.SPEED_UPGRADE_4));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SPEED_UPGRADE_4.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.SPEED_UPGRADE_5.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).m_266439_("coin_mint", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_MINT)).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.SPEED_UPGRADE_4)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.SPEED_UPGRADE_5));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_204132_(LCTags.Items.ATM), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.COIN_CHEST_EXCHANGE_UPGRADE.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("coin_chest", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_CHEST)).m_266260_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.COIN_CHEST_EXCHANGE_UPGRADE), ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChestUpgradeExchange)), "null:null");
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.ENDER_PEARLS), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.COIN_CHEST_MAGNET_UPGRADE_1.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("coin_chest", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_CHEST)).m_266260_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.COIN_CHEST_MAGNET_UPGRADE_1), ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChestUpgradeMagnet)), "null:null");
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COIN_CHEST_MAGNET_UPGRADE_1.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.COIN_CHEST_MAGNET_UPGRADE_2.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("coin_chest", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_CHEST)).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.COIN_CHEST_MAGNET_UPGRADE_1)).m_266260_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.COIN_CHEST_MAGNET_UPGRADE_2), ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChestUpgradeMagnet)), "null:null");
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COIN_CHEST_MAGNET_UPGRADE_2.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.COIN_CHEST_MAGNET_UPGRADE_3.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("coin_chest", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_CHEST)).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.COIN_CHEST_MAGNET_UPGRADE_2)).m_266260_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.COIN_CHEST_MAGNET_UPGRADE_3), ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChestUpgradeMagnet)), "null:null");
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COIN_CHEST_MAGNET_UPGRADE_3.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.GEMS_EMERALD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.COIN_CHEST_MAGNET_UPGRADE_4.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("coin_chest", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_CHEST)).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.COIN_CHEST_MAGNET_UPGRADE_3)).m_266260_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.COIN_CHEST_MAGNET_UPGRADE_4), ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChestUpgradeMagnet)), "null:null");
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41999_}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.GEMS_DIAMOND), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.COIN_CHEST_SECURITY_UPGRADE.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("coin_chest", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_CHEST)).m_266260_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.COIN_CHEST_SECURITY_UPGRADE), ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChestUpgradeSecurity)), "null:null");
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SUS_JAR.get())).m_206419_(LCTags.Items.COIN_JAR_NORMAL).m_126209_((ItemLike)Items.f_42718_).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("jar", LCRecipeProvider.LazyTrigger(LCTags.Items.COIN_JAR_ALL)).m_126140_(consumer, LCRecipeProvider.ItemID("coin_jar/", ModBlocks.SUS_JAR));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.TAX_COLLECTOR.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("ghg").m_126130_("nxn").m_126130_("geg").m_206416_(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('n'), Tags.Items.INGOTS_NETHERITE).m_126127_(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).m_126127_(Character.valueOf('h'), (ItemLike)Items.f_42155_).m_206416_(Character.valueOf('e'), Tags.Items.ENDER_PEARLS).m_176498_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ItemID(ModBlocks.TAX_COLLECTOR), ConfigCraftingCondition.of(LCConfig.COMMON.canCraftTaxBlock)));
        MasterTicketRecipeBuilder.of(LCTags.Items.TICKET_MATERIAL_PAPER).withResult(ModItems.TICKET_MASTER).unlockedBy("ticket_station", LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_STATION)).unlockedBy("tickets", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).m_126140_(consumer, LCRecipeProvider.ItemID("ticket_station/", ModItems.TICKET_MASTER));
        TicketRecipeBuilder.of(LCTags.Items.TICKET_MATERIAL_PAPER, (ItemLike)ModItems.TICKET.get()).withMasterTicket((ItemLike)ModItems.TICKET_MASTER.get()).unlockedBy("ticket_station", LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_STATION)).unlockedBy("tickets", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).m_126140_(consumer, LCRecipeProvider.ItemID("ticket_station/", ModItems.TICKET));
        TicketRecipeBuilder.of(LCTags.Items.TICKET_MATERIAL_PAPER, (ItemLike)ModItems.TICKET_PASS.get()).withMasterTicket((ItemLike)ModItems.TICKET_MASTER.get()).unlockedBy("ticket_station", LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_STATION)).unlockedBy("tickets", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).m_126140_(consumer, LCRecipeProvider.ItemID("ticket_station/", ModItems.TICKET_PASS));
        MasterTicketRecipeBuilder.of(LCTags.Items.TICKET_MATERIAL_GOLD).withResult(ModItems.GOLDEN_TICKET_MASTER).unlockedBy("ticket_station", LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_STATION)).unlockedBy("tickets", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).m_126140_(consumer, LCRecipeProvider.ItemID("ticket_station/", ModItems.GOLDEN_TICKET_MASTER));
        TicketRecipeBuilder.of(LCTags.Items.TICKET_MATERIAL_GOLD, (ItemLike)ModItems.GOLDEN_TICKET.get()).withMasterTicket((ItemLike)ModItems.GOLDEN_TICKET_MASTER.get()).unlockedBy("ticket_station", LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_STATION)).unlockedBy("tickets", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).m_126140_(consumer, LCRecipeProvider.ItemID("ticket_station/", ModItems.GOLDEN_TICKET));
        TicketRecipeBuilder.of(LCTags.Items.TICKET_MATERIAL_GOLD, (ItemLike)ModItems.GOLDEN_TICKET_PASS.get()).withMasterTicket((ItemLike)ModItems.GOLDEN_TICKET_MASTER.get()).unlockedBy("ticket_station", LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_STATION)).unlockedBy("tickets", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).m_126140_(consumer, LCRecipeProvider.ItemID("ticket_station/", ModItems.GOLDEN_TICKET_PASS));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TRADING_CORE.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.OFFER_UPGRADE_1.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader", LCRecipeProvider.TraderKnowledge()).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.OFFER_UPGRADE_1));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.OFFER_UPGRADE_1.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.OFFER_UPGRADE_2.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader", LCRecipeProvider.TraderKnowledge()).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.OFFER_UPGRADE_1)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.OFFER_UPGRADE_2));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.OFFER_UPGRADE_2.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.OFFER_UPGRADE_3.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader", LCRecipeProvider.TraderKnowledge()).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.OFFER_UPGRADE_2)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.OFFER_UPGRADE_3));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.OFFER_UPGRADE_3.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.GEMS_EMERALD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.OFFER_UPGRADE_4.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader", LCRecipeProvider.TraderKnowledge()).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.OFFER_UPGRADE_3)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.OFFER_UPGRADE_4));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.OFFER_UPGRADE_4.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.GEMS_DIAMOND), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.OFFER_UPGRADE_5.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader", LCRecipeProvider.TraderKnowledge()).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.OFFER_UPGRADE_4)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.OFFER_UPGRADE_5));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.OFFER_UPGRADE_5.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.OFFER_UPGRADE_6.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("trader", LCRecipeProvider.TraderKnowledge()).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.OFFER_UPGRADE_5)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.OFFER_UPGRADE_6));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_204132_(LCTags.Items.ATM), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.GEMS_DIAMOND), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.COIN_CHEST_BANK_UPGRADE.get()).m_266439_("money", LCRecipeProvider.MoneyKnowledge()).m_266439_("coin_chest", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_CHEST)).m_266439_("atm", LCRecipeProvider.LazyTrigger(LCTags.Items.ATM)).m_266260_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.COIN_CHEST_BANK_UPGRADE), ConfigCraftingCondition.of(LCConfig.COMMON.canCraftCoinChestUpgradeBank)), "null:null");
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ATM_CARD.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("atm", LCRecipeProvider.LazyTrigger(LCTags.Items.ATM)).m_126209_((ItemLike)Items.f_42516_).m_206419_(Tags.Items.ENDER_PEARLS).m_206419_(Tags.Items.NUGGETS_IRON).m_176500_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ItemID(ModItems.ATM_CARD), ConfigCraftingCondition.of(LCConfig.COMMON.canCraftATMCard)), "null:null");
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.NETWORK_UPGRADE.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.GEMS_EMERALD), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.INTERACTION_UPGRADE_1.get()).m_266439_("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).m_266439_("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).m_266439_("network_trader", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_NETWORK)).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.NETWORK_UPGRADE)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.INTERACTION_UPGRADE_1));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.INTERACTION_UPGRADE_1.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.GEMS_DIAMOND), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.INTERACTION_UPGRADE_2.get()).m_266439_("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).m_266439_("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).m_266439_("network_trader", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_NETWORK)).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.INTERACTION_UPGRADE_1)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.INTERACTION_UPGRADE_2));
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)TEMPLATE, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.INTERACTION_UPGRADE_2.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.INTERACTION_UPGRADE_3.get()).m_266439_("trader_interface", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_INTERFACE)).m_266439_("terminal", LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL)).m_266439_("network_trader", LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER_NETWORK)).m_266439_("previous", LCRecipeProvider.LazyTrigger(ModItems.INTERACTION_UPGRADE_2)).m_266371_(consumer, LCRecipeProvider.ItemID("upgrades/", ModItems.INTERACTION_UPGRADE_3));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.GACHA_MACHINE.get(Color.WHITE))).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("ggg").m_126130_("gxg").m_126130_("iii").m_126127_(Character.valueOf('x'), (ItemLike)ModItems.TRADING_CORE.get()).m_206416_(Character.valueOf('g'), Tags.Items.GLASS_COLORLESS).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_126140_(consumer, LCRecipeProvider.ID("traders/gacha_machine"));
        LCRecipeProvider.GenerateColoredDyeAndWashRecipes(consumer, ModBlocks.GACHA_MACHINE, (ItemLike)ModBlocks.GACHA_MACHINE.get(Color.WHITE), "gacha_dyes", "traders/gacha_machine/", Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"money", (Object)LCRecipeProvider.MoneyKnowledge()), Pair.of((Object)"trader", (Object)LCRecipeProvider.TraderKnowledge())}));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.MONEY_BAG.get())).m_126132_("money", LCRecipeProvider.MoneyKnowledge()).m_126132_("wallet", LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).m_126130_(" s ").m_126130_("lgl").m_126130_("lll").m_206416_(Character.valueOf('s'), Tags.Items.STRING).m_206416_(Character.valueOf('l'), Tags.Items.LEATHER).m_206416_(Character.valueOf('g'), Tags.Items.NUGGETS_GOLD).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.VARIANT_WAND.get())).m_126132_("trader", LCRecipeProvider.TraderKnowledge()).m_126130_("i i").m_126130_("ntn").m_126130_(" s ").m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('n'), Tags.Items.NUGGETS_IRON).m_126127_(Character.valueOf('t'), (ItemLike)ModItems.UPGRADE_SMITHING_TEMPLATE.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42398_).m_176498_(consumer);
        CouponRecipeBuilder.of(LCTags.Items.TICKET_MATERIAL_PAPER).unlockedBy("ticket_station", LCRecipeProvider.LazyTrigger(ModBlocks.TICKET_STATION)).unlockedBy("tickets", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKETS)).unlockedBy("ticket_material", LCRecipeProvider.LazyTrigger(LCTags.Items.TICKET_MATERIAL)).withResult(ModItems.COUPON).m_126140_(consumer, LCRecipeProvider.ItemID("ticket_station/", ModItems.COUPON));
    }

    protected static void GenerateWalletRecipes(@Nonnull Consumer<FinishedRecipe> consumer, List<Pair<Ingredient, Supplier<? extends ItemLike>>> ingredientWalletPairs) {
        int w;
        Ingredient leather = Ingredient.m_204132_((TagKey)Tags.Items.LEATHER);
        List<Ingredient> ingredients = ingredientWalletPairs.stream().map(Pair::getFirst).toList();
        List<ItemLike> wallets = ingredientWalletPairs.stream().map(p -> (ItemLike)((Supplier)p.getSecond()).get()).toList();
        for (w = 0; w < wallets.size(); ++w) {
            ItemLike wallet = wallets.get(w);
            ShapelessRecipeBuilder b = ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)wallets.get(w)).m_126145_("wallet_crafting").m_126132_("coin", LCRecipeProvider.MoneyKnowledge()).m_126132_("wallet", LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).m_126184_(leather);
            for (int i = 0; i < ingredients.size() && i <= w; ++i) {
                b.m_126184_(ingredients.get(i));
            }
            b.m_126184_(leather);
            b.m_126140_(consumer, LCRecipeProvider.ItemID("wallet/", wallet));
        }
        for (w = 0; w < wallets.size() - 1; ++w) {
            for (int w2 = w + 1; w2 < wallets.size(); ++w2) {
                ItemLike first = wallets.get(w);
                ItemLike result = wallets.get(w2);
                WalletUpgradeRecipeBuilder b = WalletUpgradeRecipeBuilder.shapeless(RecipeCategory.MISC, result).group("wallet_upgrading").unlockedBy("coin", LCRecipeProvider.MoneyKnowledge()).unlockedBy("wallet", LCRecipeProvider.LazyTrigger(LCTags.Items.WALLET)).requires(first);
                for (int i = w + 1; i < ingredients.size() && i <= w2; ++i) {
                    b.requires(ingredients.get(i));
                }
                b.m_126140_(consumer, LCRecipeProvider.ID("wallet/upgrade_" + LCRecipeProvider.ItemPath(first) + "_to_" + LCRecipeProvider.ItemPath(result)));
            }
        }
    }

    protected static void GenerateSwapRecipes(@Nonnull Consumer<FinishedRecipe> consumer, ItemLike item1, ItemLike item2, List<Pair<String, CriterionTriggerInstance>> criteria) {
        String group = LCRecipeProvider.ItemPath(item2) + "_swap";
        LCRecipeProvider.GenerateSwapRecipe(consumer, item1, item2, group, criteria);
        LCRecipeProvider.GenerateSwapRecipe(consumer, item2, item1, group, criteria);
    }

    protected static void GenerateSwapRecipe(@Nonnull Consumer<FinishedRecipe> consumer, ItemLike item1, ItemLike item2, @Nullable String group, List<Pair<String, CriterionTriggerInstance>> criteria) {
        ShapelessRecipeBuilder b = ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)item2).m_126145_(group);
        LCRecipeProvider.ApplyCriteria(b, criteria);
        b.m_126132_("other", LCRecipeProvider.LazyTrigger(item1)).m_126209_(item1).m_126140_(consumer, LCRecipeProvider.ID(LCRecipeProvider.ItemPath(item1) + "_swap"));
    }

    protected static void GenerateCoinBlockRecipes(@Nonnull Consumer<FinishedRecipe> consumer, Supplier<? extends ItemLike> coin, Supplier<? extends ItemLike> coinPile, Supplier<? extends ItemLike> coinBlock) {
        LCRecipeProvider.GenerateCoinBlockRecipes(consumer, coin, coinPile, coinBlock, "", LCRecipeProvider.MoneyKnowledge());
    }

    protected static void GenerateCoinBlockRecipes(@Nonnull Consumer<FinishedRecipe> consumer, Supplier<? extends ItemLike> coin, Supplier<? extends ItemLike> coinPile, Supplier<? extends ItemLike> coinBlock, @Nonnull String prefix, @Nonnull CriterionTriggerInstance moneyKnowledge) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)coinPile.get()).m_126145_(prefix + "coin_pile_from_coin").m_126132_("money", moneyKnowledge).m_126132_("coin", LCRecipeProvider.LazyTrigger(coin)).m_126211_(coin.get(), 9).m_126140_(consumer, LCRecipeProvider.ID("coins/" + LCRecipeProvider.ItemPath(coinPile) + "_from_coin"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)coinBlock.get()).m_126145_(prefix + "coin_block_from_pile").m_126132_("money", moneyKnowledge).m_126132_("pile", LCRecipeProvider.LazyTrigger(coinPile)).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), coinPile.get()).m_126140_(consumer, LCRecipeProvider.ID("coins/" + LCRecipeProvider.ItemPath(coinBlock) + "_from_pile"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)coinPile.get(), (int)4).m_126145_(prefix + "coin_pile_from_block").m_126132_("money", moneyKnowledge).m_126132_("block", LCRecipeProvider.LazyTrigger(coinBlock)).m_126209_(coinBlock.get()).m_126140_(consumer, LCRecipeProvider.ID("coins/" + LCRecipeProvider.ItemPath(coinPile) + "_from_block"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)coin.get(), (int)9).m_126145_(prefix + "coin_from_pile").m_126132_("money", moneyKnowledge).m_126132_("pile", LCRecipeProvider.LazyTrigger(coinPile)).m_126209_(coinPile.get()).m_126140_(consumer, LCRecipeProvider.ID("coins/" + LCRecipeProvider.ItemPath(coin) + "_from_pile"));
    }

    protected static void GenerateColoredDyeAndWashRecipes(@Nonnull Consumer<FinishedRecipe> consumer, RegistryObjectBundle<? extends ItemLike, Color> bundle, ItemLike cleanItem, @Nullable String dyeGroup, String prefix, List<Pair<String, CriterionTriggerInstance>> criteria) {
        ArrayList<ItemLike> coloredSet = new ArrayList<ItemLike>();
        for (Color color : Color.values()) {
            ItemLike result = bundle.get(color);
            if (result.m_5456_() == cleanItem.m_5456_()) continue;
            coloredSet.add(result);
            ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).m_126145_(dyeGroup).m_126132_("cleanitem", LCRecipeProvider.LazyTrigger(cleanItem)).m_126209_(cleanItem).m_206419_(color.dyeTag);
            LCRecipeProvider.ApplyCriteria(builder, criteria);
            builder.m_126140_(consumer, LCRecipeProvider.ID(prefix + "dye_" + color.getResourceSafeName()));
        }
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)cleanItem);
        LCRecipeProvider.ApplyCriteria(builder, criteria);
        builder.m_126132_("colored", LCRecipeProvider.LazyTrigger(coloredSet)).m_126184_(Ingredient.m_43921_(coloredSet.stream().map(ItemStack::new))).m_126209_((ItemLike)Items.f_42447_).m_126140_(consumer, LCRecipeProvider.ID(prefix + "washing"));
    }

    protected static void GenerateMintAndMeltRecipes(@Nonnull Consumer<FinishedRecipe> consumer, Supplier<? extends ItemLike> coin, TagKey<Item> materialTag, ItemLike materialItem) {
        LCRecipeProvider.GenerateMintAndMeltRecipes(consumer, coin, materialTag, materialItem, null, null);
    }

    protected static void GenerateMintAndMeltRecipes(@Nonnull Consumer<FinishedRecipe> consumer, Supplier<? extends ItemLike> coin, TagKey<Item> materialTag, ItemLike materialItem, @Nullable BooleanOption mintConfig, @Nullable BooleanOption meltConfig) {
        MintRecipeBuilder.create(materialTag, coin.get()).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("coin_mint", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_MINT)).m_126140_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ItemID("coin_mint/mint_", coin), ConfigCraftingCondition.of(LCConfig.COMMON.coinMintCanMint), mintConfig == null ? null : ConfigCraftingCondition.of(mintConfig)), LCRecipeProvider.ItemID("coin_mint/mint_", coin));
        MintRecipeBuilder.create(coin.get(), materialItem).unlockedBy("money", LCRecipeProvider.MoneyKnowledge()).unlockedBy("coin_mint", LCRecipeProvider.LazyTrigger(ModBlocks.COIN_MINT)).m_126140_(LCRecipeProvider.lazyConditional(consumer, LCRecipeProvider.ItemID("coin_mint/melt_", coin), ConfigCraftingCondition.of(LCConfig.COMMON.coinMintCanMelt), meltConfig == null ? null : ConfigCraftingCondition.of(meltConfig)), LCRecipeProvider.ItemID("coin_mint/melt_", coin));
    }

    protected static CriterionTriggerInstance MoneyKnowledge() {
        return LCRecipeProvider.LazyTrigger(LCTags.Items.COINS);
    }

    protected static CriterionTriggerInstance TraderKnowledge() {
        return LCRecipeProvider.LazyTrigger(LCTags.Items.TRADER);
    }

    protected static CriterionTriggerInstance TerminalKnowledge() {
        return LCRecipeProvider.LazyTrigger(LCTags.Items.NETWORK_TERMINAL);
    }

    protected static CriterionTriggerInstance LazyTrigger(ItemLike item) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_()});
    }

    protected static CriterionTriggerInstance LazyTrigger(List<? extends ItemLike> items) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(items.toArray(new ItemLike[0])).m_45077_()});
    }

    protected static CriterionTriggerInstance LazyTrigger(Supplier<? extends ItemLike> item) {
        return LCRecipeProvider.LazyTrigger(item.get());
    }

    protected static CriterionTriggerInstance LazyTrigger(TagKey<Item> tag) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_()});
    }

    protected static void ApplyCriteria(ShapelessRecipeBuilder builder, List<Pair<String, CriterionTriggerInstance>> criteria) {
        for (Pair<String, CriterionTriggerInstance> c : criteria) {
            builder.m_126132_((String)c.getFirst(), (CriterionTriggerInstance)c.getSecond());
        }
    }

    protected static String ItemPath(ItemLike item) {
        return ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_();
    }

    protected static String ItemPath(Supplier<? extends ItemLike> item) {
        return LCRecipeProvider.ItemPath(item.get());
    }

    protected static ResourceLocation ItemID(String prefix, ItemLike item) {
        return LCRecipeProvider.ID(prefix + LCRecipeProvider.ItemPath(item));
    }

    protected static ResourceLocation ItemID(Supplier<? extends ItemLike> item) {
        return LCRecipeProvider.ID(LCRecipeProvider.ItemPath(item));
    }

    protected static ResourceLocation ItemID(String prefix, Supplier<? extends ItemLike> item) {
        return LCRecipeProvider.ID(prefix + LCRecipeProvider.ItemPath(item));
    }

    protected static ResourceLocation WoodID(String prefix, WoodType woodType) {
        return LCRecipeProvider.ID(woodType.generateResourceLocation(prefix));
    }

    protected static ResourceLocation WoodID(String prefix, WoodType woodType, String postfix) {
        return LCRecipeProvider.ID(woodType.generateResourceLocation(prefix, postfix));
    }

    protected static ResourceLocation ColoredWoodID(String prefix, WoodType woodType, Color color) {
        return LCRecipeProvider.WoodID(prefix, woodType, "/" + color.getResourceSafeName());
    }

    protected static ResourceLocation ID(String path) {
        return VersionUtil.lcResource(path);
    }

    protected static Consumer<FinishedRecipe> lazyConditional(Consumer<FinishedRecipe> consumer, ResourceLocation recipeID, ICondition ... conditions) {
        return LCRecipeProvider.lazyConditional(consumer, recipeID, Lists.newArrayList((Object[])conditions));
    }

    protected static Consumer<FinishedRecipe> lazyConditional(Consumer<FinishedRecipe> consumer, ResourceLocation recipeID, List<ICondition> conditions) {
        return recipe -> {
            if (conditions.isEmpty()) {
                consumer.accept((FinishedRecipe)recipe);
                return;
            }
            ConditionalRecipe.Builder builder = ConditionalRecipe.builder();
            for (ICondition condition : conditions) {
                if (condition == null) continue;
                builder.addCondition(condition);
            }
            builder.addRecipe(recipe);
            builder.generateAdvancement(recipeID.m_246208_(ADV_PREFIX)).build(consumer, recipeID);
        };
    }
}

