/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.ticket;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.ticket.TicketData;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menus.TicketStationMenu;
import io.github.lightman314.lightmanscurrency.common.traders.item.ticket.TicketKioskRestriction;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TicketItemTrade
extends ItemTradeData {
    public static final ResourceLocation TYPE = VersionUtil.lcResource("ticket_kiosk");
    private final TicketKioskRestriction restriction = new TicketKioskRestriction(this);
    private final TicketSaleData ticketData1 = new TicketSaleData(0);
    private final TicketSaleData ticketData2 = new TicketSaleData(1);

    public TicketItemTrade(boolean validateRules) {
        super(TYPE, validateRules);
        super.setRestriction(this.restriction);
    }

    @Override
    public void setRestriction(ItemTradeRestriction restriction) {
    }

    @Override
    @Nonnull
    public ItemTradeRestriction getRestriction() {
        return this.restriction;
    }

    @Override
    public void setItem(ItemStack itemStack, int index) {
        super.setItem(itemStack, index);
        if (index < 2) {
            this.getTicketData(index).onSellItemChanged();
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.ticketData1.isValid() && this.ticketData2.isValid();
    }

    @Nullable
    public TicketSaleData getTicketData(int index) {
        return switch (index) {
            case 0 -> this.ticketData1;
            case 1 -> this.ticketData2;
            default -> null;
        };
    }

    @Override
    public CompoundTag getAsNBT() {
        CompoundTag tag = super.getAsNBT();
        tag.m_128365_("TicketData1", (Tag)this.ticketData1.save());
        tag.m_128365_("TicketData2", (Tag)this.ticketData2.save());
        return tag;
    }

    @Override
    public void saveAdditionalSettings(SavedSettingData.MutableNodeAccess node) {
        this.ticketData1.saveSettings(node);
        this.ticketData2.saveSettings(node);
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        if (tag.m_128441_("TicketData1")) {
            this.ticketData1.load(tag.m_128469_("TicketData1"));
        } else {
            this.updateFromOldData(this.ticketData1, 0);
        }
        if (tag.m_128441_("TicketData2")) {
            this.ticketData2.load(tag.m_128469_("TicketData2"));
        } else {
            this.updateFromOldData(this.ticketData2, 1);
        }
    }

    @Override
    public void loadAdditionalSettings(SavedSettingData.NodeAccess node) {
        this.ticketData1.loadSettings(node);
        this.ticketData2.loadSettings(node);
    }

    private void updateFromOldData(TicketSaleData data, int index) {
        TicketData group;
        ItemStack sellItem = this.getActualItem(index);
        if (TicketItem.isTicket(sellItem) && (group = TicketData.getForTicket(sellItem)) != null) {
            ItemStack masterTicket = new ItemStack((ItemLike)group.masterTicket);
            CompoundTag tag = sellItem.m_41783_();
            if (tag != null) {
                masterTicket.m_41751_(tag.m_6426_());
            }
            this.setItem(masterTicket, index);
            for (TicketStationRecipe recipe : this.ticketData1.getMatchingRecipes()) {
                if (recipe.assembleWithKiosk(masterTicket, data.code).m_41720_() != sellItem.m_41720_()) continue;
                data.recipeID = recipe.m_6423_();
                return;
            }
        }
    }

    public class TicketSaleData {
        private final int index;
        @Nullable
        ResourceLocation recipeID = null;
        String code = "";

        public TicketSaleData(int index) {
            this.index = index;
        }

        public ResourceLocation getRecipe() {
            return this.recipeID;
        }

        public void setRecipe(ResourceLocation recipe) {
            this.recipeID = recipe;
        }

        public void onSellItemChanged() {
            if (this.isPotentiallyRecipeMode() && this.tryGetRecipe() == null) {
                List<TicketStationRecipe> allRecipes = this.getMatchingRecipes();
                if (allRecipes.isEmpty()) {
                    return;
                }
                TicketStationRecipe first = allRecipes.get(0);
                this.recipeID = first == null ? null : first.m_6423_();
            }
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String couponCode) {
            if (couponCode.length() > 16) {
                couponCode = couponCode.substring(0, 16);
            }
            this.code = couponCode;
        }

        public List<TicketStationRecipe> getMatchingRecipes() {
            ItemStack sellItem = TicketItemTrade.this.getActualItem(this.index);
            Level level = LightmansCurrency.getProxy().safeGetDummyLevel();
            if (level != null) {
                ArrayList<TicketStationRecipe> list = new ArrayList<TicketStationRecipe>(TicketStationMenu.getAllRecipes(level).stream().filter(r -> r.matchesTicketKioskSellItem(sellItem)).toList());
                for (TicketStationRecipe recipe : list) {
                    if (!recipe.allowIgnoreKioskRecipe()) continue;
                    list.add(null);
                    return list;
                }
                return list;
            }
            return ImmutableList.of();
        }

        @Nullable
        public TicketStationRecipe tryGetRecipe() {
            if (this.recipeID == null || !this.isPotentiallyRecipeMode()) {
                return null;
            }
            Level level = LightmansCurrency.getProxy().safeGetDummyLevel();
            if (level != null) {
                for (TicketStationRecipe recipe : TicketStationMenu.getAllRecipes(level)) {
                    if (recipe == null || !recipe.m_6423_().equals((Object)this.recipeID)) continue;
                    if (!recipe.matchesTicketKioskSellItem(TicketItemTrade.this.getActualItem(this.index))) {
                        return null;
                    }
                    return recipe;
                }
            }
            return null;
        }

        public boolean requestingCodeInput() {
            TicketStationRecipe recipe = this.tryGetRecipe();
            return recipe != null && recipe.requiredCodeInput();
        }

        public ItemStack getCraftingResult(boolean replaceName) {
            ItemStack sellItem = TicketItemTrade.this.getActualItem(this.index);
            if (!this.isRecipeMode()) {
                return sellItem;
            }
            TicketStationRecipe recipe = this.tryGetRecipe();
            if (recipe != null) {
                String customName;
                ItemStack result = recipe.assembleWithKiosk(sellItem, this.code);
                if (result.m_41619_()) {
                    return result;
                }
                result.m_41764_(sellItem.m_41613_());
                if (replaceName && !(customName = TicketItemTrade.this.getCustomName(this.index)).isBlank()) {
                    result.m_41714_((Component)EasyText.literal(customName));
                }
                return result;
            }
            return sellItem;
        }

        public boolean isValid() {
            ItemStack sellItem = TicketItemTrade.this.getActualItem(this.index);
            TicketStationRecipe recipe = this.tryGetRecipe();
            if (recipe != null) {
                return recipe.matchesTicketKioskSellItem(sellItem) && recipe.validCode(this.code);
            }
            return sellItem.m_41619_() || InventoryUtil.ItemHasTag(sellItem, LCTags.Items.TICKET_MATERIAL);
        }

        public boolean isPotentiallyRecipeMode() {
            return !TicketItemTrade.this.isPurchase() && !this.getMatchingRecipes().isEmpty();
        }

        public boolean isRecipeMode() {
            return this.tryGetRecipe() != null;
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            if (this.recipeID != null) {
                tag.m_128359_("Recipe", this.recipeID.toString());
            }
            tag.m_128359_("Code", this.code);
            return tag;
        }

        public void saveSettings(SavedSettingData.MutableNodeAccess node) {
            String prefix = "item_" + this.index + "_ticketdata_";
            if (this.recipeID == null) {
                node.setBooleanValue(prefix + "no_recipe", true);
            } else {
                node.setStringValue(prefix + "recipe", this.recipeID.toString());
            }
            node.setStringValue(prefix + "code", this.code);
        }

        public void load(CompoundTag tag) {
            if (tag.m_128441_("Recipe")) {
                this.recipeID = VersionUtil.parseResource(tag.m_128461_("Recipe"));
            }
            this.code = tag.m_128461_("Code");
        }

        public void loadSettings(SavedSettingData.NodeAccess node) {
            String prefix = "item_" + this.index + "_ticketdata_";
            if (node.getBooleanValue(prefix + "no_recipe")) {
                this.recipeID = null;
            }
            this.recipeID = VersionUtil.parseResource(node.getStringValue(prefix + "recipe"));
            this.code = node.getStringValue(prefix + "code");
        }
    }
}

