/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.stats.StatKeys;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderType;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.permissions.PermissionOption;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.command.CommandSettingsAddon;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.addons.MiscTabAddon;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.command.CommandTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.misc.UpgradesTab;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.CommandTradeNotification;
import io.github.lightman314.lightmanscurrency.common.traders.commands.tradedata.CommandTrade;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CommandTrader
extends TraderData {
    public static final TraderType<CommandTrader> TYPE = new TraderType(VersionUtil.lcResource("commands"), CommandTrader::new);
    private int permissionLevel = 2;
    private List<CommandTrade> trades = new ArrayList<CommandTrade>();

    public int getPermissionLevel() {
        return MathUtil.clamp(this.permissionLevel, 0, (Integer)LCConfig.SERVER.commandTraderMaxPermissionLevel.get());
    }

    public void setPermissionLevel(@Nullable Player player, int newValue) {
        if (this.hasPermission(player, "editSettings")) {
            this.permissionLevel = MathUtil.clamp(newValue, 0, (Integer)LCConfig.SERVER.commandTraderMaxPermissionLevel.get());
            this.markDirty(this::savePermissionLevel);
        }
    }

    private CommandTrader() {
        super(TYPE);
    }

    public CommandTrader(Level level, BlockPos pos) {
        super(TYPE, level, pos);
        this.trades = CommandTrade.listOfSize(1, true);
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42116_);
    }

    @Override
    protected boolean allowAdditionalUpgradeType(UpgradeType type) {
        return false;
    }

    @Override
    public boolean canEditTradeCount() {
        return true;
    }

    @Override
    public int getMaxTradeCount() {
        return 100;
    }

    @Override
    public int getTradeCount() {
        return this.trades.size();
    }

    @Override
    public int getTradeStock(int tradeIndex) {
        CommandTrade trade = this.getTrade(tradeIndex);
        if (trade == null || !trade.isValid()) {
            return 0;
        }
        return 1;
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        this.savePermissionLevel(compound);
        this.saveTrades(compound);
    }

    protected void savePermissionLevel(CompoundTag compound) {
        compound.m_128405_("PermissionLevel", this.permissionLevel);
    }

    @Override
    protected void saveTrades(CompoundTag compound) {
        ListTag list = new ListTag();
        for (CommandTrade trade : new ArrayList<CommandTrade>(this.trades)) {
            list.add((Object)trade.getAsNBT());
        }
        compound.m_128365_("Trades", (Tag)list);
    }

    @Override
    protected void saveAdditionalToJson(JsonObject json) {
        json.addProperty("PermissionLevel", (Number)this.permissionLevel);
        JsonArray trades = new JsonArray();
        for (CommandTrade trade : this.trades) {
            if (!trade.isValid()) continue;
            JsonObject tradeData = new JsonObject();
            tradeData.add("Price", (JsonElement)trade.getCost().toJson());
            tradeData.addProperty("Command", trade.getCommand());
            JsonArray ruleData = TradeRule.saveRulesToJson(trade.getRules());
            if (!ruleData.isEmpty()) {
                tradeData.add("Rules", (JsonElement)ruleData);
            }
            trades.add((JsonElement)tradeData);
        }
        json.add("Trades", (JsonElement)trades);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        if (compound.m_128441_("PermissionLevel")) {
            this.permissionLevel = compound.m_128451_("PermissionLevel");
        }
        if (compound.m_128441_("Trades")) {
            this.trades = new ArrayList<CommandTrade>();
            ListTag list = compound.m_128437_("Trades", 10);
            ArrayList trades = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                this.trades.add(CommandTrade.loadData(list.m_128728_(i), !this.isPersistent()));
            }
        }
    }

    @Override
    protected void loadAdditionalFromJson(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        JsonArray trades = GsonHelper.m_13933_((JsonObject)json, (String)"Trades");
        this.trades = new ArrayList<CommandTrade>();
        for (int i = 0; i < trades.size() && this.trades.size() < 100; ++i) {
            try {
                JsonObject tradeData = GsonHelper.m_13918_((JsonElement)trades.get(i), (String)("Trades[" + i + "]"));
                CommandTrade newTrade = new CommandTrade(false);
                newTrade.setCost(MoneyValue.loadFromJson(tradeData.get("Price")));
                newTrade.setCommand(GsonHelper.m_13906_((JsonObject)tradeData, (String)"Command"));
                if (tradeData.has("Rules")) {
                    newTrade.setRules(TradeRule.Parse(GsonHelper.m_13933_((JsonObject)tradeData, (String)"Rules"), newTrade));
                }
                this.trades.add(newTrade);
                continue;
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error parsing command trade at index " + i, e);
            }
        }
        this.permissionLevel = GsonHelper.m_13824_((JsonObject)json, (String)"PermissionLevel", (int)2);
        if (this.trades.isEmpty()) {
            throw new JsonSyntaxException("Trader has no valid trades!");
        }
    }

    @Override
    protected void saveAdditionalPersistentData(CompoundTag compound) {
        ListTag tradePersistentData = new ListTag();
        boolean tradesAreRelevant = false;
        Iterator<CommandTrade> iterator = this.trades.iterator();
        while (iterator.hasNext()) {
            CompoundTag ptTag = new CompoundTag();
            CommandTrade trade = iterator.next();
            if (TradeRule.savePersistentData(ptTag, trade.getRules(), "RuleData")) {
                tradesAreRelevant = true;
            }
            tradePersistentData.add((Object)ptTag);
        }
        if (tradesAreRelevant) {
            compound.m_128365_("PersistentTradeData", (Tag)tradePersistentData);
        }
    }

    @Override
    protected void loadAdditionalPersistentData(CompoundTag compound) {
        if (compound.m_128441_("PersistentTradeData")) {
            ListTag tradePersistentData = compound.m_128437_("PersistentTradeData", 10);
            for (int i = 0; i < tradePersistentData.size() && i < this.trades.size(); ++i) {
                CommandTrade trade = this.trades.get(i);
                CompoundTag ptTag = tradePersistentData.m_128728_(i);
                TradeRule.loadPersistentData(ptTag, trade.getRules(), "RuleData");
            }
        }
    }

    @Override
    protected void getAdditionalContents(List<ItemStack> results) {
    }

    @Override
    public List<? extends TradeData> getTradeData() {
        return new ArrayList<CommandTrade>(this.trades);
    }

    @Override
    @Nullable
    public CommandTrade getTrade(int tradeIndex) {
        if (tradeIndex < 0 || tradeIndex >= this.trades.size()) {
            return null;
        }
        return this.trades.get(tradeIndex);
    }

    @Override
    public void addTrade(Player requestor) {
        if (this.hasPermission(requestor, "editTrades")) {
            if (this.getTradeCount() >= 100) {
                return;
            }
            this.trades.add(new CommandTrade(true));
            this.markTradesDirty();
        }
    }

    @Override
    public void removeTrade(Player requestor) {
        if (this.hasPermission(requestor, "editTrades")) {
            if (this.trades.size() <= 1) {
                return;
            }
            this.trades.remove(this.trades.size() - 1);
            this.markTradesDirty();
        }
    }

    @Override
    protected TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        CommandTrade trade = this.getTrade(tradeIndex);
        if (trade == null || !trade.isValid()) {
            return TradeResult.FAIL_INVALID_TRADE;
        }
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (this.runPreTradeEvent(trade, context).isCanceled()) {
                return TradeResult.FAIL_TRADE_RULE_DENIAL;
            }
            MoneyValue price = trade.getCost(context);
            if (!context.getPayment(price)) {
                return TradeResult.FAIL_CANNOT_AFFORD;
            }
            MoneyValue taxesPaid = MoneyValue.empty();
            if (this.canStoreMoney()) {
                taxesPaid = this.addStoredMoney(price, true);
            }
            player2.f_8924_.m_129892_().m_230957_(this.sourceForPlayer(player2), trade.formatCommand((Player)player2));
            this.incrementStat(StatKeys.Traders.MONEY_EARNED, price);
            if (!taxesPaid.isEmpty()) {
                this.incrementStat(StatKeys.Taxables.TAXES_PAID, taxesPaid);
            }
            this.pushNotification(CommandTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            this.runPostTradeEvent(trade, context, price, taxesPaid);
            return TradeResult.SUCCESS;
        }
        return TradeResult.FAIL_NOT_SUPPORTED;
    }

    private CommandSourceStack sourceForPlayer(ServerPlayer player) {
        return new CommandSourceStack((CommandSource)player, player.m_20182_(), player.m_20155_(), player.m_284548_(), this.getPermissionLevel(), player.m_7755_().getString(), player.m_7755_(), player.f_8924_, (Entity)player);
    }

    @Override
    public boolean canMakePersistent() {
        return true;
    }

    @Override
    public void initStorageTabs(ITraderStorageMenu menu) {
        menu.setTab(1, new UpgradesTab(menu, 1));
        menu.setTab(2, new CommandTradeEditTab(menu));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addPermissionOptions(List<PermissionOption> options) {
    }

    @Override
    public List<MiscTabAddon> getMiscTabAddons() {
        List<MiscTabAddon> results = super.getMiscTabAddons();
        results.add(new CommandSettingsAddon());
        return results;
    }

    @Override
    public void handleSettingsChange(Player player, LazyPacketData message) {
        super.handleSettingsChange(player, message);
        if (message.contains("ChangePermissionLevel")) {
            this.setPermissionLevel(player, message.getInt("ChangePermissionLevel"));
        }
    }

    @Override
    protected void appendTerminalInfo(List<Component> list, @Nullable Player player) {
        list.add((Component)LCText.TOOLTIP_NETWORK_TERMINAL_TRADE_COUNT.get(this.validTradeCount()));
    }
}

