/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.trader;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.SingleLineTaxableNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.data.ItemData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GachaTradeNotification
extends SingleLineTaxableNotification {
    public static final NotificationType<GachaTradeNotification> TYPE = new NotificationType(VersionUtil.lcResource("gacha_trade"), GachaTradeNotification::new);
    private TraderCategory traderData;
    private ItemData item;
    private MoneyValue cost;
    private String customer;

    private GachaTradeNotification() {
    }

    private GachaTradeNotification(ItemStack item, MoneyValue cost, PlayerReference customer, TraderCategory traderData, MoneyValue taxes) {
        super(taxes);
        this.traderData = traderData;
        this.item = new ItemData(item);
        this.cost = cost;
        this.customer = customer.getName(false);
    }

    public static Supplier<Notification> create(ItemStack item, MoneyValue cost, PlayerReference customer, TraderCategory trader, MoneyValue taxesPaid) {
        return () -> new GachaTradeNotification(item, cost, customer, trader, taxesPaid);
    }

    @Override
    protected NotificationType<?> getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Override
    protected MutableComponent getNormalMessage() {
        return LCText.NOTIFICATION_TRADE_GACHA.get(this.customer, this.cost.getText("NULL"), this.item.format());
    }

    @Override
    protected void saveNormal(CompoundTag compound) {
        compound.m_128365_("TraderInfo", (Tag)this.traderData.save());
        compound.m_128365_("Item", (Tag)this.item.save());
        compound.m_128365_("Money", (Tag)this.cost.save());
        compound.m_128359_("Customer", this.customer);
    }

    @Override
    protected void loadNormal(CompoundTag compound) {
        this.traderData = new TraderCategory(compound.m_128469_("TraderInfo"));
        this.item = ItemData.load(compound.m_128469_("Item"));
        this.cost = MoneyValue.safeLoad(compound, "Money");
        this.customer = compound.m_128461_("Customer");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof GachaTradeNotification) {
            GachaTradeNotification gtn = (GachaTradeNotification)other;
            return gtn.traderData.matches(this.traderData) && gtn.item.matches(this.item) && gtn.cost.equals(this.cost) && gtn.customer.equals(this.customer) && gtn.TaxesMatch(this);
        }
        return false;
    }
}

