/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.settings;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ChangeSettingNotification
extends SingleLineNotification {
    public static final NotificationType<Advanced> ADVANCED_TYPE = new NotificationType(VersionUtil.lcResource("change_settings_advanced"), ChangeSettingNotification::createAdvanced);
    public static final NotificationType<Simple> SIMPLE_TYPE = new NotificationType(VersionUtil.lcResource("change_settings_simple"), ChangeSettingNotification::createSimple);
    public static final NotificationType<Dumb> DUMB_TYPE = new NotificationType(VersionUtil.lcResource("change_settings_dumb"), ChangeSettingNotification::createDumb);
    protected PlayerReference player;
    protected Component setting;

    protected ChangeSettingNotification(PlayerReference player, Component setting) {
        this.player = player;
        this.setting = setting;
    }

    protected ChangeSettingNotification() {
    }

    @Nullable
    public static ChangeSettingNotification dumb(@Nullable PlayerReference player, Component setting) {
        return player == null ? null : new Dumb(player, setting);
    }

    @Nullable
    public static ChangeSettingNotification simple(@Nullable PlayerReference player, Component setting, int newValue) {
        return ChangeSettingNotification.simple(player, setting, String.valueOf(newValue));
    }

    @Nullable
    public static ChangeSettingNotification simple(@Nullable PlayerReference player, Component setting, boolean newValue) {
        return ChangeSettingNotification.simple(player, setting, (Component)LCText.GUI_SETTINGS_VALUE_TRUE_FALSE.get(newValue).get(new Object[0]));
    }

    @Nullable
    public static ChangeSettingNotification simple(@Nullable PlayerReference player, Component setting, String newValue) {
        return ChangeSettingNotification.simple(player, setting, (Component)EasyText.literal(newValue));
    }

    @Nullable
    public static ChangeSettingNotification simple(@Nullable PlayerReference player, Component setting, Component newValue) {
        return player == null ? null : new Simple(player, setting, newValue);
    }

    @Nullable
    public static ChangeSettingNotification advanced(@Nullable PlayerReference player, Component setting, int newValue, int oldValue) {
        return ChangeSettingNotification.advanced(player, setting, String.valueOf(newValue), String.valueOf(oldValue));
    }

    public static ChangeSettingNotification advanced(@Nullable PlayerReference player, Component setting, String newValue, String oldValue) {
        return ChangeSettingNotification.advanced(player, setting, (Component)EasyText.literal(newValue), (Component)EasyText.literal(oldValue));
    }

    public static ChangeSettingNotification advanced(@Nullable PlayerReference player, Component setting, Component newValue, Component oldValue) {
        return player == null ? null : new Advanced(player, setting, newValue, oldValue);
    }

    @Override
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128365_("Player", (Tag)this.player.save());
        compound.m_128359_("Settings", Component.Serializer.m_130703_((Component)this.setting));
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.player = PlayerReference.load(compound.m_128469_("Player"));
        this.setting = EasyText.loadComponentOrString(compound.m_128461_("Setting"));
    }

    private static Advanced createAdvanced() {
        return new Advanced();
    }

    private static Simple createSimple() {
        return new Simple();
    }

    private static Dumb createDumb() {
        return new Dumb();
    }

    public static class Dumb
    extends ChangeSettingNotification {
        private Dumb() {
        }

        private Dumb(PlayerReference player, Component setting) {
            super(player, setting);
        }

        @Override
        protected MutableComponent getMessage() {
            return LCText.NOTIFICATION_SETTINGS_CHANGE_DUMB.get(this.player.getName(this.isClient()), this.setting);
        }

        @Override
        protected NotificationType<?> getType() {
            return DUMB_TYPE;
        }

        @Override
        protected boolean canMerge(Notification other) {
            if (other instanceof Dumb) {
                Dumb d = (Dumb)other;
                return d.player.equals(this.player) && d.setting.equals(this.setting);
            }
            return false;
        }
    }

    public static class Simple
    extends ChangeSettingNotification {
        Component newValue;

        private Simple() {
        }

        private Simple(PlayerReference player, Component setting, Component newValue) {
            super(player, setting);
            this.newValue = newValue;
        }

        protected NotificationType<Simple> getType() {
            return SIMPLE_TYPE;
        }

        @Override
        public MutableComponent getMessage() {
            return LCText.NOTIFICATION_SETTINGS_CHANGE_SIMPLE.get(this.player.getName(this.isClient()), this.setting, this.newValue);
        }

        @Override
        protected void saveAdditional(CompoundTag compound) {
            super.saveAdditional(compound);
            compound.m_128359_("NewValue", Component.Serializer.m_130703_((Component)this.newValue));
        }

        @Override
        protected void loadAdditional(CompoundTag compound) {
            super.loadAdditional(compound);
            this.newValue = EasyText.loadComponentOrString(compound.m_128461_("NewValue"));
        }

        @Override
        protected boolean canMerge(Notification other) {
            if (other instanceof Simple) {
                Simple n = (Simple)other;
                return n.player.is(this.player) && n.setting.equals(this.setting) && n.newValue.equals(this.newValue);
            }
            return false;
        }
    }

    public static class Advanced
    extends ChangeSettingNotification {
        Component newValue;
        Component oldValue;

        private Advanced() {
        }

        private Advanced(PlayerReference player, Component setting, Component newValue, Component oldValue) {
            super(player, setting);
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        protected NotificationType<Advanced> getType() {
            return ADVANCED_TYPE;
        }

        @Override
        public MutableComponent getMessage() {
            return LCText.NOTIFICATION_SETTINGS_CHANGE_ADVANCED.get(this.player.getName(this.isClient()), this.setting, this.oldValue, this.newValue);
        }

        @Override
        protected void saveAdditional(CompoundTag compound) {
            super.saveAdditional(compound);
            compound.m_128359_("NewValue", Component.Serializer.m_130703_((Component)this.newValue));
            compound.m_128359_("OldValue", Component.Serializer.m_130703_((Component)this.oldValue));
        }

        @Override
        protected void loadAdditional(CompoundTag compound) {
            super.loadAdditional(compound);
            this.newValue = EasyText.loadComponentOrString(compound.m_128461_("NewValue"));
            this.oldValue = EasyText.loadComponentOrString(compound.m_128461_("OldValue"));
        }

        @Override
        protected boolean canMerge(Notification other) {
            if (other instanceof Advanced) {
                Advanced n = (Advanced)other;
                return n.player.is(this.player) && n.setting.equals(this.setting) && n.newValue.equals(this.newValue) && n.oldValue.equals(this.oldValue);
            }
            return false;
        }
    }
}

