/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.bank;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BankTransferNotification
extends SingleLineNotification {
    public static final NotificationType<BankTransferNotification> TYPE = new NotificationType(VersionUtil.lcResource("bank_transfer"), BankTransferNotification::new);
    PlayerReference player;
    MoneyValue amount = MoneyValue.empty();
    MutableComponent accountName;
    MutableComponent otherAccount;
    boolean wasReceived;

    private BankTransferNotification() {
    }

    public BankTransferNotification(PlayerReference player, MoneyValue amount, MutableComponent accountName, MutableComponent otherAccount, boolean wasReceived) {
        this.player = player;
        this.amount = amount;
        this.accountName = accountName;
        this.otherAccount = otherAccount;
        this.wasReceived = wasReceived;
    }

    @Nonnull
    protected NotificationType<BankTransferNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return new BankCategory(this.accountName);
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        return LCText.NOTIFICATION_BANK_TRANSFER.get(this.player.getName(true), this.amount.getText(), this.wasReceived ? LCText.GUI_FROM.get(new Object[0]) : LCText.GUI_TO.get(new Object[0]), this.otherAccount);
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        compound.m_128365_("Player", (Tag)this.player.save());
        compound.m_128365_("Amount", (Tag)this.amount.save());
        compound.m_128359_("Account", Component.Serializer.m_130703_((Component)this.accountName));
        compound.m_128359_("Other", Component.Serializer.m_130703_((Component)this.otherAccount));
        compound.m_128379_("Received", this.wasReceived);
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        this.player = PlayerReference.load(compound.m_128469_("Player"));
        this.amount = MoneyValue.safeLoad(compound, "Amount");
        this.accountName = Component.Serializer.m_130701_((String)compound.m_128461_("Account"));
        this.otherAccount = Component.Serializer.m_130701_((String)compound.m_128461_("Other"));
        this.wasReceived = compound.m_128471_("Received");
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof BankTransferNotification) {
            BankTransferNotification n = (BankTransferNotification)other;
            return n.player.is(this.player) && n.amount.equals(this.amount) && n.accountName.equals((Object)this.accountName) && n.otherAccount.equals((Object)this.otherAccount) && n.wasReceived == this.wasReceived;
        }
        return false;
    }
}

