/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.gacha;

import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.gacha.GachaPriceClientTab;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaTrader;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GachaPriceTab
extends TraderStorageTab {
    public GachaPriceTab(ITraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(Object screen) {
        return new GachaPriceClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return ((ITraderStorageMenu)this.menu).hasPermission("editTrades");
    }

    public void setPrice(MoneyValue price) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof GachaTrader) {
            GachaTrader trader = (GachaTrader)traderData;
            trader.setPrice(((ITraderStorageMenu)this.menu).getPlayer(), price);
            if (this.isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setMoneyValue("ChangePrice", price));
            }
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("ChangePrice")) {
            this.setPrice(message.getMoneyValue("ChangePrice"));
        }
    }
}

