/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction.AuctionTradeCancelClientTab;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AuctionTradeCancelTab
extends TraderStorageTab {
    private int tradeIndex = -1;

    public AuctionTradeCancelTab(@Nonnull ITraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new AuctionTradeCancelClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return true;
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public AuctionTradeData getTrade() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)traderData;
            if (this.tradeIndex >= trader.getTradeCount() || this.tradeIndex < 0) {
                ((ITraderStorageMenu)this.menu).ChangeTab(0);
                return null;
            }
            return ((AuctionHouseTrader)((ITraderStorageMenu)this.menu).getTrader()).getTrade(this.tradeIndex);
        }
        return null;
    }

    public void cancelAuction(boolean giveToPlayer) {
        TraderData t = ((ITraderStorageMenu)this.menu).getTrader();
        if (t instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)t;
            AuctionTradeData trade = trader.getTrade(this.tradeIndex);
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setBoolean("CancelAuction", giveToPlayer));
                return;
            }
            if (trade.isOwner(((ITraderStorageMenu)this.menu).getPlayer())) {
                trade.CancelTrade(trader, giveToPlayer, ((ITraderStorageMenu)this.menu).getPlayer());
                trader.markTradesDirty();
                trader.markStorageDirty();
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setBoolean("CancelSuccess", true));
            }
        }
    }

    @Override
    public void OpenMessage(@Nonnull LazyPacketData message) {
        if (message.contains("TradeIndex")) {
            this.tradeIndex = message.getInt("TradeIndex");
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("CancelAuction")) {
            this.cancelAuction(message.getBoolean("CancelAuction"));
        }
    }
}

