/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.loot.glm;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class BonusItemModifier
implements IGlobalLootModifier {
    public static final Codec<BonusItemModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.listOf().fieldOf("targets").forGetter(m -> m.targets), (App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item), (App)Codec.FLOAT.fieldOf("odds").forGetter(m -> Float.valueOf(m.odds))).apply((Applicative)builder, BonusItemModifier::new));
    private final List<String> targets;
    private final Item item;
    private final float odds;

    private BonusItemModifier(@Nonnull List<String> targets, @Nonnull Item item, float odds) {
        this.targets = targets;
        this.item = item;
        this.odds = odds;
    }

    @Nonnull
    public ObjectArrayList<ItemStack> apply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        String lootTable = context.getQueriedLootTableId().toString();
        if (this.targets.contains(lootTable) && context.m_230907_().m_188501_() < this.odds) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @Nonnull
    public static Builder builder(@Nonnull Item item, float odds) {
        return new Builder(item, odds);
    }

    public static class Builder {
        private final List<String> targets = new ArrayList<String>();
        private final Item item;
        private final float odds;

        private Builder(@Nonnull Item item, float odds) {
            this.item = item;
            this.odds = odds;
        }

        @Nonnull
        public Builder withTarget(@Nonnull ResourceKey<LootTable> target) {
            return this.withTarget(target.m_135782_());
        }

        @Nonnull
        public Builder withTarget(@Nonnull ResourceLocation target) {
            return this.withTarget(target.toString());
        }

        @Nonnull
        public Builder withTarget(@Nonnull String target) {
            this.targets.add(target);
            return this;
        }

        @Nonnull
        public Builder withTargetKeys(@Nonnull List<ResourceKey<LootTable>> targets) {
            return this.withTargetIDs(targets.stream().map(ResourceKey::m_135782_).toList());
        }

        @Nonnull
        public Builder withTargetIDs(@Nonnull List<ResourceLocation> targets) {
            return this.withTargets(targets.stream().map(ResourceLocation::toString).toList());
        }

        @Nonnull
        public Builder withTargets(@Nonnull List<String> targets) {
            this.targets.addAll(targets);
            return this;
        }

        @Nonnull
        public BonusItemModifier build() {
            return new BonusItemModifier(this.targets, this.item, this.odds);
        }
    }
}

