/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.impl;

import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.api.teams.TeamAPI;
import io.github.lightman314.lightmanscurrency.common.data.types.TeamDataCache;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;

public final class TeamAPIImpl
extends TeamAPI {
    public static final TeamAPI INSTANCE = new TeamAPIImpl();

    private TeamAPIImpl() {
    }

    @Override
    @Nullable
    public ITeam GetTeam(boolean isClient, long teamID) {
        TeamDataCache data = TeamDataCache.TYPE.get(isClient);
        if (data == null) {
            return null;
        }
        return data.getTeam(teamID);
    }

    @Override
    @Nonnull
    public List<ITeam> GetAllTeams(boolean isClient) {
        TeamDataCache data = TeamDataCache.TYPE.get(isClient);
        if (data == null) {
            return new ArrayList<ITeam>();
        }
        return data.getAllTeams();
    }

    @Override
    @Nonnull
    public List<ITeam> GetAllTeamsForPlayer(@Nonnull Player player) {
        ArrayList<ITeam> result = new ArrayList<ITeam>();
        for (ITeam team : this.GetAllTeams(player.m_9236_().f_46443_)) {
            if (!team.isMember(player)) continue;
            result.add(team);
        }
        result.sort(this.SorterForPlayer(player));
        return new ArrayList<ITeam>(result);
    }

    @Override
    @Nullable
    public ITeam CreateTeam(@Nonnull Player owner, @Nonnull String name) {
        if (owner.m_9236_().f_46443_) {
            return null;
        }
        TeamDataCache data = TeamDataCache.TYPE.get(false);
        if (data == null) {
            return null;
        }
        return data.registerTeam(owner, name);
    }

    @Override
    @Nonnull
    public Comparator<ITeam> SorterForPlayer(@Nonnull Player player) {
        return Team.sorterFor(player);
    }
}

