/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.data.types;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.api.ejection.SafeEjectionAPI;
import io.github.lightman314.lightmanscurrency.api.events.TraderEvent;
import io.github.lightman314.lightmanscurrency.api.misc.IEasyTickable;
import io.github.lightman314.lightmanscurrency.api.misc.IServerTicker;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomData;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomDataType;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.data.types.TaxDataCache;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.PersistentAuctionData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TraderDataCache
extends CustomData
implements IServerTicker {
    public static final CustomDataType<TraderDataCache> TYPE = new CustomDataType<TraderDataCache>("lightmanscurrency_trader_data", TraderDataCache::new);
    public static final String PERSISTENT_TRADER_FILENAME = "config/lightmanscurrency/PersistentTraders.json";
    public static final String PERSISTENT_TRADER_SECTION = "Traders";
    public static final String PERSISTENT_AUCTION_SECTION = "Auctions";
    private int cleanTick = 0;
    private long nextID = 0L;
    private final Map<Long, TraderData> traderData = new HashMap<Long, TraderData>();
    private final Map<String, PersistentData> persistentTraderData = new HashMap<String, PersistentData>();
    private final List<PersistentAuctionData> persistentAuctionData = new ArrayList<PersistentAuctionData>();
    private final List<IEasyTickable> tickers = new ArrayList<IEasyTickable>();
    private JsonObject persistentTraderJson = new JsonObject();

    private long getNextID() {
        long id = this.nextID++;
        this.setChanged();
        return id;
    }

    private TraderDataCache() {
    }

    private void validateAuctionHouse() {
        if (!((Boolean)LCConfig.SERVER.auctionHouseEnabled.get()).booleanValue()) {
            LightmansCurrency.LogInfo("Will not create or validate the auction house as the auction house is disabled.");
            return;
        }
        if (this.traderData.values().stream().noneMatch(t -> t instanceof AuctionHouseTrader)) {
            AuctionHouseTrader ah = AuctionHouseTrader.TYPE.create();
            ah.setCreative(true);
            long traderID = this.getNextID();
            ah.setID(traderID);
            LightmansCurrency.LogInfo("Successfully created an auction house trader with id '" + traderID + "'!");
            this.addTraderInternal(traderID, ah);
        }
    }

    @Override
    public CustomDataType<?> getType() {
        return TYPE;
    }

    @Override
    public void save(CompoundTag tag) {
        tag.m_128356_("NextID", this.nextID);
        ListTag traderData = new ListTag();
        this.traderData.forEach((id, trader) -> {
            if (trader.isPersistent()) {
                try {
                    this.putPersistentTag(trader.getPersistentID(), trader.savePersistentData());
                }
                catch (Throwable t) {
                    LightmansCurrency.LogError("Error saving persistent trader data:", t);
                }
            } else {
                try {
                    traderData.add((Object)trader.save());
                }
                catch (Throwable t) {
                    LightmansCurrency.LogError("Error saving trader data:", t);
                }
            }
        });
        tag.m_128365_("TraderData", (Tag)traderData);
        ListTag persistentData = new ListTag();
        this.persistentTraderData.forEach((id, data) -> {
            try {
                CompoundTag c = new CompoundTag();
                c.m_128359_("Name", id);
                c.m_128356_("ID", data.id);
                c.m_128365_("Tag", (Tag)data.tag);
                persistentData.add((Object)c);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error saving Persistent Data:", t);
            }
        });
        tag.m_128365_("PersistentData", (Tag)persistentData);
    }

    @Override
    protected void load(CompoundTag tag) {
        this.nextID = tag.m_128454_("NextID");
        LightmansCurrency.LogInfo("Loaded NextID (" + this.nextID + ") from tag.");
        ListTag traderData = tag.m_128437_("TraderData", 10);
        for (int i = 0; i < traderData.size(); ++i) {
            try {
                CompoundTag traderTag = traderData.m_128728_(i);
                TraderData trader = TraderData.Deserialize(false, traderTag);
                if (trader != null) {
                    this.addTraderInternal(trader.getID(), trader);
                    continue;
                }
                LightmansCurrency.LogError("Error loading TraderData entry at index " + i);
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading TraderData", t);
            }
        }
        ListTag persistentData = tag.m_128437_("PersistentData", 10);
        for (int i = 0; i < persistentData.size(); ++i) {
            try {
                CompoundTag c = persistentData.m_128728_(i);
                String name = c.m_128461_("Name");
                long id = c.m_128454_("ID");
                CompoundTag data = c.m_128469_("Tag");
                this.persistentTraderData.put(name, new PersistentData(id, data));
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading Persistent Data", t);
            }
        }
    }

    private long getPersistentID(String traderID) {
        if (this.persistentTraderData.containsKey(traderID)) {
            return this.persistentTraderData.get((Object)traderID).id;
        }
        return -1L;
    }

    private void putPersistentID(String traderID, long id) {
        if (this.persistentTraderData.containsKey(traderID)) {
            this.persistentTraderData.get((Object)traderID).id = id;
        } else {
            this.persistentTraderData.put(traderID, new PersistentData(id, new CompoundTag()));
        }
        this.setChanged();
    }

    private CompoundTag getPersistentTag(String traderID) {
        if (this.persistentTraderData.containsKey(traderID)) {
            return this.persistentTraderData.get((Object)traderID).tag;
        }
        return new CompoundTag();
    }

    private void putPersistentTag(String traderID, CompoundTag tag) {
        if (this.persistentTraderData.containsKey(traderID)) {
            this.persistentTraderData.get((Object)traderID).tag = tag;
        } else {
            this.persistentTraderData.put(traderID, new PersistentData(-1L, tag));
        }
        this.setChanged();
    }

    @Nullable
    public JsonObject getPersistentTraderJson() {
        if (this.isClient()) {
            return null;
        }
        return this.persistentTraderJson;
    }

    @Nullable
    public JsonArray getPersistentTraderJson(String section) {
        if (this.isClient()) {
            return null;
        }
        if (!this.persistentTraderJson.has(section)) {
            JsonArray newSection = new JsonArray();
            this.persistentTraderJson.add(section, (JsonElement)newSection);
        }
        if (this.persistentTraderJson.get(section).isJsonArray()) {
            return this.persistentTraderJson.get(section).getAsJsonArray();
        }
        LightmansCurrency.LogError("Cannot get Persistent Data section '" + section + "' as it is not a JsonArray.");
        return null;
    }

    public void setPersistentTraderJson(JsonObject newData) {
        if (this.isClient()) {
            return;
        }
        File ptf = new File(PERSISTENT_TRADER_FILENAME);
        try {
            this.loadPersistentTrader(newData);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error loading modified Persistent Trader Data. Ignoring request.", e);
            return;
        }
        this.persistentTraderJson = newData;
        this.savePersistentTraderJson(ptf);
        this.resendTraderData();
    }

    public void setPersistentTraderSection(String section, JsonArray newData) {
        if (this.isClient()) {
            return;
        }
        this.persistentTraderJson.add(section, (JsonElement)newData);
        this.setPersistentTraderJson(this.persistentTraderJson);
    }

    public void reloadPersistentTraders() {
        this.loadPersistentTraders();
        this.resendTraderData();
    }

    private void loadPersistentTraders() {
        if (this.isClient()) {
            return;
        }
        File ptf = new File(PERSISTENT_TRADER_FILENAME);
        if (!ptf.exists()) {
            this.persistentTraderJson = TraderDataCache.generateDefaultPersistentTraderJson();
            this.savePersistentTraderJson(ptf);
        }
        try {
            this.persistentTraderJson = GsonHelper.m_13864_((String)Files.readString(ptf.toPath()));
            LightmansCurrency.LogDebug("Loading PersistentTraders.json\n" + FileUtil.GSON.toJson((JsonElement)this.persistentTraderJson));
            this.loadPersistentTrader(this.persistentTraderJson);
        }
        catch (Throwable e) {
            LightmansCurrency.LogError("Error loading Persistent Traders.", e);
            this.persistentTraderJson = TraderDataCache.generateDefaultPersistentTraderJson();
        }
    }

    private void savePersistentTraderJson(File ptf) {
        File dir = new File(ptf.getParent());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.exists()) {
            try {
                ptf.createNewFile();
                String jsonString = FileUtil.GSON.toJson((JsonElement)this.persistentTraderJson);
                FileUtil.writeStringToFile(ptf, jsonString);
                LightmansCurrency.LogInfo("PersistentTraders.json does not exist. Creating a fresh copy.");
            }
            catch (Throwable e) {
                LightmansCurrency.LogError("Error attempting to create 'persistentTraders.json' file.", e);
            }
        }
    }

    private static JsonObject generateDefaultPersistentTraderJson() {
        JsonObject fileData = new JsonObject();
        JsonArray traderList = new JsonArray();
        fileData.add(PERSISTENT_TRADER_SECTION, (JsonElement)traderList);
        JsonArray auctions = new JsonArray();
        fileData.add(PERSISTENT_AUCTION_SECTION, (JsonElement)auctions);
        return fileData;
    }

    private void loadPersistentTrader(@Nonnull JsonObject fileData) throws JsonSyntaxException, ResourceLocationException {
        boolean hadNone = true;
        if (fileData.has(PERSISTENT_TRADER_SECTION)) {
            hadNone = false;
            ArrayList removeTraderList = new ArrayList();
            this.traderData.forEach((id, trader) -> {
                if (trader.isPersistent()) {
                    if (trader instanceof IEasyTickable) {
                        IEasyTickable t = (IEasyTickable)((Object)trader);
                        this.tickers.remove(t);
                    }
                    this.putPersistentTag(trader.getPersistentID(), trader.savePersistentData());
                    removeTraderList.add(id);
                }
            });
            Iterator iterator = removeTraderList.iterator();
            while (iterator.hasNext()) {
                long id2 = (Long)iterator.next();
                this.traderData.remove(id2);
            }
            ArrayList<String> loadedIDs = new ArrayList<String>();
            JsonArray traderList = fileData.getAsJsonArray(PERSISTENT_TRADER_SECTION);
            for (int i = 0; i < traderList.size(); ++i) {
                try {
                    JsonObject traderTag = GsonHelper.m_13918_((JsonElement)traderList.get(i), (String)("Traders[" + i + "]"));
                    String traderID = GsonHelper.m_13851_((JsonObject)traderTag, (String)"id", (String)GsonHelper.m_13906_((JsonObject)traderTag, (String)"ID"));
                    if (loadedIDs.contains(traderID)) {
                        throw new JsonSyntaxException("Trader with id '" + traderID + "' already exists. Cannot have duplicate ids.");
                    }
                    if (traderID.isBlank()) {
                        throw new JsonSyntaxException("Trader cannot have a blank id!");
                    }
                    TraderData data = TraderData.Deserialize(traderTag);
                    data.loadPersistentData(this.getPersistentTag(traderID));
                    long id3 = this.getPersistentID(traderID);
                    if (id3 < 0L) {
                        id3 = this.getNextID();
                        this.putPersistentID(traderID, id3);
                        this.setChanged();
                        LightmansCurrency.LogInfo("Generated new ID for persistent trader '" + traderID + "' (" + id3 + ")");
                    }
                    data.makePersistent(id3, traderID);
                    this.addTraderInternal(id3, data);
                    loadedIDs.add(traderID);
                    LightmansCurrency.LogInfo("Successfully loaded persistent trader '" + traderID + "' with ID " + id3 + ".");
                    continue;
                }
                catch (JsonSyntaxException | ResourceLocationException e) {
                    LightmansCurrency.LogError("Error loading Persistent Trader at index " + i, e);
                }
            }
        }
        if (fileData.has(PERSISTENT_AUCTION_SECTION)) {
            hadNone = false;
            this.persistentAuctionData.clear();
            ArrayList<String> loadedIDs = new ArrayList<String>();
            JsonArray auctionList = fileData.getAsJsonArray(PERSISTENT_AUCTION_SECTION);
            for (int i = 0; i < auctionList.size(); ++i) {
                try {
                    JsonObject auctionTag = auctionList.get(i).getAsJsonObject();
                    PersistentAuctionData data = PersistentAuctionData.load(auctionTag);
                    if (loadedIDs.contains(data.id)) {
                        throw new JsonSyntaxException("Auction with id '" + data.id + "' already exists. Cannot have duplicate ids.");
                    }
                    loadedIDs.add(data.id);
                    this.persistentAuctionData.add(data);
                    LightmansCurrency.LogInfo("Successfully loaded persistent auction '" + data.id + "'");
                    continue;
                }
                catch (JsonSyntaxException | ResourceLocationException e) {
                    LightmansCurrency.LogError("Error loading Persistent Auction at index " + i, e);
                }
            }
        }
        if (hadNone) {
            throw new JsonSyntaxException("Json Data has no 'Traders' or 'Auctions' entry.");
        }
    }

    public long registerTrader(TraderData newTrader, @Nullable Player player) {
        if (this.isClient()) {
            return -1L;
        }
        long newID = this.getNextID();
        this.addTraderInternal(newID, newTrader);
        if (newTrader.shouldAlwaysShowOnTerminal() && player != null) {
            MinecraftForge.EVENT_BUS.post((Event)new TraderEvent.CreateNetworkTraderEvent(newID, player));
        }
        return newID;
    }

    private void addTraderInternal(long traderID, TraderData trader) {
        trader.setID(traderID);
        this.traderData.put(traderID, trader.allowMarkingDirty());
        this.setChanged();
        try {
            trader.OnRegisteredToOffice();
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error handling Trader-OnRegistration function!", t);
        }
        this.sendSyncPacket(this.updatePacket(trader.save()));
        if (trader instanceof IEasyTickable) {
            IEasyTickable t = (IEasyTickable)((Object)trader);
            this.tickers.add(t);
        }
    }

    public void markTraderDirty(CompoundTag updateData) {
        this.setChanged();
        this.sendSyncPacket(this.updatePacket(updateData));
    }

    private LazyPacketData.Builder updatePacket(CompoundTag updateData) {
        return this.builder().setCompound("UpdateTrader", updateData);
    }

    public void deleteTrader(long traderID) {
        if (this.isClient()) {
            return;
        }
        if (this.traderData.containsKey(traderID)) {
            TraderData trader = this.traderData.get(traderID);
            TaxDataCache.TYPE.get(false).getAllEntries().forEach(e -> e.TaxableWasRemoved(trader));
            this.traderData.remove(traderID);
            if (trader instanceof IEasyTickable) {
                IEasyTickable t = (IEasyTickable)((Object)trader);
                this.tickers.remove(t);
            }
            this.setChanged();
            this.sendSyncPacket(this.builder().setLong("DeleteTrader", traderID));
            if (trader.shouldAlwaysShowOnTerminal()) {
                MinecraftForge.EVENT_BUS.post((Event)new TraderEvent.RemoveNetworkTraderEvent(traderID, trader));
            }
        }
    }

    @Override
    protected void parseSyncPacket(LazyPacketData data) {
        if (data.contains("ClearTraders")) {
            this.traderData.clear();
        }
        if (data.contains("DeleteTrader")) {
            this.traderData.remove(data.getLong("DeleteTrader"));
        }
        if (data.contains("UpdateTrader")) {
            CompoundTag updateTag = data.getNBT("UpdateTrader");
            long id = updateTag.m_128454_("ID");
            if (this.traderData.containsKey(id)) {
                this.traderData.get(id).load(updateTag);
            } else {
                TraderData trader = TraderData.Deserialize(true, updateTag);
                if (trader != null) {
                    this.traderData.put(id, trader.flagAsClient(this));
                    trader.OnRegisteredToOffice();
                }
            }
        }
    }

    public List<TraderData> getAllTraders() {
        return new ArrayList<TraderData>(this.traderData.values());
    }

    public List<TraderData> getAllTerminalTraders() {
        return new ArrayList<TraderData>(this.getAllTraders().stream().filter(TraderData::showOnTerminal).toList());
    }

    @Nullable
    public TraderData getTrader(long traderID) {
        return this.traderData.get(traderID);
    }

    @Nullable
    public TraderData getTrader(String persistentTraderID) {
        if (this.isClient()) {
            List<TraderData> validTraders = this.getAllTraders().stream().filter(t -> t.getPersistentID().equals(persistentTraderID)).toList();
            if (!validTraders.isEmpty()) {
                return validTraders.get(0);
            }
            return null;
        }
        return this.traderData.get(this.getPersistentID(persistentTraderID));
    }

    @Nullable
    public TraderData getAuctionHouse() {
        List<TraderData> validTraders = this.getAllTraders().stream().filter(t -> t instanceof AuctionHouseTrader).toList();
        if (!validTraders.isEmpty()) {
            return validTraders.get(0);
        }
        return null;
    }

    @Override
    public void serverTick() {
        Object pos;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        ProfilerFiller filler = server.m_129905_();
        if (this.cleanTick++ >= 1200) {
            filler.m_6180_("Trader Data Position Validation");
            this.cleanTick = 0;
            ArrayList<TraderData> remove = new ArrayList<TraderData>();
            for (TraderData traderData : new ArrayList<TraderData>(this.traderData.values())) {
                if (!traderData.shouldRemove(server)) continue;
                remove.add(traderData);
            }
            for (TraderData traderData : remove) {
                if (traderData instanceof IEasyTickable) {
                    IEasyTickable t = (IEasyTickable)((Object)traderData);
                    this.tickers.remove(t);
                }
                this.traderData.remove(traderData.getID());
                try {
                    ServerLevel level = server.m_129880_(traderData.getLevel());
                    pos = traderData.getPos();
                    EjectionData e = traderData.buildEjectionData((Level)level, (BlockPos)pos, null);
                    SafeEjectionAPI.getApi().handleEjection((Level)level, (BlockPos)pos, e);
                }
                catch (NullPointerException e) {
                    LightmansCurrency.LogError("Error deleting missing trader.", e);
                }
                this.sendSyncPacket(this.builder().setLong("DeleteTrader", traderData.getID()));
            }
            filler.m_7238_();
        }
        if (server.m_129921_() % 20 == 0 && !this.persistentAuctionData.isEmpty()) {
            filler.m_6180_("Persistent Auction Tick");
            ArrayList<TraderData> traders = new ArrayList<TraderData>(this.traderData.values());
            AuctionHouseTrader ah = null;
            for (int i = 0; i < traders.size() && ah == null; ++i) {
                AuctionHouseTrader temp;
                pos = traders.get(i);
                if (!(pos instanceof AuctionHouseTrader)) continue;
                ah = temp = (AuctionHouseTrader)pos;
            }
            if (ah != null) {
                for (PersistentAuctionData pad : this.persistentAuctionData) {
                    AuctionTradeData trade;
                    if (ah.hasPersistentAuction(pad.id) || (trade = pad.createAuction()) == null) continue;
                    ah.addTrade(trade, true);
                    LightmansCurrency.LogInfo("Successfully added Persistent Auction '" + pad.id + "' into the auction house.");
                }
            }
            filler.m_7238_();
        }
        filler.m_6180_("Trader Ticks");
        for (IEasyTickable tickable : this.tickers) {
            tickable.tick();
        }
        filler.m_7238_();
    }

    @Override
    protected void serverInit() {
        if (this.isClient()) {
            return;
        }
        this.validateAuctionHouse();
        this.loadPersistentTraders();
    }

    @Override
    public void onPlayerJoin(ServerPlayer player) {
        this.sendSyncPacket(this.builder().setFlag("ClearTraders"), player);
        this.traderData.forEach((id, trader) -> this.sendSyncPacket(this.updatePacket(trader.save()), player));
    }

    private void resendTraderData() {
        this.sendSyncPacket(this.builder().setFlag("ClearTraders"));
        this.traderData.forEach((id, trader) -> this.sendSyncPacket(this.updatePacket(trader.save())));
    }

    private static class PersistentData {
        public long id;
        public CompoundTag tag;

        public PersistentData(long id, CompoundTag tag) {
            this.id = id;
            this.tag = tag;
        }
    }
}

