/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.crafting.RecipeTypes;
import io.github.lightman314.lightmanscurrency.common.crafting.input.TicketStationRecipeInput;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.util.ItemRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public interface TicketStationRecipe
extends Recipe<TicketStationRecipeInput> {
    public static final Predicate<String> CODE_PREDICATE = s -> {
        if (s.isBlank()) {
            return false;
        }
        if (s.length() > 16) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (TicketStationRecipe.validCodeChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    };
    public static final Predicate<String> CODE_INPUT_PREDICATE = s -> s.isEmpty() || CODE_PREDICATE.test((String)s);

    public static boolean validCodeChar(char codeChar) {
        return codeChar >= 'a' && codeChar <= 'z' || codeChar >= 'A' && codeChar <= 'Z' || codeChar >= '0' && codeChar <= '9';
    }

    @Nonnull
    default public RecipeType<TicketStationRecipe> m_6671_() {
        return (RecipeType)RecipeTypes.TICKET.get();
    }

    @Nonnull
    default public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.TICKET_STATION.get());
    }

    @Nonnull
    public static List<ItemStack> exampleModifierList(@Nonnull TagKey<Item> tag, Item ... extra) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Item extraItem : extra) {
            result.add(new ItemStack((ItemLike)extraItem));
        }
        for (Item modifier : ForgeRegistries.ITEMS.tags().getTag(tag)) {
            result.add(new ItemStack((ItemLike)modifier));
        }
        return result;
    }

    @Nonnull
    public static List<ItemStack> exampleTicketList(@Nonnull RegistryObject<? extends ItemLike> item) {
        return TicketStationRecipe.exampleTicketList(((ItemLike)item.get()).m_5456_());
    }

    @Nonnull
    public static List<ItemStack> exampleTicketList(@Nonnull Ingredient ingredient) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack item : ingredient.m_43908_()) {
            result.addAll(TicketStationRecipe.exampleTicketList(item.m_41720_()));
        }
        return result;
    }

    public static List<ItemStack> exampleTicketList(@Nonnull Item item) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Color color : Color.values()) {
            result.add(TicketItem.CreateExampleTicket(item, color));
        }
        return result;
    }

    public boolean consumeModifier();

    public boolean validModifier(@Nonnull ItemStack var1);

    @Nonnull
    public List<ItemStack> jeiModifierList();

    public boolean validIngredient(@Nonnull ItemStack var1);

    @Nonnull
    public Ingredient getIngredient();

    @Nonnull
    public ItemStack peekAtResult(@Nonnull Container var1, @Nonnull String var2);

    @Nonnull
    public ItemStack exampleResult();

    default public boolean requiredCodeInput() {
        return false;
    }

    default public boolean validCode(String code) {
        return !this.requiredCodeInput() || CODE_PREDICATE.test(code);
    }

    default public boolean matches(@Nonnull TicketStationRecipeInput container, @Nonnull Level level) {
        return this.validModifier(container.m_8020_(0)) && this.validIngredient(container.m_8020_(1));
    }

    default public boolean matchesTicketKioskSellItem(ItemStack sellItem) {
        return !this.consumeModifier() && this.validModifier(sellItem);
    }

    default public boolean allowIgnoreKioskRecipe() {
        return false;
    }

    public ItemStack assembleWithKiosk(ItemStack var1, String var2);

    default public ItemRequirement getKioskStorageRequirement(ItemStack sellItem) {
        return ItemRequirement.of(this.getIngredient(), sellItem.m_41613_());
    }
}

