/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.input.TicketStationRecipeInput;
import io.github.lightman314.lightmanscurrency.common.data.types.TicketDataCache;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menus.slots.ticket.TicketModifierSlot;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MasterTicketRecipe
implements TicketStationRecipe {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final Item result;

    public MasterTicketRecipe(ResourceLocation id, Ingredient ingredient, Item result) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
    }

    @Override
    public boolean consumeModifier() {
        return true;
    }

    @Override
    public List<ItemStack> jeiModifierList() {
        return TicketStationRecipe.exampleModifierList((TagKey<Item>)Tags.Items.DYES, Items.f_41852_);
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public ItemStack exampleResult() {
        return TicketItem.CreateTicket(this.result, -1L, 0xFFFF00);
    }

    @Override
    public boolean validModifier(ItemStack stack) {
        return stack.m_41619_() || stack.m_204117_(Tags.Items.DYES);
    }

    @Override
    public boolean validIngredient(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public ItemStack assemble(TicketStationRecipeInput container, RegistryAccess registryAccess) {
        long nextTicketID = TicketDataCache.TYPE.isLoaded(false) ? TicketDataCache.TYPE.get(false).createNextID() : -100L;
        ItemStack dyeStack = container.m_8020_(0);
        Color dyeColor = TicketModifierSlot.getColorFromDye(dyeStack);
        int color = dyeColor == null ? TicketItem.GetDefaultTicketColor(nextTicketID) : dyeColor.hexColor;
        return TicketItem.CreateTicket(this.result, nextTicketID, color, 1);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        long nextTicketID = TicketDataCache.TYPE.getUnknown().peekNextID();
        int color = TicketItem.GetDefaultTicketColor(nextTicketID);
        return TicketItem.CreateTicket(this.result, nextTicketID, color, 1);
    }

    @Override
    public ItemStack peekAtResult(Container container, String code) {
        long nextTicketID = TicketDataCache.TYPE.getUnknown().peekNextID();
        ItemStack dyeStack = container.m_8020_(0);
        Color dyeColor = TicketModifierSlot.getColorFromDye(dyeStack);
        if (dyeColor != null) {
            return TicketItem.CreateTicket(this.result, nextTicketID, dyeColor.hexColor);
        }
        return TicketItem.CreateTicket(this.result, nextTicketID);
    }

    @Override
    public ItemStack assembleWithKiosk(ItemStack sellITem, String code) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.TICKET_MASTER.get();
    }

    public static class Serializer
    implements RecipeSerializer<MasterTicketRecipe> {
        public MasterTicketRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            Item result = CraftingHelper.getItem((String)GsonHelper.m_13906_((JsonObject)json, (String)"result"), (boolean)true);
            return new MasterTicketRecipe(id, ingredient, result);
        }

        @Nullable
        public MasterTicketRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            return new MasterTicketRecipe(id, Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130267_().m_41720_());
        }

        public void toNetwork(FriendlyByteBuf buffer, MasterTicketRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(new ItemStack((ItemLike)recipe.result));
        }
    }
}

