/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.input.TicketStationRecipeInput;
import io.github.lightman314.lightmanscurrency.common.items.CouponItem;
import io.github.lightman314.lightmanscurrency.common.menus.slots.ticket.TicketModifierSlot;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CouponRecipe
implements TicketStationRecipe {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final Item result;

    private ResourceLocation resultID() {
        return ForgeRegistries.ITEMS.getKey((Object)this.result);
    }

    public CouponRecipe(ResourceLocation id, @Nonnull Ingredient ingredient, @Nonnull Item result) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public boolean consumeModifier() {
        return true;
    }

    @Override
    @Nonnull
    public List<ItemStack> jeiModifierList() {
        return TicketStationRecipe.exampleModifierList((TagKey<Item>)Tags.Items.DYES, Items.f_41852_);
    }

    @Override
    @Nonnull
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    @Nonnull
    public ItemStack exampleResult() {
        return CouponItem.CreateCoupon(this.result, "");
    }

    @Override
    public boolean requiredCodeInput() {
        return true;
    }

    @Override
    public boolean validModifier(@Nonnull ItemStack stack) {
        return stack.m_41619_() || stack.m_204117_(Tags.Items.DYES);
    }

    @Override
    public boolean validIngredient(@Nonnull ItemStack stack) {
        return this.ingredient.test(stack);
    }

    @Nonnull
    public ItemStack assemble(TicketStationRecipeInput container, @Nonnull RegistryAccess lookup) {
        ItemStack dyeStack = container.m_8020_(0);
        Color dyeColor = TicketModifierSlot.getColorFromDye(dyeStack);
        int color = dyeColor == null ? 0xFFFFFF : dyeColor.hexColor;
        return CouponItem.CreateCoupon(this.result, container.getCode(), color);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Nonnull
    public ItemStack m_8043_(@Nonnull RegistryAccess lookup) {
        return CouponItem.CreateCoupon(this.result, "");
    }

    @Override
    @Nonnull
    public ItemStack peekAtResult(@Nonnull Container container, @Nonnull String code) {
        ItemStack dyeStack = container.m_8020_(0);
        Color dyeColor = TicketModifierSlot.getColorFromDye(dyeStack);
        if (dyeColor != null) {
            return CouponItem.CreateCoupon(this.result, code, dyeColor.hexColor);
        }
        return CouponItem.CreateCoupon(this.result, code);
    }

    @Override
    public boolean matchesTicketKioskSellItem(ItemStack sellItem) {
        return this.validIngredient(sellItem) && !InventoryUtil.ItemHasTag(sellItem, LCTags.Items.TICKETS_MASTER);
    }

    @Override
    public boolean allowIgnoreKioskRecipe() {
        return true;
    }

    @Override
    public ItemStack assembleWithKiosk(ItemStack sellItem, String code) {
        return CouponItem.CreateCoupon(this.result, code);
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.COUPON.get();
    }

    public static class Serializer
    implements RecipeSerializer<CouponRecipe> {
        public CouponRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)json.get("ingredient"), (boolean)false);
            Item result = CraftingHelper.getItem((String)GsonHelper.m_13906_((JsonObject)json, (String)"result"), (boolean)false);
            return new CouponRecipe(id, ingredient, result);
        }

        @Nullable
        public CouponRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Item result = CraftingHelper.getItem((String)buffer.m_130277_(), (boolean)false);
            return new CouponRecipe(id, ingredient, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, CouponRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130070_(recipe.resultID().toString());
        }
    }
}

