/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import io.github.lightman314.lightmanscurrency.api.misc.IServerTicker;
import io.github.lightman314.lightmanscurrency.api.misc.blockentity.EasyBlockEntity;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.common.blockentity.handler.MoneyBagItemViewer;
import io.github.lightman314.lightmanscurrency.common.blocks.MoneyBagBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.MoneyBagItem;
import io.github.lightman314.lightmanscurrency.common.util.TagUtil;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Range;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MoneyBagBlockEntity
extends EasyBlockEntity
implements IServerTicker {
    public static final int MAX_ITEM_COUNT = 576;
    public boolean shouldDropItem = true;
    private Component customName = null;
    private boolean lootTableChecked = false;
    private BlockPos savedPosition;
    private ResourceLocation lootTable;
    private long lootTableSeed = -1L;
    private final List<ItemStack> contents = new ArrayList<ItemStack>();
    public final IItemHandler viewer = new MoneyBagItemViewer(this);

    public MoneyBagBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        this(ModBlockEntities.MONEY_BAG.get(), pos, state);
    }

    protected MoneyBagBlockEntity(@Nonnull BlockEntityType<?> type, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        super(type, pos, state);
    }

    public List<ItemStack> viewContents() {
        return InventoryUtil.copyList(this.contents);
    }

    public List<ItemStack> clearContents() {
        this.checkLootTable();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(this.contents);
        this.contents.clear();
        this.m_6596_();
        return result;
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public @Range(from=0L, to=3L) int getBlockSize() {
        return MoneyBagBlockEntity.getBlockSize(this.getTotalContentCount());
    }

    public static @Range(from=0L, to=3L) int getBlockSize(List<ItemStack> contents) {
        return MoneyBagBlockEntity.getBlockSize(MoneyBagBlockEntity.getTotalContentCount(contents));
    }

    public static @Range(from=0L, to=3L) int getBlockSize(int totalCount) {
        if (totalCount < 192) {
            return 0;
        }
        if (totalCount < 384) {
            return 1;
        }
        if (totalCount < 576) {
            return 2;
        }
        return 3;
    }

    public int getTotalContentCount() {
        return MoneyBagBlockEntity.getTotalContentCount(this.contents);
    }

    public static int getTotalContentCount(List<ItemStack> contents) {
        int count = 0;
        for (ItemStack item : contents) {
            count += item.m_41613_();
        }
        return count;
    }

    public boolean tryInsertItem(ItemStack item, @Nullable Player player) {
        this.checkLootTable();
        if (this.getTotalContentCount() >= 576) {
            return false;
        }
        if (CoinAPI.API.IsAllowedInCoinContainer(item, false)) {
            for (ItemStack i : this.contents) {
                if (!InventoryUtil.ItemMatches(i, item)) continue;
                i.m_41769_(1);
                this.onContentsChanged();
                return true;
            }
            this.contents.add(item.m_255036_(1));
            this.onContentsChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeRandomItem() {
        this.checkLootTable();
        ItemStack result = MoneyBagBlockEntity.removeRandomItem(this.contents, this.f_58857_.f_46441_);
        if (!result.m_41619_()) {
            this.onContentsChanged();
        }
        return result;
    }

    public static ItemStack removeRandomItem(List<ItemStack> contents, RandomSource random) {
        if (contents.isEmpty()) {
            return ItemStack.f_41583_;
        }
        int totalCount = 0;
        for (ItemStack item : contents) {
            totalCount += item.m_41613_();
        }
        int rand = random.m_188503_(totalCount);
        for (int i = 0; i < contents.size(); ++i) {
            ItemStack item = contents.get(i);
            if ((rand -= item.m_41613_()) >= 0) continue;
            ItemStack result = item.m_41620_(1);
            if (item.m_41619_()) {
                contents.remove(i);
            }
            return result;
        }
        return ItemStack.f_41583_;
    }

    private void onContentsChanged() {
        if (this.isClient()) {
            return;
        }
        this.m_6596_();
        BlockEntityUtil.sendUpdatePacket(this);
        BlockState state = this.m_58900_();
        int currentSize = (Integer)state.m_61143_((Property)MoneyBagBlock.SIZE);
        int actualSize = this.getBlockSize();
        if (currentSize != actualSize) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)MoneyBagBlock.SIZE, (Comparable)Integer.valueOf(actualSize)));
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        ListTag list = new ListTag();
        for (ItemStack item : new ArrayList<ItemStack>(this.contents)) {
            if (item.m_41619_()) continue;
            list.add((Object)InventoryUtil.saveItemNoLimits(item));
        }
        tag.m_128365_("Contents", (Tag)list);
        if (this.lootTable != null) {
            tag.m_128359_("LootTable", this.lootTable.toString());
            if (this.lootTableSeed >= 0L) {
                tag.m_128356_("LootTableSeed", this.lootTableSeed);
            }
            tag.m_128365_("SavedPos", (Tag)TagUtil.saveBlockPos(this.savedPosition == null ? this.f_58858_ : this.savedPosition));
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        this.contents.clear();
        ListTag list = tag.m_128437_("Contents", 10);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = InventoryUtil.loadItemNoLimits(list.m_128728_(i));
            if (item.m_41619_()) continue;
            this.contents.add(item);
        }
        if (tag.m_128441_("LootTable")) {
            this.lootTable = VersionUtil.parseResource(tag.m_128461_("LootTable"));
            if (tag.m_128441_("LootTableSeed")) {
                this.lootTableSeed = tag.m_128454_("LootTableSeed");
            }
            if (tag.m_128441_("SavedPos")) {
                this.savedPosition = TagUtil.loadBlockPos(tag.m_128469_("SavedPos"));
            }
        }
    }

    public void loadFromItem(ItemStack moneybag) {
        if (moneybag.m_41788_()) {
            this.customName = moneybag.m_41786_();
        }
        this.contents.clear();
        this.contents.addAll(MoneyBagItem.getContents(moneybag));
        this.onContentsChanged();
        CompoundTag tag = moneybag.m_41783_();
        if (tag != null && tag.m_128441_("LootTable")) {
            this.lootTable = VersionUtil.parseResource(tag.m_128461_("LootTable"));
            if (tag.m_128441_("LootTableSeed")) {
                this.lootTableSeed = tag.m_128454_("LootTableSeed");
            }
            this.savedPosition = this.f_58858_;
            this.m_6596_();
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.isClient()) {
            BlockEntityUtil.requestUpdatePacket(this);
        } else {
            this.checkLootTable();
        }
    }

    @Override
    public void serverTick() {
        if (!this.lootTableChecked) {
            this.checkLootTable();
        }
    }

    private void checkLootTable() {
        if (this.lootTableChecked) {
            return;
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (this.lootTable != null && this.savedPosition != null) {
                this.lootTableChecked = true;
                if (this.savedPosition.equals((Object)this.f_58858_)) {
                    return;
                }
                LootTable table = sl.m_7654_().m_278653_().m_278676_(this.lootTable);
                if (table == null) {
                    this.lootTable = null;
                    this.lootTableSeed = -1L;
                    this.savedPosition = null;
                }
                LootParams lootParams = new LootParams.Builder(sl).m_287286_(LootContextParams.f_81460_, (Object)this.f_58858_.m_252807_()).m_287235_(LootContextParamSets.f_81411_);
                this.contents.clear();
                ObjectArrayList loot = this.lootTableSeed >= 0L ? table.m_287214_(lootParams, this.lootTableSeed) : table.m_287195_(lootParams);
                this.contents.addAll(InventoryUtil.combineQueryItems((List<ItemStack>)loot));
                this.lootTable = null;
                this.lootTableSeed = -1L;
                this.savedPosition = null;
                this.onContentsChanged();
            }
        }
    }

    public void copyContentsTo(ItemStack item) {
        CompoundTag tag;
        if (this.customName != null) {
            item.m_41714_(this.customName);
        }
        if (!this.contents.isEmpty()) {
            tag = item.m_41784_();
            MoneyBagItem.setContents(item, this.contents);
        }
        if (this.lootTable != null) {
            tag = item.m_41784_();
            tag.m_128359_("LootTable", this.lootTable.toString());
            if (this.lootTableSeed >= 0L) {
                tag.m_128356_("LootTableSeed", this.lootTableSeed);
            }
        }
    }
}

