/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.data.TradeReference;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.blockentity.handler.ItemInterfaceHandler;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.item.ItemStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.Upgrades;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class ItemTraderInterfaceBlockEntity
extends TraderInterfaceBlockEntity
implements TraderItemStorage.ITraderItemFilter {
    private final TraderItemStorage itemBuffer = new TraderItemStorage(this);
    ItemInterfaceHandler itemHandler = this.addHandler(new ItemInterfaceHandler(this));

    public TraderItemStorage getItemBuffer() {
        return this.itemBuffer;
    }

    public ItemInterfaceHandler getItemHandler() {
        return this.itemHandler;
    }

    public ItemTraderInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.TRADER_INTERFACE_ITEM.get(), pos, state);
    }

    @Override
    public TradeContext.Builder buildTradeContext(TradeContext.Builder baseContext) {
        return baseContext.withItemHandler(this.itemBuffer);
    }

    public boolean allowInput(ItemStack item) {
        block7: {
            block6: {
                if (!this.getInteractionType().trades()) break block6;
                for (TradeReference t : this.targets.getTradeReferences()) {
                    int i;
                    TradeData t2 = t.getLocalTrade();
                    if (!(t2 instanceof ItemTradeData)) continue;
                    ItemTradeData trade = (ItemTradeData)t2;
                    if (trade.isBarter()) {
                        for (i = 0; i < 2; ++i) {
                            if (!InventoryUtil.ItemMatches(item, trade.getBarterItem(i))) continue;
                            return true;
                        }
                        continue;
                    }
                    if (!trade.isPurchase()) continue;
                    for (i = 0; i < 2; ++i) {
                        if (!InventoryUtil.ItemMatches(item, trade.getSellItem(i))) continue;
                        return true;
                    }
                }
                break block7;
            }
            TraderData t = this.targets.getTrader();
            if (!(t instanceof ItemTraderData)) break block7;
            ItemTraderData trader = (ItemTraderData)t;
            for (ItemTradeData trade : trader.getTradeData()) {
                if (!trade.isSale() && !trade.isBarter()) continue;
                for (int i = 0; i < 2; ++i) {
                    if (!InventoryUtil.ItemMatches(item, trade.getSellItem(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean allowOutput(ItemStack item) {
        return !this.allowInput(item);
    }

    @Override
    public boolean isItemRelevant(ItemStack item) {
        block3: {
            block2: {
                if (!this.getInteractionType().trades()) break block2;
                for (TradeReference t : this.targets.getTradeReferences()) {
                    ItemTradeData trade;
                    TradeData t2 = t.getLocalTrade();
                    if (!(t2 instanceof ItemTradeData) || !(trade = (ItemTradeData)t2).allowItemInStorage(item)) continue;
                    return true;
                }
                break block3;
            }
            TraderData t = this.targets.getTrader();
            if (!(t instanceof ItemTraderData)) break block3;
            ItemTraderData trader = (ItemTraderData)t;
            for (ItemTradeData trade : trader.getTradeData()) {
                if (!trade.allowItemInStorage(item)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getStorageStackLimit() {
        int limit = 576;
        for (int i = 0; i < this.getUpgrades().m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgrades().m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)item) || upgradeItem.getUpgradeType() != Upgrades.ITEM_CAPACITY) continue;
            limit += UpgradeItem.getUpgradeData(stack).getIntValue(CapacityUpgrade.CAPACITY);
        }
        return limit;
    }

    @Override
    public ItemTradeData deserializeTrade(CompoundTag compound) {
        return ItemTradeData.loadOfUnknownType(compound, false);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        this.saveItemBuffer(compound);
    }

    protected final CompoundTag saveItemBuffer(CompoundTag compound) {
        this.itemBuffer.save(compound, "Storage");
        return compound;
    }

    public void setItemBufferDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveItemBuffer(new CompoundTag()));
        }
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Storage")) {
            this.itemBuffer.load(compound, "Storage");
        }
    }

    @Override
    public boolean validTraderType(TraderData trader) {
        return trader instanceof ItemTraderData;
    }

    protected final ItemTraderData getItemTrader() {
        TraderData trader = this.targets.getTrader();
        if (trader instanceof ItemTraderData) {
            ItemTraderData t = (ItemTraderData)trader;
            return t;
        }
        return null;
    }

    @Override
    protected void drainTick(@Nonnull TraderData t) {
        ItemTraderData trader;
        if (t instanceof ItemTraderData && (trader = (ItemTraderData)t).hasPermission(this.owner.getPlayerForContext(), "interactionLink")) {
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                ItemTradeData trade = trader.getTrade(i);
                if (!trade.isValid()) continue;
                ArrayList<ItemStack> drainItems = new ArrayList<ItemStack>();
                if (trade.isPurchase()) {
                    drainItems.add(trade.getSellItem(0));
                    drainItems.add(trade.getSellItem(1));
                }
                if (trade.isBarter()) {
                    drainItems.add(trade.getBarterItem(0));
                    drainItems.add(trade.getBarterItem(1));
                }
                for (ItemStack drainItem : drainItems) {
                    int drainableAmount;
                    if (drainItem.m_41619_() || (drainableAmount = trader.getStorage().getItemCount(drainItem)) <= 0) continue;
                    ItemStack movingStack = drainItem.m_41777_();
                    movingStack.m_41764_(Math.min(movingStack.m_41741_(), drainableAmount));
                    ItemStack removed = trader.getStorage().removeItem(movingStack);
                    ItemStack leftovers = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemBuffer, (ItemStack)removed, (boolean)false);
                    if (!leftovers.m_41619_()) {
                        trader.getStorage().forceAddItem(leftovers);
                    }
                    this.setItemBufferDirty();
                    trader.markStorageDirty();
                }
            }
        }
    }

    @Override
    protected void restockTick(@Nonnull TraderData t) {
        ItemTraderData trader;
        if (t instanceof ItemTraderData && (trader = (ItemTraderData)t).hasPermission(this.owner.getPlayerForContext(), "interactionLink")) {
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                ItemTradeData trade = trader.getTrade(i);
                if (!trade.isValid() || !trade.isBarter() && !trade.isSale()) continue;
                for (int s = 0; s < 2; ++s) {
                    int stockableAmount;
                    ItemStack stockItem = trade.getSellItem(s);
                    if (stockItem.m_41619_() || (stockableAmount = this.itemBuffer.getItemCount(stockItem)) <= 0) continue;
                    ItemStack movingStack = stockItem.m_41777_();
                    movingStack.m_41764_(Math.min(movingStack.m_41741_(), stockableAmount));
                    ItemStack removedItem = this.itemBuffer.removeItem(movingStack);
                    if (removedItem.m_41613_() == movingStack.m_41613_()) {
                        trader.getStorage().tryAddItem(movingStack);
                        if (!movingStack.m_41619_()) {
                            this.itemBuffer.forceAddItem(movingStack);
                        }
                    } else {
                        this.itemBuffer.forceAddItem(removedItem);
                    }
                    this.setItemBufferDirty();
                    trader.markStorageDirty();
                }
            }
        }
    }

    @Override
    protected void tradeTick(@Nonnull TradeReference tr) {
        ItemTradeData trade;
        TradeData t = tr.getTrueTrade();
        if (t instanceof ItemTradeData && (trade = (ItemTradeData)t) != null && trade.isValid()) {
            if (trade.isSale()) {
                if (this.itemBuffer.canFitItems(trade.getSellItem(0), trade.getSellItem(1)) && this.TryExecuteTrade(tr).isSuccess()) {
                    this.setItemBufferDirty();
                }
            } else if (trade.isPurchase()) {
                if (this.itemBuffer.hasItems(trade.getSellItem(0), trade.getSellItem(1)) && this.TryExecuteTrade(tr).isSuccess()) {
                    this.setItemBufferDirty();
                }
            } else if (trade.isBarter() && this.itemBuffer.hasItems(trade.getBarterItem(0), trade.getBarterItem(1)) && this.itemBuffer.canFitItems(trade.getSellItem(0), trade.getSellItem(1)) && this.TryExecuteTrade(tr).isSuccess()) {
                this.setItemBufferDirty();
            }
        }
    }

    @Override
    protected void hopperTick() {
        AtomicBoolean markBufferDirty = new AtomicBoolean(false);
        for (Direction relativeSide : Direction.values()) {
            BlockPos queryPos;
            BlockEntity be;
            if (!this.itemHandler.allowInputSide(relativeSide) && !this.itemHandler.allowOutputSide(relativeSide)) continue;
            Direction actualSide = relativeSide;
            Block block = this.m_58900_().m_60734_();
            if (block instanceof IRotatableBlock) {
                IRotatableBlock b = (IRotatableBlock)block;
                actualSide = IRotatableBlock.getActualSide(b.getFacing(this.m_58900_()), relativeSide);
            }
            if ((be = this.f_58857_.m_7702_(queryPos = this.f_58858_.m_121945_(actualSide))) == null) continue;
            be.getCapability(ForgeCapabilities.ITEM_HANDLER, actualSide.m_122424_()).ifPresent(itemHandler -> {
                if (this.itemHandler.allowInputSide(relativeSide)) {
                    boolean query = true;
                    for (int i = 0; query && i < itemHandler.getSlots(); ++i) {
                        ItemStack stack = itemHandler.getStackInSlot(i);
                        int fittableAmount = this.itemBuffer.getFittableAmount(stack);
                        if (fittableAmount <= 0) continue;
                        query = false;
                        ItemStack result = itemHandler.extractItem(i, fittableAmount, false);
                        this.itemBuffer.forceAddItem(result);
                        markBufferDirty.set(true);
                    }
                }
                if (this.itemHandler.allowOutputSide(relativeSide)) {
                    List<ItemStack> buffer = this.itemBuffer.getContents();
                    boolean query = true;
                    for (int i = 0; query && i < buffer.size(); ++i) {
                        ItemStack stack = buffer.get(i).m_41777_();
                        if (!this.allowOutput(stack)) continue;
                        for (int slot = 0; query && slot < itemHandler.getSlots(); ++slot) {
                            ItemStack result = itemHandler.insertItem(slot, stack.m_41777_(), false);
                            int placed = stack.m_41613_() - result.m_41613_();
                            if (placed <= 0) continue;
                            query = false;
                            stack.m_41764_(placed);
                            this.itemBuffer.removeItem(stack);
                            markBufferDirty.set(true);
                        }
                    }
                }
            });
        }
        if (markBufferDirty.get()) {
            this.setItemBufferDirty();
        }
    }

    @Override
    public void initMenuTabs(TraderInterfaceMenu menu) {
        menu.setTab(1, new ItemStorageTab(menu));
    }

    @Override
    public boolean allowAdditionalUpgrade(UpgradeType type) {
        return type == Upgrades.ITEM_CAPACITY;
    }

    @Override
    public void getAdditionalContents(List<ItemStack> contents) {
        contents.addAll(this.itemBuffer.getSplitContents());
    }
}

