/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.bank;

import com.google.common.collect.ImmutableMap;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyStorage;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.MoneyHolder;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.BankInterestNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.BankTransferNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.DepositWithdrawNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.LowBalanceNotification;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BankAccount
extends MoneyHolder.Slave
implements IBankAccount {
    private boolean isClient = false;
    private final Runnable markDirty;
    private final MoneyStorage coinStorage = new MoneyStorage(this::markDirty);
    int cardValidation = 0;
    private final Map<String, MoneyValue> notificationLevels = new HashMap<String, MoneyValue>();
    private Consumer<Supplier<Notification>> notificationSender;
    private final NotificationData logger = new NotificationData();
    private String ownerName = "Unknown";

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    public BankAccount flagAsClient() {
        return this.flagAsClient(true);
    }

    public BankAccount flagAsClient(boolean isClient) {
        this.isClient = isClient;
        if (this.isClient) {
            this.logger.flagAsClient();
        }
        return this;
    }

    public BankAccount flagAsClient(IClientTracker parent) {
        return this.flagAsClient(parent.isClient());
    }

    @Override
    public MoneyStorage getMoneyStorage() {
        return this.coinStorage;
    }

    @Override
    public int getCardValidation() {
        return this.cardValidation;
    }

    @Override
    public boolean isCardValid(int validationLevel) {
        return validationLevel >= this.cardValidation;
    }

    @Override
    public void resetCards() {
        ++this.cardValidation;
        this.markDirty();
    }

    @Override
    @Nullable
    protected IMoneyHolder getParent() {
        return this.coinStorage;
    }

    @Override
    public Map<String, MoneyValue> getNotificationLevels() {
        return ImmutableMap.copyOf(this.notificationLevels);
    }

    @Override
    public MoneyValue getNotificationLevelFor(String type) {
        return this.notificationLevels.getOrDefault(type, MoneyValue.empty());
    }

    @Override
    public void setNotificationLevel(String type, MoneyValue value) {
        if (value.isEmpty()) {
            this.notificationLevels.remove(type);
        } else {
            this.notificationLevels.put(type, value);
        }
        this.markDirty();
    }

    public void setNotificationConsumer(Consumer<Supplier<Notification>> notificationSender) {
        this.notificationSender = notificationSender;
    }

    @Override
    public void pushLocalNotification(Notification notification) {
        this.logger.addNotification(notification);
        this.markDirty();
    }

    @Override
    public void pushNotification(Supplier<Notification> notification, boolean notifyPlayers) {
        this.pushLocalNotification(notification.get());
        if (notifyPlayers && this.notificationSender != null) {
            this.notificationSender.accept(notification);
        }
    }

    public static Consumer<Supplier<Notification>> generateNotificationAcceptor(UUID playerID) {
        return notification -> NotificationAPI.API.PushPlayerNotification(playerID, (Notification)notification.get());
    }

    @Override
    public List<Notification> getNotifications() {
        return this.logger.getNotifications();
    }

    public String getOwnersName() {
        return this.ownerName;
    }

    public void updateOwnersName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public MutableComponent getName() {
        return LCText.GUI_BANK_ACCOUNT_NAME.get(this.ownerName);
    }

    @Override
    public void depositMoney(MoneyValue depositAmount) {
        this.coinStorage.addValue(depositAmount);
    }

    @Override
    public MoneyValue withdrawMoney(MoneyValue withdrawAmount) {
        String type = withdrawAmount.getUniqueName();
        if ((withdrawAmount = this.coinStorage.capValue(withdrawAmount)).isEmpty()) {
            return MoneyValue.empty();
        }
        long oldValue = this.coinStorage.valueOf(type).getCoreValue();
        this.coinStorage.removeValue(withdrawAmount);
        MoneyValue notificationLevel = this.getNotificationLevelFor(withdrawAmount.getUniqueName());
        long nl = notificationLevel.getCoreValue();
        if (oldValue >= nl && this.coinStorage.valueOf(type).getCoreValue() < nl) {
            this.pushNotification(LowBalanceNotification.create(this.getName(), notificationLevel));
        }
        return withdrawAmount;
    }

    public void LogInteraction(Player player, MoneyValue amount, boolean isDeposit) {
        this.pushLocalNotification(new DepositWithdrawNotification.Player(PlayerReference.of(player), this.getName(), isDeposit, amount));
    }

    public void LogInteraction(TaxEntry tax, MoneyValue amount) {
        this.pushLocalNotification(new DepositWithdrawNotification.Custom(tax.getName(), this.getName(), true, amount));
    }

    public void LogInteraction(TraderData trader, MoneyValue amount, boolean isDeposit) {
        this.pushLocalNotification(new DepositWithdrawNotification.Custom(trader.getName(), this.getName(), isDeposit, amount));
    }

    public void LogTransfer(Player player, MoneyValue amount, MutableComponent otherAccount, boolean wasReceived) {
        this.pushLocalNotification(new BankTransferNotification(PlayerReference.of(player), amount, this.getName(), otherAccount, wasReceived));
    }

    public BankAccount() {
        this((Runnable)null);
    }

    public BankAccount(Runnable markDirty) {
        this.markDirty = markDirty;
    }

    public BankAccount(CompoundTag compound) {
        this(null, compound);
    }

    public BankAccount(Runnable markDirty, CompoundTag compound) {
        this.markDirty = markDirty;
        this.coinStorage.safeLoad(compound, "CoinStorage");
        this.logger.load(compound.m_128469_("AccountLogs"));
        this.ownerName = compound.m_128461_("OwnerName");
        if (compound.m_128441_("NotificationLevel")) {
            MoneyValue level = MoneyValue.safeLoad(compound, "NotificationLevel");
            if (!level.isEmpty() && !level.isFree()) {
                this.notificationLevels.put(level.getUniqueName(), level);
            }
        } else if (compound.m_128441_("NotificationLevels")) {
            ListTag list = compound.m_128437_("NotificationLevels", 10);
            for (int i = 0; i < list.size(); ++i) {
                MoneyValue level = MoneyValue.load(list.m_128728_(i));
                if (!level.isInvalid() && (level.isFree() || level.isEmpty())) continue;
                this.notificationLevels.put(level.getUniqueName(), level);
            }
        }
        if (compound.m_128441_("CardValidation")) {
            this.cardValidation = compound.m_128451_("CardValidation");
        }
    }

    public void markDirty() {
        if (this.markDirty != null) {
            this.markDirty.run();
        }
    }

    public final CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("CoinStorage", (Tag)this.coinStorage.save());
        compound.m_128365_("AccountLogs", (Tag)this.logger.save());
        compound.m_128359_("OwnerName", this.ownerName);
        ListTag notificationLevelList = new ListTag();
        this.notificationLevels.forEach((key, level) -> notificationLevelList.add((Object)level.save()));
        compound.m_128365_("NotificationLevels", (Tag)notificationLevelList);
        compound.m_128405_("CardValidation", this.cardValidation);
        return compound;
    }

    @Override
    public void formatTooltip(List<Component> tooltip) {
        IMoneyHolder.defaultTooltipFormat(tooltip, this.getTooltipTitle(), this.getStoredMoney());
    }

    @Override
    public Component getTooltipTitle() {
        return LCText.TOOLTIP_MONEY_SOURCE_BANK.get(new Object[0]);
    }

    @Override
    public void applyInterest(double interestMultiplier, List<MoneyValue> limits, List<String> blacklist, boolean forceInterest, boolean notifyPlayers) {
        for (MoneyValue value : this.coinStorage.allValues()) {
            if (!value.allowInterest() || BankAccount.isBlacklisted(blacklist, value)) continue;
            MoneyValue interest = value.multiplyValue(interestMultiplier);
            if (interest.isEmpty() && forceInterest) {
                interest = value.getSmallestValue();
            }
            if (interest.isEmpty()) continue;
            for (MoneyValue limit : limits) {
                if (limit.isEmpty() || !limit.sameType(interest) || !interest.containsValue(limit)) continue;
                interest = limit;
            }
            if (interest.isEmpty()) continue;
            this.depositMoney(interest);
            this.pushNotification(BankInterestNotification.create(this.getName(), interest), notifyPlayers);
        }
    }

    private static boolean isBlacklisted(List<String> blacklist, MoneyValue value) {
        String id = value.getUniqueName();
        return blacklist.stream().anyMatch(entry -> {
            if (entry.endsWith("*")) {
                return id.startsWith(entry.substring(0, entry.length() - 1));
            }
            return entry.equals(id);
        });
    }
}

