/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraftforge.common.util.LazyOptional;

@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@Immutable
public final class ScreenPosition {
    public static final ScreenPosition ZERO = ScreenPosition.of(0, 0);
    public final int x;
    public final int y;

    private ScreenPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public ScreenPosition offset(ScreenPosition other) {
        return ScreenPosition.of(this.x + other.x, this.y + other.y);
    }

    public ScreenPosition offset(int x, int y) {
        return ScreenPosition.of(this.x + x, this.y + y);
    }

    public ScreenPosition offset(AbstractWidget widget) {
        return ScreenPosition.of(this.x + widget.m_252754_(), this.y + widget.m_252907_());
    }

    public ScreenPosition offset(IEasyScreen screen) {
        return this.offset(screen.getCorner());
    }

    public ScreenPosition offsetScreen(AbstractContainerScreen<?> screen) {
        return this.offset(ScreenPosition.getScreenCorner(screen));
    }

    public void setPosition(AbstractWidget widget) {
        widget.m_264152_(this.x, this.y);
    }

    public boolean isMouseInArea(ScreenPosition mousePos, int width, int height) {
        return ScreenArea.of(this, width, height).isMouseInArea(mousePos);
    }

    public boolean isMouseInArea(int mouseX, int mouseY, int width, int height) {
        return ScreenArea.of(this, width, height).isMouseInArea(mouseX, mouseY);
    }

    public boolean isMouseInArea(double mouseX, double mouseY, int width, int height) {
        return ScreenArea.of(this, width, height).isMouseInArea(mouseX, mouseY);
    }

    public ScreenArea asArea(int width, int height) {
        return ScreenArea.of(this, width, height);
    }

    public String toString() {
        return this.x + "," + this.y;
    }

    public static ScreenPosition of(int x, int y) {
        return new ScreenPosition(x, y);
    }

    public static ScreenPosition of(double x, double y) {
        return ScreenPosition.of((int)x, (int)y);
    }

    public static ScreenPosition of(ScreenPosition offset, int x, int y) {
        return offset.offset(x, y);
    }

    public static ScreenPosition of(IEasyScreen screen, int x, int y) {
        return screen.getCorner().offset(x, y);
    }

    public static LazyOptional<ScreenPosition> ofOptional(int x, int y) {
        return LazyOptional.of(() -> ScreenPosition.of(x, y));
    }

    public static ScreenPosition getScreenCorner(AbstractContainerScreen<?> screen) {
        return ScreenPosition.of(screen.getGuiLeft(), screen.getGuiTop());
    }
}

