/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRuleSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.IntParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.DiscountCodes;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class DiscountCodesTab
extends TradeRuleSubTab<DiscountCodes>
implements IScrollable {
    public static final int ROWS = 4;
    String selectedCode = "";
    private int scroll = 0;
    private EditBox entryCreationInput = null;
    private EditBox codeModificationInput = null;
    private EditBox discountInput = null;
    private EditBox limitInput = null;
    private TimeInputWidget timerInput = null;

    public DiscountCodesTab(@Nonnull TradeRulesClientTab<?> parent) {
        super(parent, DiscountCodes.TYPE);
    }

    private boolean hasCodeSelected() {
        return !this.selectedCode.isBlank() && this.getData().containsKey(this.selectedCode);
    }

    private boolean isSelectionMode() {
        return !this.hasCodeSelected();
    }

    private Map<String, DiscountCodes.DiscountRules> getData() {
        DiscountCodes rule = (DiscountCodes)this.getRule();
        return rule == null ? new HashMap() : rule.getRules();
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        for (int i = 0; i < 4; ++i) {
            int index = i;
            this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(30, 10 + 20 * i))).width(screenArea.width - 60)).text(() -> this.getSelectionButtonText(index)).addon(EasyAddonHelper.visibleCheck(() -> this.isSelectionButtonVisible(index)))).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_DISCOUNT_CODES_ENTRY))).pressAction(() -> this.selectEntry(index))).build());
        }
        this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().position(screenArea.pos.offset(30, 10))).size(screenArea.width - 60, 80)).listener(this).build());
        this.addChild(((ScrollBarWidget.Builder)((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(30 + screenArea.width - 60, 30))).height(80).scrollable(this).addon(EasyAddonHelper.visibleCheck(this::isSelectionMode))).build());
        this.entryCreationInput = this.addChild(TextInputUtil.stringBuilder().maxLength(16).position(screenArea.pos.offset(30, 109)).width(screenArea.width - 60).filter(TicketStationRecipe.CODE_INPUT_PREDICATE).build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(screenArea.width - 110, 131))).text(LCText.BUTTON_DISCOUNT_CODES_CREATE).width(80)).addon(EasyAddonHelper.visibleCheck(this::isSelectionMode))).addon(EasyAddonHelper.activeCheck(() -> this.isCodeAvailable(this.entryCreationInput.m_94155_())))).pressAction(() -> {
            String newCode = this.entryCreationInput.m_94155_();
            if (!this.isCodeAvailable(newCode)) {
                return;
            }
            this.sendUpdateMessage(this.builder().setString("Create", newCode));
            this.changeSelection(newCode);
            this.entryCreationInput.m_94144_("");
        })).build());
        this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(10, 10))).icon(IconUtil.ICON_X).pressAction(() -> this.sendUpdateMessage(this.builder().setString("Remove", this.selectedCode)))).addon(EasyAddonHelper.visibleCheck(this::hasCodeSelected))).addon(EasyAddonHelper.tooltip((Component)LCText.TOOLTIP_DISCOUNT_CODES_DELETE.get(new Object[0])))).build());
        this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width - 30, 10))).icon(IconUtil.ICON_BACK).pressAction(() -> this.changeSelection(""))).addon(EasyAddonHelper.visibleCheck(this::hasCodeSelected))).addon(EasyAddonHelper.tooltip((Component)LCText.TOOLTIP_DISCOUNT_CODES_BACK.get(new Object[0])))).build());
        this.codeModificationInput = this.addChild(TextInputUtil.stringBuilder().position(screenArea.pos.offset(40, 10)).width(screenArea.width - 80).maxLength(16).filter(TicketStationRecipe.CODE_INPUT_PREDICATE).build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(40, 35))).width(screenArea.width - 80)).text(LCText.BUTTON_DISCOUNT_CODES_CHANGE).addon(EasyAddonHelper.activeCheck(() -> this.isCodeAvailable(this.codeModificationInput.m_94155_())))).addon(EasyAddonHelper.visibleCheck(this::hasCodeSelected))).pressAction(() -> {
            String newCode = this.codeModificationInput.m_94155_();
            if (!this.isCodeAvailable(newCode)) {
                return;
            }
            this.sendUpdateMessage(this.builder().setString("Edit", this.selectedCode).setString("Rename", newCode));
            this.changeSelection(newCode);
        })).build());
        this.discountInput = this.addChild(TextInputUtil.intBuilder().position(screenArea.pos.offset(20, 75)).width(75).parser(IntParser.ONE_TO_ONE_HUNDRED).maxLength(3).startingValue(10).handler(discount -> this.sendUpdateMessage(this.builder().setString("Edit", this.selectedCode).setInt("Discount", (int)discount))).build());
        this.limitInput = this.addChild(TextInputUtil.intBuilder().position(screenArea.pos.offset(screenArea.width / 2 + 10, 75)).width(75).apply(IntParser.builder().min(0).max(100).consumer()).maxLength(3).handler(limit -> this.sendUpdateMessage(this.builder().setString("Edit", this.selectedCode).setInt("Limit", (int)limit))).build());
        this.timerInput = this.addChild(((TimeInputWidget.Builder)((TimeInputWidget.Builder)TimeInputWidget.builder().position(screenArea.pos.offset(screenArea.width / 2 - 25, 108))).unitRange(TimeUtil.TimeUnit.HOUR, TimeUtil.TimeUnit.DAY).maxDuration(31536000000L).handler(time -> this.sendUpdateMessage(this.builder().setString("Edit", this.selectedCode).setLong("Timer", time.miliseconds))).addon(EasyAddonHelper.visibleCheck(this::hasCodeSelected))).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        this.validateWidgets();
        if (this.hasCodeSelected()) {
            gui.drawString((Component)LCText.GUI_DISCOUNT_CODES_DISCOUNT.get(new Object[0]), 20, 65, 0x404040);
            gui.drawString((Component)LCText.GUI_DISCOUNT_CODES_LIMIT.get(new Object[0]), this.screen.getXSize() / 2 + 10, 65, 0x404040);
            DiscountCodes.DiscountRules rule = this.getData().get(this.selectedCode);
            if (rule == null) {
                return;
            }
            MutableComponent text = rule.timeLimit > 0L ? LCText.GUI_PLAYER_TRADE_LIMIT_DURATION.get(new TimeUtil.TimeData(rule.timeLimit).getShortString()) : LCText.GUI_PLAYER_TRADE_LIMIT_NO_DURATION.get(new Object[0]);
            TextRenderUtil.drawCenteredText(gui, (Component)text, this.screen.getXSize() / 2, 98, 0x404040);
        }
    }

    private void validateWidgets() {
        this.entryCreationInput.f_93624_ = this.isSelectionMode();
        this.discountInput.f_93624_ = this.limitInput.f_93624_ = this.hasCodeSelected();
        this.codeModificationInput.f_93624_ = this.limitInput.f_93624_;
    }

    @Nullable
    private Pair<String, DiscountCodes.DiscountRules> getEntry(int index) {
        ArrayList<Map.Entry<String, DiscountCodes.DiscountRules>> list = new ArrayList<Map.Entry<String, DiscountCodes.DiscountRules>>(this.getData().entrySet());
        if ((index += this.scroll) < 0 || index >= list.size()) {
            return null;
        }
        Map.Entry entry = (Map.Entry)list.get(index);
        return Pair.of((Object)((String)entry.getKey()), (Object)((DiscountCodes.DiscountRules)entry.getValue()));
    }

    private void changeSelection(String newSelection) {
        this.selectedCode = newSelection;
        this.codeModificationInput.m_94144_(newSelection);
        DiscountCodes.DiscountRules rules = this.getData().get(newSelection);
        if (rules == null) {
            return;
        }
        this.discountInput.m_94144_(String.valueOf(rules.discount));
        this.limitInput.m_94144_(String.valueOf(rules.limit));
        this.timerInput.setTime(rules.timeLimit);
    }

    private boolean isSelectionButtonVisible(int index) {
        if (this.hasCodeSelected()) {
            return false;
        }
        return this.getEntry(index) != null;
    }

    private Component getSelectionButtonText(int index) {
        Pair<String, DiscountCodes.DiscountRules> entry = this.getEntry(index);
        if (entry != null) {
            return LCText.BUTTON_DISCOUNT_CODES_ENTRY.get(entry.getFirst(), ((DiscountCodes.DiscountRules)entry.getSecond()).discount);
        }
        return EasyText.empty();
    }

    private void selectEntry(int index) {
        Pair<String, DiscountCodes.DiscountRules> entry = this.getEntry(index);
        if (entry != null) {
            this.changeSelection((String)entry.getFirst());
        }
    }

    @Override
    public boolean handleScrollWheel(double delta) {
        if (this.hasCodeSelected()) {
            return false;
        }
        return IScrollable.super.handleScrollWheel(delta);
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(4, this.getData().size());
    }

    private boolean isCodeAvailable(String newCode) {
        return TicketStationRecipe.CODE_PREDICATE.test(newCode) && !this.getData().containsKey(newCode);
    }
}

