/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.info.core;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.info.InfoSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.info.TraderInfoClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.notifications.NotificationDisplayWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.MutableComponent;

public class TraderLogClientTab
extends InfoSubTab {
    private final boolean settingsView;
    private final Predicate<Notification> filter;

    public TraderLogClientTab(TraderInfoClientTab tab, boolean settingsView) {
        super(tab);
        this.settingsView = settingsView;
        this.filter = this.settingsView ? TraderData.LOGS_SETTINGS_FILTER : TraderData.LOGS_NORMAL_FILTER;
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return this.settingsView ? IconUtil.ICON_SETTINGS : IconUtil.ICON_SHOW_LOGGER;
    }

    public MutableComponent getTooltip() {
        return this.settingsView ? LCText.TOOLTIP_TRADER_LOGS_SETTINGS.get(new Object[0]) : LCText.TOOLTIP_TRADER_LOGS.get(new Object[0]);
    }

    @Override
    public boolean canOpen() {
        return this.menu.hasPermission("viewLogs") && (!this.settingsView || this.menu.hasPermission("editSettings"));
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        NotificationDisplayWidget notificationWidget = this.addChild(((NotificationDisplayWidget.Builder)NotificationDisplayWidget.builder().position(screenArea.pos.offset(15, 10))).width(screenArea.width - 30).rowCount(5).notificationSource(this::getNotifications).build());
        notificationWidget.setDeletionHandler(this::DeleteNotification, this::canDeleteNotification);
        this.addChild(ScrollBarWidget.builder().onRight(notificationWidget).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
    }

    private List<Notification> getNotifications() {
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            return trader.getNotifications(this.filter);
        }
        return new ArrayList<Notification>();
    }

    public boolean canDeleteNotification() {
        return this.menu.hasPermission("transferOwnership");
    }

    public void DeleteNotification(int notificationIndex) {
        this.sendMessage(this.builder().setInt("DeleteNotification", notificationIndex).setBoolean("SettingsView", this.settingsView));
    }
}

