/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.core;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsNode;
import io.github.lightman314.lightmanscurrency.api.settings.data.NodeSelections;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.SettingsClipboardTab;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;

public class SettingsClipboardClientTab
extends TraderStorageClientTab<SettingsClipboardTab>
implements IScrollable {
    public static final int NODES_PER_PAGE = 8;
    private NodeSelections selections = new NodeSelections();
    private final List<Pair<String, PlainButton>> toggleSwitches = new ArrayList<Pair<String, PlainButton>>();
    private int scroll = 0;

    public SettingsClipboardClientTab(Object screen, SettingsClipboardTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(10, 120))).width(74)).text(LCText.BUTTON_TRADER_SETTINGS_COPY).pressAction(this::tryCopy)).addon(EasyAddonHelper.activeCheck(((SettingsClipboardTab)this.commonTab)::canWriteSettings))).build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(122, 120))).width(74)).text(LCText.BUTTON_TRADER_SETTINGS_PASTE).pressAction(this::tryLoad)).addon(EasyAddonHelper.activeCheck(((SettingsClipboardTab)this.commonTab)::canReadSettings))).build());
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(10, 8))).height(112).scrollable(this).build());
        this.addChild(((ScrollListener.Builder)ScrollListener.builder().area(screenArea.ofSize(screenArea.width, 142))).listener(this).build());
        if (trader == null) {
            return;
        }
        if (firstOpen) {
            this.scroll = 0;
            this.selections = trader.defaultNodeSelections(((ITraderStorageMenu)this.menu).getPlayer());
        }
        this.toggleSwitches.clear();
        for (SettingsNode node : trader.getAllSettingNodes()) {
            PlainButton button = this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(20, 0))).sprite(IconAndButtonUtil.SPRITE_CHECK(() -> this.isNodeSelected(node.key))).pressAction(() -> this.toggleNode(node.key))).build());
            this.toggleSwitches.add((Pair<String, PlainButton>)Pair.of((Object)node.key, (Object)((Object)button)));
        }
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        this.validateScroll();
        List<SettingsNode> visibleNodes = this.refactorToggleButtons();
        gui.renderSlot((IEasyScreen)this.screen, ((SettingsClipboardTab)this.commonTab).getSlot());
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        int startIndex = this.scroll;
        int y = 9;
        for (SettingsNode node : visibleNodes) {
            gui.drawString((Component)node.getName(), 32, y, 0x404040);
            y += 14;
        }
    }

    private List<SettingsNode> refactorToggleButtons() {
        ArrayList<SettingsNode> visibleNodes = new ArrayList<SettingsNode>();
        int index = 0;
        int visibleIndex = 0;
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        ScreenPosition corner = ((ITraderStorageScreen)this.screen).getCorner();
        for (Pair<String, PlainButton> pair : this.toggleSwitches) {
            SettingsNode node;
            SettingsNode settingsNode = node = trader == null ? null : trader.getNode((String)pair.getFirst());
            if (node == null || !node.allowSelecting(((ITraderStorageMenu)this.menu).getPlayer())) {
                ((PlainButton)((Object)pair.getSecond())).setVisible(false);
                continue;
            }
            if (index < this.scroll || index >= this.scroll + 8) {
                ((PlainButton)((Object)pair.getSecond())).setVisible(false);
            } else {
                PlainButton toggle = (PlainButton)((Object)pair.getSecond());
                toggle.setVisible(true);
                toggle.setPosition(corner.offset(20, 8 + 14 * visibleIndex));
                visibleNodes.add(node);
                ++visibleIndex;
            }
            ++index;
        }
        return visibleNodes;
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconUtil.ICON_COUNT;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_TRADER_SETTINGS_CLIPBOARD.get(new Object[0]);
    }

    private boolean isNodeSelected(String node) {
        return this.selections.nodeSelected(node);
    }

    private void toggleNode(String node) {
        this.selections.toggleNode(node);
    }

    private void tryCopy() {
        ((SettingsClipboardTab)this.commonTab).copySettings(this.selections);
    }

    private void tryLoad() {
        ((SettingsClipboardTab)this.commonTab).loadSettings(this.selections);
    }

    public int getVisibleNodes() {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        if (trader == null) {
            return 0;
        }
        return (int)this.toggleSwitches.stream().filter(p -> {
            SettingsNode node = trader.getNode((String)p.getFirst());
            return node != null && node.allowSelecting(((ITraderStorageMenu)this.menu).getPlayer());
        }).count();
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(8, this.getVisibleNodes());
    }
}

