/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_chest;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_chest.CoinChestTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.OwnerSelectionWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestSecurityUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SecurityUpgradeTab
extends CoinChestTab.Upgrade {
    OwnerSelectionWidget ownerSelectionWidget;
    private boolean manualSelectionMode = false;
    EditBox playerOwnerInput;
    EasyButton setPlayerButton;
    EasyButton buttonToggleInputMode;

    public SecurityUpgradeTab(CoinChestUpgradeData data, Object screen) {
        super(data, screen);
    }

    @Override
    public boolean isVisible() {
        CoinChestUpgrade coinChestUpgrade;
        CoinChestUpgradeData data = this.getUpgradeData();
        if (data != null && (coinChestUpgrade = data.upgrade) instanceof CoinChestSecurityUpgrade) {
            CoinChestSecurityUpgrade upgrade = (CoinChestSecurityUpgrade)coinChestUpgrade;
            return upgrade.isAdmin(this.screen.be, data, ((CoinChestMenu)this.screen.m_6262_()).player);
        }
        return false;
    }

    @Override
    public boolean coinSlotsVisible() {
        return false;
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public boolean titleVisible() {
        return false;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.playerOwnerInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 10, screenArea.y + 30, this.screen.getXSize() - 20, 20, (Component)EasyText.empty()));
        this.playerOwnerInput.m_94199_(16);
        this.setPlayerButton = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(10, 60))).width(screenArea.width - 20)).text(LCText.BUTTON_OWNER_SET_PLAYER).pressAction(this::SetPlayerOwner)).addon(EasyAddonHelper.tooltip((Component)LCText.TOOLTIP_WARNING_CANT_BE_UNDONE.getWithStyle(ChatFormatting.YELLOW, ChatFormatting.BOLD)))).build());
        this.ownerSelectionWidget = this.addChild(((OwnerSelectionWidget.Builder)OwnerSelectionWidget.builder().position(screenArea.pos.offset(7, 27))).width(screenArea.width - 22).rows(5).selected(this::getCurrentOwner).handler(this::setOwner).oldWidget(this.ownerSelectionWidget).build());
        this.buttonToggleInputMode = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width - 25, 5))).pressAction(this::toggleInputMode)).icon(this::getModeIcon).addon(EasyAddonHelper.tooltip(this::getModeTooltip))).build());
        this.updateMode();
    }

    @Nullable
    protected OwnerData getCurrentOwner() {
        CoinChestUpgrade coinChestUpgrade;
        CoinChestUpgradeData data = this.getUpgradeData();
        if (data != null && (coinChestUpgrade = data.upgrade) instanceof CoinChestSecurityUpgrade) {
            CoinChestSecurityUpgrade upgrade = (CoinChestSecurityUpgrade)coinChestUpgrade;
            return upgrade.parseOwnerData(this.menu.be, data);
        }
        return null;
    }

    private Component getOwnerName() {
        OwnerData data = this.getCurrentOwner();
        if (data != null) {
            return data.getName();
        }
        return LCText.GUI_OWNER_NULL.get(new Object[0]);
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString(TextRenderUtil.fitString((Component)LCText.GUI_OWNER_CURRENT.get(this.getOwnerName()), this.screen.getXSize() - 20), 8, 6, 0x404040);
    }

    private void SetPlayerOwner(EasyButton button) {
        if (this.playerOwnerInput.m_94155_().isBlank()) {
            return;
        }
        this.menu.SendMessageToServer(this.builder().setString("SetPlayerOwner", this.playerOwnerInput.m_94155_()));
        this.playerOwnerInput.m_94144_("");
    }

    private void setOwner(Owner newOwner) {
        this.menu.SendMessageToServer(this.builder().setOwner("SetOwner", newOwner));
    }

    @Override
    public void tick() {
        if (this.manualSelectionMode) {
            this.setPlayerButton.f_93623_ = !this.playerOwnerInput.m_94155_().isBlank();
        }
    }

    private void toggleInputMode(EasyButton button) {
        this.manualSelectionMode = !this.manualSelectionMode;
        this.updateMode();
    }

    private void updateMode() {
        this.playerOwnerInput.f_93624_ = this.setPlayerButton.f_93624_ = this.manualSelectionMode;
        if (this.manualSelectionMode) {
            this.setPlayerButton.f_93623_ = !this.playerOwnerInput.m_94155_().isBlank();
        }
        this.ownerSelectionWidget.setVisible(!this.manualSelectionMode);
    }

    private IconData getModeIcon() {
        return this.manualSelectionMode ? IconData.of((ItemLike)Items.f_42116_) : IconUtil.ICON_ALEX_HEAD;
    }

    private Component getModeTooltip() {
        return this.manualSelectionMode ? LCText.TOOLTIP_OWNERSHIP_MODE_SELECTION.get(new Object[0]) : LCText.TOOLTIP_OWNERSHIP_MODE_MANUAL.get(new Object[0]);
    }
}

