/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.client.data.ClientPlayerNameCache;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.BankAccountSelectionWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.ATMMenu;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketBankTransferAccount;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketBankTransferPlayer;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullSupplier;

public class TransferTab
extends ATMTab {
    public static final int RESPONSE_DURATION = 100;
    private int responseTimer = 0;
    MoneyValueWidget amountWidget;
    BankAccountSelectionWidget accountSelectionWidget;
    EditBox playerInput;
    IconButton buttonToggleMode;
    EasyButton buttonTransfer;
    boolean playerMode = false;
    BankReference selectedAccount = null;

    public TransferTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconUtil.ICON_STORE_COINS;
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_ATM_TRANSFER.get(new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.screen.setCoinSlotsActive(false);
        this.responseTimer = 0;
        if (firstOpen) {
            ((ATMMenu)this.screen.m_6262_()).clearMessage();
        }
        this.amountWidget = this.addChild(((MoneyValueWidget.Builder)MoneyValueWidget.builder().position(screenArea.pos)).oldIfNotFirst(firstOpen, this.amountWidget).blockFreeInputs().build());
        this.accountSelectionWidget = this.addChild(((BankAccountSelectionWidget.Builder)BankAccountSelectionWidget.builder().position(screenArea.pos.offset(10, 84))).width(screenArea.width - 20).rows(3).filter(this::allowAccount).selected(() -> this.selectedAccount).handler(r -> {
            this.selectedAccount = r;
        }).build());
        this.accountSelectionWidget.f_93624_ = !this.playerMode;
        this.playerInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 10, screenArea.y + 104, screenArea.width - 20, 20, (Component)Component.m_237119_()));
        this.playerInput.f_93624_ = this.playerMode;
        this.buttonToggleMode = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width, 84))).pressAction(this::ToggleMode)).icon(() -> this.playerMode ? IconData.of((ItemLike)Items.f_42680_) : IconUtil.ICON_ALEX_HEAD).addon(EasyAddonHelper.toggleTooltip((NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.playerMode), (Component)LCText.TOOLTIP_ATM_TRANSFER_MODE_LIST.get(new Object[0]), (Component)LCText.TOOLTIP_ATM_TRANSFER_MODE_PLAYER.get(new Object[0])))).build());
        this.buttonTransfer = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width, 124))).pressAction(this::PressTransfer)).icon(IconUtil.ICON_STORE_COINS).color(this::getTransferColor).addon(EasyAddonHelper.activeCheck(this::canTriggerTransfer))).addon(EasyAddonHelper.tooltip(this::getTransferTooltip))).build());
    }

    private boolean allowAccount(BankReference reference) {
        return reference != null && !reference.equals(this.menu.getBankAccountReference());
    }

    private int getTransferColor(IconButton button) {
        if (button.m_142518_()) {
            UUID playerID;
            if (this.playerMode && (playerID = ClientPlayerNameCache.lookupID(this.playerInput.m_94155_())) == null) {
                return ChatFormatting.GOLD.m_126665_();
            }
            return 65280;
        }
        return 0xFFFFFF;
    }

    private Component getTransferTooltip() {
        IBankAccount account;
        if (this.playerMode) {
            UUID playerID = ClientPlayerNameCache.lookupID(this.playerInput.m_94155_());
            if (playerID == null) {
                return null;
            }
            String playerName = ClientPlayerNameCache.lookupName(playerID);
            if (playerName == null) {
                playerName = this.playerInput.m_94155_();
            }
            return LCText.TOOLTIP_ATM_TRANSFER_TRIGGER.get(this.amountWidget.getCurrentValue().getText(), LCText.GUI_BANK_ACCOUNT_NAME.get(playerName));
        }
        if (this.selectedAccount != null && (account = this.selectedAccount.get()) != null) {
            return LCText.TOOLTIP_ATM_TRANSFER_TRIGGER.get(this.amountWidget.getCurrentValue().getText(), this.selectedAccount.get().getName());
        }
        return null;
    }

    private void PressTransfer(EasyButton button) {
        if (this.playerMode) {
            new CPacketBankTransferPlayer(this.playerInput.m_94155_(), this.amountWidget.getCurrentValue()).send();
            this.playerInput.m_94144_("");
            this.amountWidget.changeValue(MoneyValue.empty());
        } else if (this.selectedAccount != null) {
            new CPacketBankTransferAccount(this.selectedAccount, this.amountWidget.getCurrentValue()).send();
            this.amountWidget.changeValue(MoneyValue.empty());
        }
    }

    private void ToggleMode(EasyButton button) {
        this.playerMode = !this.playerMode;
        this.accountSelectionWidget.f_93624_ = !this.playerMode;
        this.playerInput.f_93624_ = this.playerMode;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        MutableComponent balance = ((ATMMenu)this.screen.m_6262_()).getBankAccount() == null ? LCText.GUI_BANK_NO_SELECTED_ACCOUNT.get(new Object[0]) : ((ATMMenu)this.screen.m_6262_()).getBankAccount().getBalanceText();
        gui.drawString((Component)balance, 8, 72, 0x404040);
        if (this.hasMessage()) {
            TextRenderUtil.drawCenteredMultilineText(gui, this.getMessage(), 2, this.screen.getXSize() - 4, 5, 0x404040);
            this.amountWidget.f_93624_ = false;
        } else {
            this.amountWidget.f_93624_ = true;
        }
    }

    private boolean canTriggerTransfer() {
        if (this.amountWidget.getCurrentValue().isEmpty()) {
            return false;
        }
        if (this.playerMode) {
            UUID playerID = ClientPlayerNameCache.lookupID(this.playerInput.m_94155_());
            if (playerID == null) {
                return false;
            }
            BankReference bankReference = this.menu.getBankAccountReference();
            if (bankReference instanceof PlayerBankReference) {
                PlayerBankReference prb = (PlayerBankReference)bankReference;
                return !prb.getPlayer().is(playerID);
            }
            return true;
        }
        return this.selectedAccount != null;
    }

    @Override
    public void tick() {
        if (this.hasMessage()) {
            ++this.responseTimer;
            if (this.responseTimer >= 100) {
                this.responseTimer = 0;
                ((ATMMenu)this.screen.m_6262_()).clearMessage();
            }
        }
    }

    private boolean hasMessage() {
        return ((ATMMenu)this.screen.m_6262_()).hasTransferMessage();
    }

    private Component getMessage() {
        return ((ATMMenu)this.screen.m_6262_()).getTransferMessage();
    }

    @Override
    public void closeAction() {
        this.screen.setCoinSlotsActive(true);
        this.responseTimer = 0;
        ((ATMMenu)this.screen.m_6262_()).clearMessage();
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }
}

